/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.mixin.mixins.rendering.feature;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WolfCollarLayer;
import net.minecraft.world.entity.animal.Wolf;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.models.IEMFModel;
import traben.entity_model_features.models.parts.EMFModelPartRoot;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.IEMFWolfCollarHolder;

@Mixin(value={WolfCollarLayer.class})
public abstract class MixinWolfCollarFeatureRenderer
extends RenderLayer<Wolf, WolfModel<Wolf>> {
    @Unique
    private static final ModelLayerLocation emf$collar_layer = new ModelLayerLocation(EMFUtils.res("minecraft", "wolf"), "collar");
    @Unique
    private static final ModelLayerLocation emf$collar_layer_baby = new ModelLayerLocation(EMFUtils.res("minecraft", "wolf_baby"), "collar");

    public MixinWolfCollarFeatureRenderer() {
        super(null);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/RenderLayerParent;)V"}, at={@At(value="TAIL")})
    private void setEmf$Model(RenderLayerParent<?, ?> featureRendererContext, CallbackInfo ci) {
        if (EMF.testForForgeLoadingError()) {
            return;
        }
        ModelPart collarModel = EMFManager.getInstance().injectIntoModelRootGetter(emf$collar_layer, WolfModel.m_171088_().m_171564_());
        if (collarModel instanceof EMFModelPartRoot || ((IEMFModel)featureRendererContext.m_7200_()).emf$isEMFModel()) {
            try {
                EntityModel entityModel = featureRendererContext.m_7200_();
                if (entityModel instanceof IEMFWolfCollarHolder) {
                    IEMFWolfCollarHolder holder = (IEMFWolfCollarHolder)entityModel;
                    holder.emf$setCollarModel(new WolfModel(collarModel));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @NotNull
    public WolfModel<Wolf> getParentModel() {
        IEMFWolfCollarHolder holder;
        WolfModel base = (WolfModel)super.m_117386_();
        if (base instanceof IEMFWolfCollarHolder && (holder = (IEMFWolfCollarHolder)base).emf$hasCollarModel()) {
            WolfModel model = holder.emf$getCollarModel();
            model.f_102608_ = base.f_102608_;
            model.f_102609_ = base.f_102609_;
            model.f_102610_ = base.f_102610_;
            return model;
        }
        return base;
    }
}

