/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.gui.AbstractComputerScreen;
import dan200.computercraft.client.gui.GuiSprites;
import dan200.computercraft.client.gui.widgets.ComputerSidebar;
import dan200.computercraft.client.gui.widgets.TerminalWidget;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.SpriteRenderer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class TurtleScreen
extends AbstractComputerScreen<TurtleMenu> {
    private static final ResourceLocation BACKGROUND_NORMAL = new ResourceLocation("computercraft", "textures/gui/turtle_normal.png");
    private static final ResourceLocation BACKGROUND_ADVANCED = new ResourceLocation("computercraft", "textures/gui/turtle_advanced.png");
    private static final int TEX_WIDTH = 278;
    private static final int TEX_HEIGHT = 217;
    private static final int FULL_TEX_SIZE = 512;

    public TurtleScreen(TurtleMenu container, Inventory player, Component title) {
        super(container, player, title, 8);
        this.f_97726_ = 295;
        this.f_97727_ = 217;
    }

    @Override
    protected TerminalWidget createTerminal() {
        return new TerminalWidget(this.terminalData, this.computerInput, this.computerActions, this.f_97735_ + 8 + 17, this.f_97736_ + 8);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        boolean advanced = this.family == ComputerFamily.ADVANCED;
        ResourceLocation texture = advanced ? BACKGROUND_ADVANCED : BACKGROUND_NORMAL;
        graphics.m_280398_(texture, this.f_97735_ + 17, this.f_97736_, 0, 0.0f, 0.0f, 278, 217, 512, 512);
        int slot = ((TurtleMenu)this.m_6262_()).getSelectedSlot();
        if (slot >= 0) {
            int slotX = slot % 4;
            int slotY = slot / 4;
            graphics.m_280159_(this.f_97735_ + 192 - 2 + slotX * 18, this.f_97736_ + 134 - 2 + slotY * 18, 0, 22, 22, GuiSprites.get(advanced ? GuiSprites.TURTLE_ADVANCED_SELECTED_SLOT : GuiSprites.TURTLE_NORMAL_SELECTED_SLOT));
        }
        SpriteRenderer spriteRenderer = SpriteRenderer.createForGui(graphics, RenderTypes.GUI_SPRITES);
        ComputerSidebar.renderBackground(spriteRenderer, GuiSprites.getComputerTextures(this.family), this.f_97735_, this.f_97736_ + this.sidebarYOffset);
        graphics.m_280262_();
    }
}

