/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes.astralsorcery;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AstralSorceryAmuletAttribute
implements ItemAttribute {
    String enchName;
    int enchType;

    public AstralSorceryAmuletAttribute(String enchName, int enchType) {
        this.enchName = enchName;
        this.enchType = enchType;
    }

    private static ListTag extractTraitList(ItemStack stack) {
        return stack.m_41783_() != null ? stack.m_41783_().m_128469_("astralsorcery").m_128437_("amuletEnchantments", 10) : new ListTag();
    }

    @Override
    public boolean appliesTo(ItemStack itemStack, Level level) {
        for (Tag trait : AstralSorceryAmuletAttribute.extractTraitList(itemStack)) {
            if (!((CompoundTag)trait).m_128461_("ench").equals(this.enchName) || ((CompoundTag)trait).m_128451_("type") != this.enchType) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTranslationKey() {
        return "astralsorcery_amulet";
    }

    @Override
    public Object[] getTranslationParameters() {
        Object something = "";
        Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)this.enchName));
        if (enchant != null) {
            something = Component.m_237115_((String)enchant.m_44704_()).getString();
        }
        if (this.enchType == 1) {
            something = "existing " + (String)something;
        }
        return new Object[]{something};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.ASTRAL_AMULET;
    }

    @Override
    public void save(CompoundTag nbt) {
        nbt.m_128359_("enchName", this.enchName);
        nbt.m_128405_("enchType", this.enchType);
    }

    @Override
    public void load(CompoundTag nbt) {
        this.enchName = nbt.m_128461_("enchName");
        this.enchType = nbt.m_128451_("enchType");
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new AstralSorceryAmuletAttribute("dummy", -1);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(ItemStack itemStack, Level level) {
            ListTag traits = AstralSorceryAmuletAttribute.extractTraitList(itemStack);
            ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
            for (int i = 0; i < traits.size(); ++i) {
                atts.add(new AstralSorceryAmuletAttribute(traits.m_128728_(i).m_128461_("ench"), traits.m_128728_(i).m_128451_("type")));
            }
            return atts;
        }
    }
}

