/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.SchematicInstances;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.client.SchematicHotbarSlotOverlay;
import com.simibubi.create.content.schematics.client.SchematicRenderer;
import com.simibubi.create.content.schematics.client.SchematicTransformation;
import com.simibubi.create.content.schematics.client.ToolSelectionScreen;
import com.simibubi.create.content.schematics.client.tools.ToolType;
import com.simibubi.create.content.schematics.packet.SchematicPlacePacket;
import com.simibubi.create.content.schematics.packet.SchematicSyncPacket;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.outliner.AABBOutline;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class SchematicHandler
implements IGuiOverlay {
    private String displayedSchematic;
    private SchematicTransformation transformation;
    private AABB bounds;
    private boolean deployed;
    private boolean active;
    private ToolType currentTool;
    private static final int SYNC_DELAY = 10;
    private int syncCooldown;
    private int activeHotbarSlot;
    private ItemStack activeSchematicItem;
    private AABBOutline outline;
    private final SchematicRenderer[] renderers = new SchematicRenderer[3];
    private final SchematicHotbarSlotOverlay overlay = new SchematicHotbarSlotOverlay();
    private ToolSelectionScreen selectionScreen;

    public SchematicHandler() {
        this.currentTool = ToolType.DEPLOY;
        this.selectionScreen = new ToolSelectionScreen((List<ToolType>)ImmutableList.of((Object)((Object)ToolType.DEPLOY)), this::equip);
        this.transformation = new SchematicTransformation();
    }

    public void tick() {
        LocalPlayer player;
        ItemStack stack;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            if (this.active) {
                this.active = false;
                this.syncCooldown = 0;
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
            }
            return;
        }
        if (this.activeSchematicItem != null && this.transformation != null) {
            this.transformation.tick();
        }
        if ((stack = this.findBlueprintInHand((Player)(player = mc.f_91074_))) == null) {
            this.active = false;
            this.syncCooldown = 0;
            if (this.activeSchematicItem != null && this.itemLost((Player)player)) {
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
            }
            return;
        }
        if (!this.active || !stack.m_41783_().m_128461_("File").equals(this.displayedSchematic)) {
            this.init(player, stack);
        }
        if (!this.active) {
            return;
        }
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
        }
        if (this.syncCooldown == 1) {
            this.sync();
        }
        this.selectionScreen.update();
        this.currentTool.getTool().updateSelection();
    }

    private void init(LocalPlayer player, ItemStack stack) {
        this.loadSettings(stack);
        this.displayedSchematic = stack.m_41783_().m_128461_("File");
        this.active = true;
        if (this.deployed) {
            this.setupRenderer();
            ToolType toolBefore = this.currentTool;
            this.selectionScreen = new ToolSelectionScreen(ToolType.getTools(player.m_7500_()), this::equip);
            if (toolBefore != null) {
                this.selectionScreen.setSelectedElement(toolBefore);
                this.equip(toolBefore);
            }
        } else {
            this.selectionScreen = new ToolSelectionScreen((List<ToolType>)ImmutableList.of((Object)((Object)ToolType.DEPLOY)), this::equip);
        }
    }

    private void setupRenderer() {
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        StructureTemplate schematic = SchematicItem.loadSchematic((Level)clientWorld, this.activeSchematicItem);
        Vec3i size = schematic.m_163801_();
        if (size.equals((Object)Vec3i.f_123288_)) {
            return;
        }
        SchematicLevel w = new SchematicLevel((Level)clientWorld);
        SchematicLevel wMirroredFB = new SchematicLevel((Level)clientWorld);
        SchematicLevel wMirroredLR = new SchematicLevel((Level)clientWorld);
        StructurePlaceSettings placementSettings = new StructurePlaceSettings();
        BlockPos pos = BlockPos.f_121853_;
        try {
            schematic.m_230328_((ServerLevelAccessor)w, pos, pos, placementSettings, w.m_213780_(), 2);
            for (BlockEntity blockEntity : w.getBlockEntities()) {
                blockEntity.m_142339_((Level)w);
            }
            this.fixControllerBlockEntities(w);
        }
        catch (Exception e) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)CreateLang.translate("schematic.error", new Object[0]).component(), false);
            Create.LOGGER.error("Failed to load Schematic for Previewing", (Throwable)e);
            return;
        }
        placementSettings.m_74377_(Mirror.FRONT_BACK);
        pos = BlockPos.f_121853_.m_122030_(size.m_123341_() - 1);
        schematic.m_230328_((ServerLevelAccessor)wMirroredFB, pos, pos, placementSettings, wMirroredFB.m_213780_(), 2);
        StructureTransform transform = new StructureTransform(placementSettings.m_74407_(), Direction.Axis.Y, Rotation.NONE, placementSettings.m_74401_());
        for (BlockEntity be : wMirroredFB.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        this.fixControllerBlockEntities(wMirroredFB);
        placementSettings.m_74377_(Mirror.LEFT_RIGHT);
        pos = BlockPos.f_121853_.m_122020_(size.m_123343_() - 1);
        schematic.m_230328_((ServerLevelAccessor)wMirroredLR, pos, pos, placementSettings, wMirroredFB.m_213780_(), 2);
        transform = new StructureTransform(placementSettings.m_74407_(), Direction.Axis.Y, Rotation.NONE, placementSettings.m_74401_());
        for (BlockEntity be : wMirroredLR.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        this.fixControllerBlockEntities(wMirroredLR);
        this.renderers[0] = new SchematicRenderer(w);
        this.renderers[1] = new SchematicRenderer(wMirroredFB);
        this.renderers[2] = new SchematicRenderer(wMirroredLR);
    }

    private void fixControllerBlockEntities(SchematicLevel level) {
        for (BlockEntity blockEntity : level.getBlockEntities()) {
            if (!(blockEntity instanceof IMultiBlockEntityContainer)) continue;
            IMultiBlockEntityContainer multiBlockEntity = (IMultiBlockEntityContainer)blockEntity;
            BlockPos lastKnown = multiBlockEntity.getLastKnownPos();
            BlockPos current = blockEntity.m_58899_();
            if (lastKnown == null || current == null || multiBlockEntity.isController() || lastKnown.equals((Object)current)) continue;
            BlockPos newControllerPos = multiBlockEntity.getController().m_121955_((Vec3i)current.m_121996_((Vec3i)lastKnown));
            if (multiBlockEntity instanceof SmartBlockEntity) {
                SmartBlockEntity sbe = (SmartBlockEntity)((Object)multiBlockEntity);
                sbe.markVirtual();
            }
            multiBlockEntity.setController(newControllerPos);
        }
    }

    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera) {
        boolean fb;
        boolean present;
        if (!this.active) {
            return;
        }
        boolean bl = present = this.activeSchematicItem != null;
        if (!present) {
            return;
        }
        ms.m_85836_();
        this.currentTool.getTool().renderTool(ms, buffer, camera);
        ms.m_85849_();
        ms.m_85836_();
        this.transformation.applyTransformations(ms, camera);
        float pt = AnimationTickHolder.getPartialTicks();
        boolean lr = this.transformation.getScaleLR().getValue(pt) < 0.0f;
        boolean bl2 = fb = this.transformation.getScaleFB().getValue(pt) < 0.0f;
        if (lr && !fb && this.renderers[2] != null) {
            this.renderers[2].render(ms, buffer);
        } else if (fb && !lr && this.renderers[1] != null) {
            this.renderers[1].render(ms, buffer);
        } else if (this.renderers[0] != null) {
            this.renderers[0].render(ms, buffer);
        }
        this.currentTool.getTool().renderOnSchematic(ms, buffer);
        ms.m_85849_();
    }

    public void updateRenderers() {
        for (SchematicRenderer renderer : this.renderers) {
            if (renderer == null) continue;
            renderer.update();
        }
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        if (Minecraft.m_91087_().f_91066_.f_92062_ || !this.active) {
            return;
        }
        if (this.activeSchematicItem != null) {
            this.overlay.renderOn(graphics, this.activeHotbarSlot);
        }
        this.currentTool.getTool().renderOverlay(gui, graphics, partialTicks, width, height);
        this.selectionScreen.renderPassive(graphics, partialTicks);
    }

    public boolean onMouseInput(int button, boolean pressed) {
        if (!this.active) {
            return false;
        }
        if (!pressed || button != 1) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_.m_6144_()) {
            return false;
        }
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockRayTraceResult = (BlockHitResult)hitResult;
            BlockState clickedBlock = mc.f_91073_.m_8055_(blockRayTraceResult.m_82425_());
            if (AllBlocks.SCHEMATICANNON.has(clickedBlock)) {
                return false;
            }
            if (AllBlocks.DEPLOYER.has(clickedBlock)) {
                return false;
            }
        }
        return this.currentTool.getTool().handleRightClick();
    }

    public void onKeyInput(int key, boolean pressed) {
        if (!this.active) {
            return;
        }
        if (!AllKeys.TOOL_MENU.doesModifierAndCodeMatch(key)) {
            return;
        }
        if (pressed && !this.selectionScreen.focused) {
            this.selectionScreen.focused = true;
        }
        if (!pressed && this.selectionScreen.focused) {
            this.selectionScreen.focused = false;
            this.selectionScreen.m_7379_();
        }
    }

    public boolean mouseScrolled(double delta) {
        if (!this.active) {
            return false;
        }
        if (this.selectionScreen.focused) {
            this.selectionScreen.cycle((int)Math.signum(delta));
            return true;
        }
        if (AllKeys.ctrlDown()) {
            return this.currentTool.getTool().handleMouseWheel(delta);
        }
        return false;
    }

    private ItemStack findBlueprintInHand(Player player) {
        ItemStack stack = player.m_21205_();
        if (!AllItems.SCHEMATIC.isIn(stack)) {
            return null;
        }
        if (!stack.m_41782_()) {
            return null;
        }
        this.activeSchematicItem = stack;
        this.activeHotbarSlot = player.m_150109_().f_35977_;
        return stack;
    }

    private boolean itemLost(Player player) {
        for (int i = 0; i < Inventory.m_36059_(); ++i) {
            if (player.m_150109_().m_8020_(i).m_150930_(this.activeSchematicItem.m_41720_()) || !ItemStack.m_41728_((ItemStack)player.m_150109_().m_8020_(i), (ItemStack)this.activeSchematicItem)) continue;
            return false;
        }
        return true;
    }

    public void markDirty() {
        this.syncCooldown = 10;
    }

    public void sync() {
        if (this.activeSchematicItem == null) {
            return;
        }
        AllPackets.getChannel().sendToServer((Object)new SchematicSyncPacket(this.activeHotbarSlot, this.transformation.toSettings(), this.transformation.getAnchor(), this.deployed));
    }

    public void equip(ToolType tool) {
        this.currentTool = tool;
        this.currentTool.getTool().init();
    }

    public void loadSettings(ItemStack blueprint) {
        CompoundTag tag = blueprint.m_41783_();
        BlockPos anchor = BlockPos.f_121853_;
        StructurePlaceSettings settings = SchematicItem.getSettings(blueprint);
        this.transformation = new SchematicTransformation();
        this.deployed = tag.m_128471_("Deployed");
        if (this.deployed) {
            anchor = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Anchor"));
        }
        Vec3i size = NBTHelper.readVec3i((ListTag)tag.m_128437_("Bounds", 3));
        this.bounds = new AABB(0.0, 0.0, 0.0, (double)size.m_123341_(), (double)size.m_123342_(), (double)size.m_123343_());
        this.outline = new AABBOutline(this.bounds);
        this.outline.getParams().colored(6850245).lineWidth(0.0625f);
        this.transformation.init(anchor, settings, this.bounds);
    }

    public void deploy() {
        if (!this.deployed) {
            List<ToolType> tools = ToolType.getTools(Minecraft.m_91087_().f_91074_.m_7500_());
            this.selectionScreen = new ToolSelectionScreen(tools, this::equip);
        }
        this.deployed = true;
        this.setupRenderer();
    }

    public String getCurrentSchematicName() {
        return this.displayedSchematic != null ? this.displayedSchematic : "-";
    }

    public void printInstantly() {
        AllPackets.getChannel().sendToServer((Object)new SchematicPlacePacket(this.activeSchematicItem.m_41777_()));
        CompoundTag nbt = this.activeSchematicItem.m_41783_();
        nbt.m_128379_("Deployed", false);
        this.activeSchematicItem.m_41751_(nbt);
        SchematicInstances.clearHash(this.activeSchematicItem);
        this.active = false;
        this.markDirty();
    }

    public boolean isActive() {
        return this.active;
    }

    public AABB getBounds() {
        return this.bounds;
    }

    public SchematicTransformation getTransformation() {
        return this.transformation;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public ItemStack getActiveSchematicItem() {
        return this.activeSchematicItem;
    }

    public AABBOutline getOutline() {
        return this.outline;
    }
}

