/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.backend.behaviours;

import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.behaviours.SliderStylePriceBehaviour;
import dev.ithundxr.createnumismatics.registry.packets.BlockEntityBehaviourConfigurationPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SliderStylePriceConfigurationPacket
extends BlockEntityBehaviourConfigurationPacket<SliderStylePriceBehaviour> {
    private int[] prices;

    public SliderStylePriceConfigurationPacket(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    protected BehaviourType<SliderStylePriceBehaviour> getType() {
        return SliderStylePriceBehaviour.TYPE;
    }

    public SliderStylePriceConfigurationPacket(SyncedBlockEntity be) {
        super(be.m_58899_());
        this.prices = new int[Coin.values().length];
        SliderStylePriceBehaviour priceBehaviour = (SliderStylePriceBehaviour)BlockEntityBehaviour.get((BlockEntity)be, this.getType());
        for (Coin coin : Coin.values()) {
            this.prices[coin.ordinal()] = priceBehaviour.getPrice(coin);
        }
    }

    @Override
    protected void writeSettings(FriendlyByteBuf buffer) {
        for (int price : this.prices) {
            buffer.m_130130_(price);
        }
    }

    @Override
    protected void readSettings(FriendlyByteBuf buf) {
        this.prices = new int[Coin.values().length];
        for (int i = 0; i < this.prices.length; ++i) {
            this.prices[i] = buf.m_130242_();
        }
    }

    @Override
    protected void applySettings(SliderStylePriceBehaviour priceBehaviour) {
        for (Coin coin : Coin.values()) {
            priceBehaviour.setPrice(coin, this.prices[coin.ordinal()]);
        }
    }
}

