/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry.packets;

import dev.ithundxr.createnumismatics.NumismaticsClient;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.multiloader.S2CPacket;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BankAccountLabelPacket
implements S2CPacket {
    @NotNull
    private final UUID id;
    @Nullable
    private final String label;

    public BankAccountLabelPacket(FriendlyByteBuf buf) {
        this.id = buf.m_130259_();
        this.label = buf.readBoolean() ? buf.m_130136_(256) : null;
    }

    public BankAccountLabelPacket(BankAccount account) {
        this.id = account.id;
        this.label = account.getLabel();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.id);
        buffer.writeBoolean(this.label != null);
        if (this.label != null) {
            buffer.m_130070_(this.label);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        if (this.label == null) {
            NumismaticsClient.bankAccountLabels.remove(this.id);
        } else {
            NumismaticsClient.bankAccountLabels.put(this.id, this.label);
        }
    }
}

