/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.DiscHandlerRegistry;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.VanillaDiscHandler;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WeightedElement;

public class EntityBackpackAdditionHandler {
    private static final int MAX_DIFFICULTY = 3;
    private static final float MAX_LOCAL_DIFFICULTY = 6.75f;
    private static final String SPAWNED_WITH_BACKPACK = "spawnedWithBackpack";
    private static final String SPAWNED_WITH_JUKEBOX_UPGRADE = "sophisticatedbackpacks:jukebox";
    private static final List<WeightedElement<Item>> HELMET_CHANCES = List.of(new WeightedElement(1, (Object)Items.f_42480_), new WeightedElement(3, (Object)Items.f_42472_), new WeightedElement(9, (Object)Items.f_42476_), new WeightedElement(27, (Object)Items.f_42468_), new WeightedElement(81, (Object)Items.f_42407_));
    private static final List<WeightedElement<Item>> LEGGINGS_CHANCES = List.of(new WeightedElement(1, (Object)Items.f_42482_), new WeightedElement(3, (Object)Items.f_42474_), new WeightedElement(9, (Object)Items.f_42478_), new WeightedElement(27, (Object)Items.f_42470_), new WeightedElement(81, (Object)Items.f_42462_));
    private static final List<WeightedElement<Item>> BOOTS_CHANCES = List.of(new WeightedElement(1, (Object)Items.f_42483_), new WeightedElement(3, (Object)Items.f_42475_), new WeightedElement(9, (Object)Items.f_42479_), new WeightedElement(27, (Object)Items.f_42471_), new WeightedElement(81, (Object)Items.f_42463_));
    private static final Map<Item, Float> dropChanceMultiplier = Map.of((Item)ModItems.BACKPACK.get(), Float.valueOf(1.0f), (Item)ModItems.COPPER_BACKPACK.get(), Float.valueOf(1.25f), (Item)ModItems.IRON_BACKPACK.get(), Float.valueOf(1.5f), (Item)ModItems.GOLD_BACKPACK.get(), Float.valueOf(3.0f), (Item)ModItems.DIAMOND_BACKPACK.get(), Float.valueOf(4.5f), (Item)ModItems.NETHERITE_BACKPACK.get(), Float.valueOf(6.0f));
    private static final List<WeightedElement<BackpackAddition>> BACKPACK_CHANCES = List.of(new WeightedElement(((Integer)Config.SERVER.entityBackpackAdditions.leatherWeight.get()).intValue(), (Object)new BackpackAddition((Item)ModItems.BACKPACK.get(), 0, HELMET_CHANCES.subList(3, 5), LEGGINGS_CHANCES.subList(3, 5), BOOTS_CHANCES.subList(3, 5))), new WeightedElement(((Integer)Config.SERVER.entityBackpackAdditions.copperWeight.get()).intValue(), (Object)new BackpackAddition((Item)ModItems.COPPER_BACKPACK.get(), 1, HELMET_CHANCES.subList(2, 4), LEGGINGS_CHANCES.subList(3, 5), BOOTS_CHANCES.subList(3, 5))), new WeightedElement(((Integer)Config.SERVER.entityBackpackAdditions.ironWeight.get()).intValue(), (Object)new BackpackAddition((Item)ModItems.IRON_BACKPACK.get(), 1, HELMET_CHANCES.subList(2, 4), LEGGINGS_CHANCES.subList(2, 4), BOOTS_CHANCES.subList(2, 4))), new WeightedElement(((Integer)Config.SERVER.entityBackpackAdditions.goldWeight.get()).intValue(), (Object)new BackpackAddition((Item)ModItems.GOLD_BACKPACK.get(), 2, HELMET_CHANCES.subList(1, 3), LEGGINGS_CHANCES.subList(1, 3), BOOTS_CHANCES.subList(1, 3))), new WeightedElement(((Integer)Config.SERVER.entityBackpackAdditions.diamondWeight.get()).intValue(), (Object)new BackpackAddition((Item)ModItems.DIAMOND_BACKPACK.get(), 3, HELMET_CHANCES.subList(0, 2), LEGGINGS_CHANCES.subList(0, 2), BOOTS_CHANCES.subList(0, 2))), new WeightedElement(((Integer)Config.SERVER.entityBackpackAdditions.netheriteWeight.get()).intValue(), (Object)new BackpackAddition((Item)ModItems.NETHERITE_BACKPACK.get(), 4, HELMET_CHANCES.subList(0, 1), LEGGINGS_CHANCES.subList(0, 1), BOOTS_CHANCES.subList(0, 1))));
    private static final Map<Integer, List<WeightedElement<BackpackAddition>>> DIFFICULTY_BACKPACK_CHANCES = Map.of(0, BACKPACK_CHANCES, 1, BACKPACK_CHANCES.subList((Integer)Config.SERVER.entityBackpackAdditions.minBackpackTierMidDifficulty.get(), 6), 2, BACKPACK_CHANCES.subList((Integer)Config.SERVER.entityBackpackAdditions.minBackpackTierHighDifficulty.get(), 6));
    private static final List<ApplicableEffect> APPLICABLE_EFFECTS;

    private EntityBackpackAdditionHandler() {
    }

    static void addBackpack(Monster monster, LevelAccessor level) {
        Raider raider;
        RandomSource rnd = level.m_213780_();
        if (!Config.SERVER.entityBackpackAdditions.canWearBackpack(monster.m_6095_()) || rnd.m_188503_((int)(1.0 / (Double)Config.SERVER.entityBackpackAdditions.chance.get())) != 0 || monster instanceof Raider && (raider = (Raider)monster).m_37885_() != null) {
            return;
        }
        int difficultyIndex = 0;
        if (((Boolean)Config.SERVER.entityBackpackAdditions.localDifficultyEffectsBackpackSpawns.get()).booleanValue()) {
            float localDifficulty = level.m_6436_(monster.m_20183_()).m_19056_();
            difficultyIndex = Ints.constrainToRange((int)((int)Math.floor((float)DIFFICULTY_BACKPACK_CHANCES.size() / 6.75f * localDifficulty - 0.1f)), (int)0, (int)(DIFFICULTY_BACKPACK_CHANCES.size() - 1));
        }
        RandHelper.getRandomWeightedElement((RandomSource)rnd, DIFFICULTY_BACKPACK_CHANCES.get(difficultyIndex)).ifPresent(backpackAddition -> {
            ItemStack backpack = new ItemStack((ItemLike)backpackAddition.getBackpackItem());
            int minDifficulty = backpackAddition.getMinDifficulty();
            EntityBackpackAdditionHandler.equipBackpack(monster, backpack, minDifficulty, Boolean.TRUE.equals(Config.SERVER.entityBackpackAdditions.playJukebox.get()) && rnd.m_188503_(4) == 0, level, rnd);
            EntityBackpackAdditionHandler.applyPotions(monster, Math.max(minDifficulty, rnd.m_188503_(4)), minDifficulty, rnd);
            EntityBackpackAdditionHandler.raiseHealth(monster, minDifficulty);
            if (Boolean.TRUE.equals(Config.SERVER.entityBackpackAdditions.equipWithArmor.get())) {
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getHelmetChances(), EquipmentSlot.HEAD, level);
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getLeggingsChances(), EquipmentSlot.LEGS, level);
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getBootsChances(), EquipmentSlot.FEET, level);
            }
            monster.m_20049_(SPAWNED_WITH_BACKPACK);
        });
    }

    private static void equipArmorPiece(Monster monster, RandomSource rnd, int minDifficulty, List<WeightedElement<Item>> armorChances, EquipmentSlot slot, LevelAccessor level) {
        RandHelper.getRandomWeightedElement((RandomSource)rnd, armorChances).ifPresent(armorPiece -> {
            if (armorPiece != Items.f_41852_) {
                ItemStack armorStack = new ItemStack((ItemLike)armorPiece);
                if (rnd.m_188503_(6 - minDifficulty) == 0) {
                    float additionalDifficulty = level.m_6436_(monster.m_20183_()).m_19057_();
                    int enchantmentLevel = (int)(5.0f + additionalDifficulty * 18.0f + (float)(minDifficulty * 6));
                    EnchantmentHelper.m_220292_((RandomSource)rnd, (ItemStack)armorStack, (int)enchantmentLevel, (boolean)true);
                }
                monster.m_8061_(slot, armorStack);
            }
        });
    }

    private static void equipBackpack(Monster monster, ItemStack backpack, int minDifficulty, boolean playMusicDisc, LevelAccessor level, RandomSource rnd) {
        EntityBackpackAdditionHandler.getSpawnEgg(monster.m_6095_()).ifPresent(egg -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(w -> {
            w.setColors(EntityBackpackAdditionHandler.getPrimaryColor(egg), EntityBackpackAdditionHandler.getSecondaryColor(egg));
            int partialRolls = rnd.m_216339_(minDifficulty, minDifficulty + 3);
            if (partialRolls != 0) {
                EntityBackpackAdditionHandler.setLoot(monster, w, level, (float)partialRolls / 3.0f);
            }
            if (playMusicDisc) {
                w.getInventoryHandler();
                if (w.getUpgradeHandler().getSlots() > 0) {
                    monster.m_20049_(SPAWNED_WITH_JUKEBOX_UPGRADE);
                    EntityBackpackAdditionHandler.addJukeboxUpgradeAndRandomDisc(level.m_213780_(), w, rnd);
                }
            }
        }));
        monster.m_8061_(EquipmentSlot.CHEST, backpack);
        monster.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    private static void addJukeboxUpgradeAndRandomDisc(RandomSource random, IStorageWrapper w, RandomSource rnd) {
        boolean advancedJukebox = (double)random.m_188501_() < 0.25;
        w.getUpgradeHandler().setStackInSlot(0, new ItemStack(advancedJukebox ? (ItemLike)ModItems.ADVANCED_JUKEBOX_UPGRADE.get() : (ItemLike)ModItems.JUKEBOX_UPGRADE.get()));
        Iterator it = w.getUpgradeHandler().getTypeWrappers(JukeboxUpgradeItem.TYPE).iterator();
        if (it.hasNext()) {
            if (DiscHandlerRegistry.getHandlers().isEmpty()) {
                SophisticatedBackpacks.LOGGER.warn("No music discs found to add to jukebox upgrade, either there are none registered or they are all blocked");
                return;
            }
            JukeboxUpgradeWrapper wrapper = (JukeboxUpgradeWrapper)it.next();
            int numberOfDiscs = advancedJukebox ? random.m_188503_(wrapper.getDiscInventory().getSlots() / 3) + 1 : 1;
            ArrayList discsUsed = new ArrayList();
            int i = 0;
            while (i < numberOfDiscs * 2) {
                int slot = i++;
                DiscHandlerRegistry.getRandomDisc((RandomSource)rnd).ifPresent(disc -> {
                    if (discsUsed.stream().anyMatch(s -> ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)disc))) {
                        return;
                    }
                    wrapper.getDiscInventory().insertItem(slot, disc, false);
                    discsUsed.add(disc);
                });
                if (discsUsed.size() >= numberOfDiscs) break;
            }
        }
    }

    private static void raiseHealth(Monster monster, int minDifficulty) {
        if (Boolean.FALSE.equals(Config.SERVER.entityBackpackAdditions.buffHealth.get())) {
            return;
        }
        AttributeInstance maxHealth = monster.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            double healthAddition = maxHealth.m_22115_() * (double)minDifficulty;
            if (healthAddition > 0.1) {
                maxHealth.m_22125_(new AttributeModifier("Backpack bearer health bonus", healthAddition, AttributeModifier.Operation.ADDITION));
            }
            monster.m_21153_(monster.m_21233_());
        }
    }

    private static Optional<SpawnEggItem> getSpawnEgg(EntityType<?> entityType) {
        Map eggs = (Map)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, null, (String)"f_43201_");
        return eggs == null ? Optional.empty() : Optional.ofNullable((SpawnEggItem)eggs.get(entityType));
    }

    private static int getPrimaryColor(SpawnEggItem egg) {
        Integer primaryColor = (Integer)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, (Object)egg, (String)"f_151200_");
        return primaryColor == null ? -1 : primaryColor;
    }

    private static int getSecondaryColor(SpawnEggItem egg) {
        Integer secondaryColor = (Integer)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, (Object)egg, (String)"f_151201_");
        return secondaryColor == null ? -1 : secondaryColor;
    }

    private static void setLoot(Monster monster, IBackpackWrapper backpackWrapper, LevelAccessor level, float lootFactor) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        if (Boolean.TRUE.equals(Config.SERVER.entityBackpackAdditions.addLoot.get())) {
            EntityBackpackAdditionHandler.addLoot(monster, backpackWrapper, lootFactor);
        }
    }

    private static void applyPotions(Monster monster, int difficulty, int minDifficulty, RandomSource rnd) {
        if (Boolean.TRUE.equals(Config.SERVER.entityBackpackAdditions.buffWithPotionEffects.get())) {
            RandHelper.getNRandomElements(APPLICABLE_EFFECTS, (int)(difficulty + 2)).forEach(applicableEffect -> {
                int amplifier = Math.min(Math.max(minDifficulty, rnd.m_188503_(difficulty + 1)), applicableEffect.getMaxAmplifier());
                monster.m_7292_(new MobEffectInstance(applicableEffect.getRandomEffect(rnd), 36000, amplifier));
            });
        }
    }

    private static void addLoot(Monster monster, IBackpackWrapper backpackWrapper, float lootFactor) {
        Config.SERVER.entityBackpackAdditions.getLootTableName(monster.m_6095_()).ifPresent(lootTableName -> backpackWrapper.setLoot((ResourceLocation)lootTableName, lootFactor));
    }

    static void handleBackpackDrop(LivingDropsEvent event) {
        if (event.getEntity().m_19880_().contains(SPAWNED_WITH_BACKPACK)) {
            ItemStack backpack;
            Config.Server.EntityBackpackAdditionsConfig additionsConfig = Config.SERVER.entityBackpackAdditions;
            LivingEntity mob = event.getEntity();
            if (EntityBackpackAdditionHandler.shouldDropBackpack(event, additionsConfig, mob, backpack = mob.m_6844_(EquipmentSlot.CHEST))) {
                ItemEntity backpackEntity = new ItemEntity(mob.m_9236_(), mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), backpack);
                event.getDrops().add(backpackEntity);
                mob.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
                event.getEntity().m_19880_().remove(SPAWNED_WITH_BACKPACK);
            } else {
                EntityBackpackAdditionHandler.removeContentsUuid(backpack);
            }
        }
    }

    private static boolean shouldDropBackpack(LivingDropsEvent event, Config.Server.EntityBackpackAdditionsConfig additionsConfig, LivingEntity mob, ItemStack backpack) {
        if (!(event.getSource().m_7639_() instanceof Player)) {
            return false;
        }
        if (!Boolean.TRUE.equals(additionsConfig.dropToFakePlayers.get()) && event.getSource().m_7639_() instanceof FakePlayer) {
            return false;
        }
        float lootingChanceMultiplier = dropChanceMultiplier.getOrDefault(backpack.m_41720_(), Float.valueOf(1.0f)).floatValue();
        return (double)mob.m_9236_().f_46441_.m_188501_() < ((Double)additionsConfig.backpackDropChance.get() + (double)event.getLootingLevel() * (Double)additionsConfig.lootingChanceIncreasePerLevel.get()) * (double)lootingChanceMultiplier;
    }

    public static void removeBeneficialEffects(Creeper creeper) {
        if (creeper.m_19880_().contains(SPAWNED_WITH_BACKPACK)) {
            creeper.m_21220_().removeIf(e -> e.m_19544_().m_19486_());
        }
    }

    public static void removeBackpackUuid(Monster entity, Level level) {
        if (level.m_5776_() || entity.m_146911_() != Entity.RemovalReason.KILLED && entity.m_146911_() != Entity.RemovalReason.DISCARDED || !entity.m_19880_().contains(SPAWNED_WITH_BACKPACK)) {
            return;
        }
        ItemStack stack = entity.m_6844_(EquipmentSlot.CHEST);
        EntityBackpackAdditionHandler.removeContentsUuid(stack);
    }

    private static void removeContentsUuid(ItemStack stack) {
        stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> backpackWrapper.getContentsUuid().ifPresent(uuid -> BackpackStorage.get().removeBackpackContents((UUID)uuid)));
    }

    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_19880_().contains(SPAWNED_WITH_JUKEBOX_UPGRADE)) {
            return;
        }
        entity.m_6844_(EquipmentSlot.CHEST).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> backpackWrapper.getUpgradeHandler().getTypeWrappers(JukeboxUpgradeItem.TYPE).forEach(wrapper -> {
            if (wrapper.isPlaying()) {
                wrapper.tick((Entity)entity, entity.m_9236_(), entity.m_20183_());
            } else {
                wrapper.play((Entity)entity);
            }
        }));
    }

    static {
        VanillaDiscHandler.setDiscBlockListGetter(Config.SERVER.entityBackpackAdditions.discBlockList);
        APPLICABLE_EFFECTS = List.of(new ApplicableEffect(List.of(MobEffects.f_19606_, MobEffects.f_19605_), 1), new ApplicableEffect(MobEffects.f_19607_), new ApplicableEffect(MobEffects.f_19617_), new ApplicableEffect(MobEffects.f_19616_), new ApplicableEffect(MobEffects.f_19596_), new ApplicableEffect(MobEffects.f_19600_));
    }

    private static class ApplicableEffect {
        private final List<MobEffect> effects;
        private final int maxAmplifier;

        private ApplicableEffect(MobEffect effect) {
            this(List.of(effect), Integer.MAX_VALUE);
        }

        private ApplicableEffect(List<MobEffect> effects, int maxAmplifier) {
            this.effects = effects;
            this.maxAmplifier = maxAmplifier;
        }

        public MobEffect getRandomEffect(RandomSource random) {
            return this.effects.get(random.m_188503_(this.effects.size()));
        }

        public int getMaxAmplifier() {
            return this.maxAmplifier;
        }
    }

    private record BackpackAddition(Item backpackItem, int minDifficulty, List<WeightedElement<Item>> helmetChances, List<WeightedElement<Item>> leggingsChances, List<WeightedElement<Item>> bootsChances) {
        public List<WeightedElement<Item>> getHelmetChances() {
            return this.helmetChances;
        }

        public List<WeightedElement<Item>> getLeggingsChances() {
            return this.leggingsChances;
        }

        public List<WeightedElement<Item>> getBootsChances() {
            return this.bootsChances;
        }

        public Item getBackpackItem() {
            return this.backpackItem;
        }

        public int getMinDifficulty() {
            return this.minDifficulty;
        }
    }
}

