/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block;

import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.IBlockGetter;
import de.mrjulsen.crn.block.properties.EBlockAlignment;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.Tripple;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AdvancedDisplayBoardBlock
extends AbstractAdvancedSidedDisplayBlock {
    public static final EnumProperty<EBlockAlignment> Z_ALIGN = EnumProperty.m_61587_((String)"z_alignment", EBlockAlignment.class);
    private static final Map<ShapeKey, VoxelShape> SHAPES = Map.ofEntries(Map.entry(new ShapeKey(Direction.SOUTH, EBlockAlignment.NEGATIVE), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.NORTH, EBlockAlignment.NEGATIVE), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)), Map.entry(new ShapeKey(Direction.EAST, EBlockAlignment.NEGATIVE), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.WEST, EBlockAlignment.NEGATIVE), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.SOUTH, EBlockAlignment.CENTER), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), Map.entry(new ShapeKey(Direction.NORTH, EBlockAlignment.CENTER), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), Map.entry(new ShapeKey(Direction.EAST, EBlockAlignment.CENTER), Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.WEST, EBlockAlignment.CENTER), Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.SOUTH, EBlockAlignment.POSITIVE), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)), Map.entry(new ShapeKey(Direction.NORTH, EBlockAlignment.POSITIVE), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.EAST, EBlockAlignment.POSITIVE), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.WEST, EBlockAlignment.POSITIVE), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)));
    private static final Map<Direction, VoxelShape> SUPPORT_SHAPES = Map.ofEntries(Map.entry(Direction.SOUTH, Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0))), Map.entry(Direction.NORTH, Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0))), Map.entry(Direction.EAST, Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0))), Map.entry(Direction.WEST, Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0))));

    public AdvancedDisplayBoardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(Z_ALIGN, (Comparable)((Object)EBlockAlignment.CENTER)));
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_61143_(Z_ALIGN) == EBlockAlignment.CENTER ? SUPPORT_SHAPES.get(state.m_61143_((Property)FACING)) : SHAPES.get(new ShapeKey((Direction)state.m_61143_((Property)FACING), (EBlockAlignment)((Object)state.m_61143_(Z_ALIGN))));
    }

    @Override
    public Collection<Property<?>> getExcludedProperties() {
        return List.of(Z_ALIGN);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES.get(new ShapeKey((Direction)pState.m_61143_((Property)FACING), (EBlockAlignment)((Object)pState.m_61143_(Z_ALIGN))));
    }

    @Override
    public BlockState getDefaultPlacementState(BlockPlaceContext context, BlockState state, BlockState other) {
        BlockState stateForPlacement = super.getDefaultPlacementState(context, state, other);
        Direction direction = context.m_43719_();
        Direction looking = context.m_8125_();
        Direction.Axis axis = looking.m_122434_();
        Direction.AxisDirection axisDirection = looking.m_122421_();
        double xzPos = 0.5;
        if (axis == Direction.Axis.X) {
            xzPos = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_();
        } else if (axis == Direction.Axis.Z) {
            xzPos = context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_();
        }
        EBlockAlignment zAlign = EBlockAlignment.CENTER;
        if (direction == context.m_43723_().m_6350_().m_122424_() || (axisDirection == Direction.AxisDirection.POSITIVE ? xzPos > 0.66666666 : xzPos < 0.33333333)) {
            zAlign = EBlockAlignment.POSITIVE;
        } else if (direction == context.m_43723_().m_6350_() || (axisDirection == Direction.AxisDirection.POSITIVE ? xzPos < 0.33333333 : xzPos > 0.66666666)) {
            zAlign = EBlockAlignment.NEGATIVE;
        }
        return (BlockState)stateForPlacement.m_61124_(Z_ALIGN, (Comparable)((Object)zAlign));
    }

    @Override
    public BlockState appendOnPlace(BlockPlaceContext context, BlockState state, BlockState other) {
        return (BlockState)super.appendOnPlace(context, state, other).m_61124_(Z_ALIGN, (Comparable)((Object)((EBlockAlignment)((Object)other.m_61143_(Z_ALIGN)))));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{Z_ALIGN}));
    }

    @Override
    public boolean canConnectWithBlock(IBlockGetter level, BlockState selfState, BlockState otherState) {
        return super.canConnectWithBlock(level, selfState, otherState) && selfState.m_61143_(Z_ALIGN) == otherState.m_61143_(Z_ALIGN);
    }

    @Override
    protected boolean canConnect(LevelAccessor level, BlockPos pos, BlockState state, BlockState other) {
        return super.canConnect(level, pos, state, other) && state.m_61143_(Z_ALIGN) == other.m_61143_(Z_ALIGN);
    }

    @Override
    public Pair<Float, Float> getRenderAspectRatio(Level level, BlockState blockState, BlockPos pos) {
        return Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    }

    @Override
    public Pair<Float, Float> getRenderOffset(Level level, BlockState blockState, BlockPos pos) {
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    }

    @Override
    public Pair<Float, Float> getRenderZOffset(Level level, BlockState blockState, BlockPos pos) {
        float z1;
        return Pair.of((Object)Float.valueOf(z1), (Object)Float.valueOf(switch ((EBlockAlignment)((Object)blockState.m_61143_(Z_ALIGN))) {
            case EBlockAlignment.NEGATIVE -> {
                z1 = 16.05f;
                yield 8.05f;
            }
            case EBlockAlignment.POSITIVE -> {
                z1 = 8.05f;
                yield 16.05f;
            }
            default -> {
                z1 = 13.05f;
                yield 13.05f;
            }
        }));
    }

    @Override
    public Tripple<Float, Float, Float> getRenderRotation(Level level, BlockState blockState, BlockPos pos) {
        return Tripple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    }

    @Override
    public boolean isSingleLined() {
        return false;
    }

    private static final class ShapeKey {
        private final Direction facing;
        private final EBlockAlignment zAlign;

        public ShapeKey(Direction facing, EBlockAlignment zAlign) {
            this.facing = facing;
            this.zAlign = zAlign;
        }

        public boolean equals(Object o) {
            if (o instanceof ShapeKey) {
                ShapeKey other = (ShapeKey)o;
                return this.facing == other.facing && this.zAlign == other.zAlign;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.facing, this.zAlign});
        }
    }
}

