/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import de.mrjulsen.crn.CRNPlatformSpecific;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.MutablePair;

public interface IBlockGetter {
    public BlockState getBlockState(BlockPos var1);

    public BlockEntity getBlockEntity(BlockPos var1);

    public boolean isClientSide();

    public void updateBlockEntity(SmartBlockEntity var1, BlockPos var2);

    public void updateBlockState(BlockState var1, BlockPos var2);

    public static class WorldBlockGetter
    implements IBlockGetter {
        private final BlockGetter level;
        private final boolean isClientSide;

        public WorldBlockGetter(BlockAndTintGetter level) {
            this.level = level;
            this.isClientSide = true;
        }

        public WorldBlockGetter(Level level) {
            this.level = level;
            this.isClientSide = level.f_46443_;
        }

        @Override
        public BlockState getBlockState(BlockPos pos) {
            return this.level.m_8055_(pos);
        }

        @Override
        public BlockEntity getBlockEntity(BlockPos pos) {
            return this.level.m_7702_(pos);
        }

        @Override
        public void updateBlockEntity(SmartBlockEntity be, BlockPos pos) {
        }

        @Override
        public void updateBlockState(BlockState state, BlockPos pos) {
        }

        @Override
        public boolean isClientSide() {
            return this.isClientSide;
        }
    }

    public static class ContraptionBlockGetter
    implements IBlockGetter {
        private final AbstractContraptionEntity contraptionEntity;

        public ContraptionBlockGetter(AbstractContraptionEntity contraptionEntity) {
            this.contraptionEntity = contraptionEntity;
        }

        @Override
        public BlockState getBlockState(BlockPos pos) {
            Contraption contraption = this.contraptionEntity.getContraption();
            return contraption.getBlocks().containsKey(pos) ? ((StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos)).f_74676_() : null;
        }

        @Override
        public BlockEntity getBlockEntity(BlockPos pos) {
            Contraption contraption = this.contraptionEntity.getContraption();
            return CRNPlatformSpecific.getClientContraptionBlockEntity(contraption, pos);
        }

        @Override
        public boolean isClientSide() {
            Contraption contraption = this.contraptionEntity.getContraption();
            return contraption.getContraptionWorld().m_5776_();
        }

        @Override
        public void updateBlockEntity(SmartBlockEntity be, BlockPos pos) {
            Contraption contraption = this.contraptionEntity.getContraption();
            MutablePair actor = contraption.getActorAt(pos);
            if (actor == null || actor.getRight() == null) {
                return;
            }
            MovementContext ctx = (MovementContext)actor.getRight();
            be.m_183515_(ctx.blockEntityData);
        }

        @Override
        public void updateBlockState(BlockState state, BlockPos pos) {
            Contraption contraption = this.contraptionEntity.getContraption();
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
            contraption.getBlocks().put(pos, new StructureTemplate.StructureBlockInfo(pos, state, info.f_74677_()));
        }
    }
}

