/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties.components;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.block.display.properties.DepartureBoardDisplayTableSettings;
import de.mrjulsen.crn.block.display.properties.PlatformDisplayFocusSettings;
import de.mrjulsen.crn.block.display.properties.StaticTextDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.ICarriageIndexSetting;
import de.mrjulsen.crn.block.display.properties.components.IColorSetting;
import de.mrjulsen.crn.block.display.properties.components.IPlatformWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowArrivalSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowDoNotBoardText;
import de.mrjulsen.crn.block.display.properties.components.IShowExitDirectionSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowLineColorSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowNextConnections;
import de.mrjulsen.crn.block.display.properties.components.IShowTimeAndDateSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowTrainStatsSetting;
import de.mrjulsen.crn.block.display.properties.components.IStaticTextSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextBackgroundColorSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextPosSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextScaleSetting;
import de.mrjulsen.crn.block.display.properties.components.ITextWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainNameWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainTextSetting;
import de.mrjulsen.crn.block.display.properties.components.SpecialUnitNumberFormat;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.ColorSlotWidget;
import de.mrjulsen.crn.client.gui.widgets.DBNavigatorWidget;
import de.mrjulsen.crn.client.gui.widgets.IconSlotWidget;
import de.mrjulsen.crn.client.gui.widgets.create.CreateButton;
import de.mrjulsen.crn.client.gui.widgets.create.CreateItemPicker;
import de.mrjulsen.crn.client.gui.widgets.create.CreateScrollNumberInput;
import de.mrjulsen.crn.client.gui.widgets.create.CreateTextBox;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLCheckBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLNumberPicker;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLRichTextLabel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLToggleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.FlowLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.Holder;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;

public class GuiBuilderWrapper {
    static void buildColorGui(IColorSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("color");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.COLOR_PALETTE.getAsSprite(16, 16));
        ColorSlotWidget fontColor = new ColorSlotWidget(0, 0, setting.getFontColor(), ModUtils.getDyeColors(), false, false, b -> setting.setFontColor((DLColor)b));
        fontColor.tooltip.set((Object)new DLTooltip(List.of(IColorSetting.textFontColor, IColorSetting.textClickToEdit), 200));
        line.addComponent((DLGuiComponent)fontColor);
        ColorSlotWidget backColor = new ColorSlotWidget(0, 0, setting.getBackColor(), ModUtils.getDyeColors(), false, true, b -> setting.setBackColor((DLColor)b));
        backColor.tooltip.set((Object)new DLTooltip(List.of(IColorSetting.textBackColor, IColorSetting.textClickToEdit), 200));
        line.addComponent((DLGuiComponent)backColor);
    }

    static void buildCarriageIndexGui(ICarriageIndexSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("carriage_index");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.CARRIAGE_NUMBER.getAsSprite(16, 16));
        CreateScrollNumberInput indexBox = new CreateScrollNumberInput(0, 0, 22);
        indexBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.carriage_index"));
        indexBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.carriage_index.description"));
        indexBox.min.set((Number)0.0);
        indexBox.max.set((Number)99.0);
        indexBox.shiftStep.set((Number)5.0);
        indexBox.value.set((Number)setting.getCarriageIndex());
        indexBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setCarriageIndex((byte)e.value());
            return false;
        });
        line.addComponent((DLGuiComponent)indexBox);
        DLCheckBox overwriteIndexBox = new DLCheckBox(0, 0, 0, 18);
        overwriteIndexBox.text.set((Object)ICarriageIndexSetting.textOverwriteCarriageIndex);
        overwriteIndexBox.checked.set((Object)setting.shouldOverwriteCarriageIndex());
        overwriteIndexBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        overwriteIndexBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
            setting.setOverwriteCarriageIndex(e.checked());
            return false;
        });
        overwriteIndexBox.tooltip.set((Object)new DLTooltip(List.of(ICarriageIndexSetting.textOverwriteCarriageIndexDescription), 200));
        line.addComponent((DLGuiComponent)overwriteIndexBox);
    }

    static void buildBasicTextWidthGui(GuiBuilderContext context) {
        DLPanel line = context.container().addLine("text_width");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.WIDTH.getAsSprite(16, 16));
    }

    static void buildPlatformWidthGui(IPlatformWidthSetting setting, GuiBuilderContext context, boolean allowAuto) {
        DLPanel line = context.container().addLine("text_width");
        CreateScrollNumberInput platformWidthBox = new CreateScrollNumberInput(0, 0, 32);
        platformWidthBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.platform_width"));
        platformWidthBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.platform_width.description"));
        platformWidthBox.min.set((Number)(allowAuto ? -1.0 : 0.0));
        platformWidthBox.max.set((Number)64.0);
        platformWidthBox.shiftStep.set((Number)4.0);
        platformWidthBox.format.set((Object)new SpecialUnitNumberFormat(0, "px", allowAuto, false, (Double)platformWidthBox.min.get(), (Double)platformWidthBox.max.get()));
        platformWidthBox.value.set((Number)setting.getPlatformWidth());
        platformWidthBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setPlatformWidth((byte)e.value());
            return false;
        });
        line.addComponent((DLGuiComponent)platformWidthBox);
    }

    static void buildShowArrivalGui(IShowArrivalSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("show_arrival");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.TARGET.getAsSprite(16, 16));
        DLCheckBox showArrivalsBox = new DLCheckBox(0, 0, 0, 18);
        showArrivalsBox.text.set((Object)IShowArrivalSetting.textShowArrival);
        showArrivalsBox.checked.set((Object)setting.showArrival());
        showArrivalsBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        showArrivalsBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
            setting.setShowArrival(e.checked());
            return false;
        });
        showArrivalsBox.tooltip.set((Object)new DLTooltip(List.of(IShowArrivalSetting.textShowArrivalDescription), 200));
        line.addComponent((DLGuiComponent)showArrivalsBox);
    }

    static void buildShowDoNotBoardTextGui(IShowDoNotBoardText setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("show_do_not_board_text");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.WALK.getAsSprite(16, 16));
        DLCheckBox showDoNotBoardBox = new DLCheckBox(0, 0, 0, 18);
        showDoNotBoardBox.text.set((Object)IShowDoNotBoardText.textShowDoNotBoardText);
        showDoNotBoardBox.checked.set((Object)setting.showDoNotBoardText());
        showDoNotBoardBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        showDoNotBoardBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
            setting.setShowDoNotBoardText(e.checked());
            return false;
        });
        showDoNotBoardBox.tooltip.set((Object)new DLTooltip(List.of(IShowDoNotBoardText.textShowDoNotBoardTextDescription), 200));
        line.addComponent((DLGuiComponent)showDoNotBoardBox);
    }

    static void buildShowExitGui(IShowExitDirectionSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("show_exit");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.EXIT.getAsSprite(16, 16));
        DLCheckBox showLineColorBox = new DLCheckBox(0, 0, 0, 18);
        showLineColorBox.text.set((Object)IShowExitDirectionSetting.textShowExit);
        showLineColorBox.checked.set((Object)setting.showExit());
        showLineColorBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        showLineColorBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
            setting.setShowExit(e.checked());
            return false;
        });
        line.addComponent((DLGuiComponent)showLineColorBox);
    }

    static void buildShowLineColorGui(IShowLineColorSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("show_line_color");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.COLOR_PALETTE.getAsSprite(16, 16));
        DLCheckBox showDoNotBoardBox = new DLCheckBox(0, 0, 0, 18);
        showDoNotBoardBox.text.set((Object)IShowLineColorSetting.textShowLineColor);
        showDoNotBoardBox.checked.set((Object)setting.showLineColor());
        showDoNotBoardBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        showDoNotBoardBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
            setting.setShowLineColor(e.checked());
            return false;
        });
        showDoNotBoardBox.tooltip.set((Object)new DLTooltip(List.of(IShowLineColorSetting.textShowLineColorDescription), 200));
        line.addComponent((DLGuiComponent)showDoNotBoardBox);
    }

    static void buildShowConnectionGui(IShowNextConnections setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("show_connections");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.CONNECTIONS.getAsSprite(16, 16));
        DLCheckBox showConnectionsBox = new DLCheckBox(0, 0, 0, 18);
        showConnectionsBox.text.set((Object)IShowNextConnections.textShowConnections);
        showConnectionsBox.checked.set((Object)setting.showConnections());
        showConnectionsBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        showConnectionsBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
            setting.setShowConnection(e.checked());
            return false;
        });
        line.addComponent((DLGuiComponent)showConnectionsBox);
    }

    static void buildShowTimeAndDateGui(IShowTimeAndDateSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("show_time");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.TIME.getAsSprite(16, 16));
        DLCheckBox showBuildTimeAndDateBox = new DLCheckBox(0, 0, 0, 18);
        showBuildTimeAndDateBox.text.set((Object)IShowTimeAndDateSetting.textShowStats);
        showBuildTimeAndDateBox.checked.set((Object)setting.showTimeAndDate());
        showBuildTimeAndDateBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        showBuildTimeAndDateBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
            setting.setShowTimeAndDate(e.checked());
            return false;
        });
        line.addComponent((DLGuiComponent)showBuildTimeAndDateBox);
    }

    static void buildShowStatsGui(IShowTrainStatsSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("show_stats");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.TRAIN_INFO.getAsSprite(16, 16));
        DLCheckBox showBuildTimeAndDateBox = new DLCheckBox(0, 0, 0, 18);
        showBuildTimeAndDateBox.text.set((Object)IShowTrainStatsSetting.textShowStats);
        showBuildTimeAndDateBox.checked.set((Object)setting.showStats());
        showBuildTimeAndDateBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        showBuildTimeAndDateBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
            setting.setShowStats(e.checked());
            return false;
        });
        line.addComponent((DLGuiComponent)showBuildTimeAndDateBox);
    }

    static void buildTimeDisplayGui(ITimeDisplaySetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("time");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.TIME.getAsSprite(16, 16));
        CreateItemPicker timeDisplayBox = new CreateItemPicker(0, 0, 40);
        timeDisplayBox.renderArrow.set((Object)true);
        timeDisplayBox.title.set((Object)TextUtils.translate((String)"enum.createrailwaysnavigator.time_display"));
        timeDisplayBox.hint.set((Object)TextUtils.translate((String)"enum.createrailwaysnavigator.time_display.description"));
        timeDisplayBox.formatter.set(item -> item == null ? TextUtils.empty() : item.getValueTranslation());
        timeDisplayBox.items.addAll((Object[])ETimeDisplay.values());
        timeDisplayBox.selectedItem.set(Optional.ofNullable(setting.getTimeDisplay()));
        timeDisplayBox.addEventListener(DLCycleButton.SelectedItemChanged.class, (s, e) -> {
            ((Optional)timeDisplayBox.selectedItem.get()).ifPresent(item -> setting.setTimeDisplay((ETimeDisplay)((Object)((Object)item))));
            return false;
        });
        line.addComponent(timeDisplayBox);
    }

    static void buildTrainNameGui(ITrainNameWidthSetting setting, GuiBuilderContext context, boolean allowAuto, boolean allowMax) {
        DLPanel line = context.container().addLine("text_width");
        CreateScrollNumberInput trainNameWidthBox = new CreateScrollNumberInput(0, 0, 32);
        trainNameWidthBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.train_name_width"));
        trainNameWidthBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.train_name_width.description"));
        trainNameWidthBox.min.set((Number)(0 - (allowAuto ? 1 : 0)));
        trainNameWidthBox.max.set((Number)(99 + (allowMax ? 1 : 0)));
        trainNameWidthBox.shiftStep.set((Number)5.0);
        trainNameWidthBox.format.set((Object)new SpecialUnitNumberFormat(0, "px", allowAuto, allowMax, (Double)trainNameWidthBox.min.get(), (Double)trainNameWidthBox.max.get()));
        trainNameWidthBox.value.set((Number)setting.getTrainNameWidth());
        trainNameWidthBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setTrainNameWidth((byte)e.value());
            return false;
        });
        line.addComponent((DLGuiComponent)trainNameWidthBox);
    }

    static void buildTrainTextGui(ITrainTextSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("train_text");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.TEXT.getAsSprite(16, 16));
        CreateItemPicker timeDisplayBox = new CreateItemPicker(0, 0, 0);
        timeDisplayBox.renderArrow.set((Object)true);
        timeDisplayBox.title.set((Object)TextUtils.translate((String)"enum.createrailwaysnavigator.train_text_components"));
        timeDisplayBox.hint.set((Object)TextUtils.translate((String)"enum.createrailwaysnavigator.train_text_components.description"));
        timeDisplayBox.formatter.set(item -> item == null ? TextUtils.empty() : item.getValueTranslation());
        timeDisplayBox.items.addAll((Object[])ITrainTextSetting.ETrainTextComponents.values());
        timeDisplayBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        timeDisplayBox.selectedItem.set(Optional.ofNullable(setting.getTrainTextComponents()));
        timeDisplayBox.addEventListener(DLCycleButton.SelectedItemChanged.class, (s, e) -> {
            ((Optional)timeDisplayBox.selectedItem.get()).ifPresent(item -> setting.setTrainTextComponents((ITrainTextSetting.ETrainTextComponents)((Object)((Object)item))));
            return false;
        });
        line.addComponent(timeDisplayBox);
    }

    public static void buildPlatformDisplayFocusGui(PlatformDisplayFocusSettings setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("text_width");
        CreateScrollNumberInput trainNameWidthBox = new CreateScrollNumberInput(0, 0, 32);
        trainNameWidthBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.train_name_width"));
        trainNameWidthBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.train_name_width.description"));
        trainNameWidthBox.min.set((Number)-1.0);
        trainNameWidthBox.max.set((Number)99.0);
        trainNameWidthBox.shiftStep.set((Number)5.0);
        trainNameWidthBox.format.set((Object)new SpecialUnitNumberFormat(0, "px", true, false, (Double)trainNameWidthBox.min.get(), (Double)trainNameWidthBox.max.get()));
        trainNameWidthBox.value.set((Number)setting.getTrainNameWidth());
        trainNameWidthBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setTrainNameWidth((byte)e.value());
            return false;
        });
        line.addComponent((DLGuiComponent)trainNameWidthBox);
        CreateScrollNumberInput platformWidthBox = new CreateScrollNumberInput(0, 0, 32);
        platformWidthBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.platform_width_table"));
        platformWidthBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.platform_width.description"));
        platformWidthBox.min.set((Number)-1.0);
        platformWidthBox.max.set((Number)64.0);
        platformWidthBox.shiftStep.set((Number)4.0);
        platformWidthBox.format.set((Object)new SpecialUnitNumberFormat(0, "px", true, false, (Double)platformWidthBox.min.get(), (Double)platformWidthBox.max.get()));
        platformWidthBox.value.set((Number)setting.getPlatformWidth());
        platformWidthBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setPlatformWidth((byte)e.value());
            return false;
        });
        line.addComponent((DLGuiComponent)platformWidthBox);
        CreateScrollNumberInput trainNameWidthNextBox = new CreateScrollNumberInput(0, 0, 32);
        trainNameWidthNextBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.train_name_width_next"));
        trainNameWidthNextBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.train_name_width.description"));
        trainNameWidthNextBox.min.set((Number)-1.0);
        trainNameWidthNextBox.max.set((Number)99.0);
        trainNameWidthNextBox.shiftStep.set((Number)5.0);
        trainNameWidthNextBox.format.set((Object)new SpecialUnitNumberFormat(0, "px", true, false, (Double)trainNameWidthNextBox.min.get(), (Double)trainNameWidthNextBox.max.get()));
        trainNameWidthNextBox.value.set((Number)setting.getTrainNameWidthNextStop());
        trainNameWidthNextBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setTrainNameWidthNextStop((byte)e.value());
            return false;
        });
        line.addComponent((DLGuiComponent)trainNameWidthNextBox);
        CreateScrollNumberInput platformWidthNextBox = new CreateScrollNumberInput(0, 0, 32);
        platformWidthNextBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.platform_width_next"));
        platformWidthNextBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.platform_width.description"));
        platformWidthNextBox.min.set((Number)-1.0);
        platformWidthNextBox.max.set((Number)64.0);
        platformWidthNextBox.shiftStep.set((Number)4.0);
        platformWidthNextBox.format.set((Object)new SpecialUnitNumberFormat(0, "px", true, false, (Double)platformWidthNextBox.min.get(), (Double)platformWidthNextBox.max.get()));
        platformWidthNextBox.value.set((Number)setting.getPlatformWidthNextStop());
        platformWidthNextBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setPlatformWidthNextStop((byte)e.value());
            return false;
        });
        line.addComponent((DLGuiComponent)platformWidthNextBox);
    }

    public static void buildDepartureBoardTableGui(DepartureBoardDisplayTableSettings setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("text_width");
        Holder.MutableHolder stopovers = new Holder.MutableHolder(null);
        Holder.MutableHolder info = new Holder.MutableHolder(null);
        CreateScrollNumberInput stopoversWidthBox = new CreateScrollNumberInput(0, 0, 32);
        stopovers.set((Object)stopoversWidthBox);
        stopoversWidthBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.stopovers_width"));
        stopoversWidthBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.stopovers_width.description"));
        stopoversWidthBox.min.set((Number)0.0);
        stopoversWidthBox.max.set((Number)100.0);
        stopoversWidthBox.shiftStep.set((Number)5.0);
        stopoversWidthBox.format.set((Object)new SpecialUnitNumberFormat(0, "%", false, false, (Double)stopoversWidthBox.min.get(), (Double)stopoversWidthBox.max.get()));
        stopoversWidthBox.value.set((Number)((double)setting.getStopoversWidthPercentage() * 100.0));
        stopoversWidthBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setStopoversWidthPercentageInt((byte)e.value());
            DLUtils.doIfNotNull((Object)((Object)((CreateScrollNumberInput)((Object)((Object)info.get())))), x -> {
                x.min.set((Number)0.0);
                x.max.set((Number)MathUtils.clamp((double)(100.0 - e.value()), (double)0.0, (double)100.0));
            });
            return false;
        });
        line.addComponent((DLGuiComponent)stopoversWidthBox);
        if (stopovers.get() != null && info.get() != null) {
            ((CreateScrollNumberInput)((Object)stopovers.get())).min.set((Number)0.0);
            ((CreateScrollNumberInput)((Object)stopovers.get())).max.set((Number)MathUtils.clamp((double)(101.0 - (Double)((CreateScrollNumberInput)((Object)info.get())).value.get()), (double)0.0, (double)101.0));
            ((CreateScrollNumberInput)((Object)info.get())).min.set((Number)0.0);
            ((CreateScrollNumberInput)((Object)info.get())).max.set((Number)MathUtils.clamp((double)(101.0 - (Double)((CreateScrollNumberInput)((Object)stopovers.get())).value.get()), (double)0.0, (double)101.0));
        }
        CreateScrollNumberInput infoWidthBox = new CreateScrollNumberInput(0, 0, 32);
        info.set((Object)infoWidthBox);
        infoWidthBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.info_width"));
        infoWidthBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.info_width.description"));
        infoWidthBox.min.set((Number)0.0);
        infoWidthBox.max.set((Number)100.0);
        infoWidthBox.shiftStep.set((Number)5.0);
        infoWidthBox.format.set((Object)new SpecialUnitNumberFormat(0, "%", false, false, (Double)infoWidthBox.min.get(), (Double)infoWidthBox.max.get()));
        infoWidthBox.value.set((Number)((double)setting.getInfoWidthPercentage() * 100.0));
        infoWidthBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setInfoWidthPercentageInt((byte)e.value());
            DLUtils.doIfNotNull((Object)((Object)((CreateScrollNumberInput)((Object)((Object)stopovers.get())))), x -> {
                x.min.set((Number)0.0);
                x.max.set((Number)MathUtils.clamp((double)(100.0 - e.value()), (double)0.0, (double)100.0));
            });
            return false;
        });
        line.addComponent((DLGuiComponent)infoWidthBox);
        if (stopovers.get() != null && info.get() != null) {
            ((CreateScrollNumberInput)((Object)stopovers.get())).min.set((Number)0.0);
            ((CreateScrollNumberInput)((Object)stopovers.get())).max.set((Number)MathUtils.clamp((double)(100.0 - (Double)((CreateScrollNumberInput)((Object)info.get())).value.get()), (double)0.0, (double)100.0));
            ((CreateScrollNumberInput)((Object)info.get())).min.set((Number)0.0);
            ((CreateScrollNumberInput)((Object)info.get())).max.set((Number)MathUtils.clamp((double)(100.0 - (Double)((CreateScrollNumberInput)((Object)stopovers.get())).value.get()), (double)0.0, (double)100.0));
        }
    }

    public static void buildStaticTextBaseGui(StaticTextDisplaySettings setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("color");
        DBNavigatorWidget dbwidget = new DBNavigatorWidget(0, 0, 18, setting.getSelectedComponentIndex(), 50, () -> {
            if (setting.getSelectedComponentIndex() >= setting.getComponentsCount() - 1) {
                setting.verifyComponents();
                setting.createNewComponent();
            }
            setting.setSelectedComponentIndex(setting.getSelectedComponentIndex() + 1);
            context.container().clearLines();
            setting.buildGui(context);
        }, () -> {
            setting.setSelectedComponentIndex(setting.getSelectedComponentIndex() - 1);
            setting.verifyComponents();
            context.container().clearLines();
            setting.buildGui(context);
        });
        dbwidget.layoutContraint.set((Object)FlowLayout.FlowConstraint.END);
        line.addComponent((DLGuiComponent)dbwidget);
    }

    static void buildStaticTextGui(IStaticTextSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("static_text");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.TEXT.getAsSprite(16, 16));
        icon.tooltip.set((Object)new DLTooltip(List.of(TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.static_text"), TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.static_text.description").m_130940_(ChatFormatting.GRAY)), 200));
        CreateTextBox textBox = new CreateTextBox(0, 0, 0);
        textBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        textBox.maxCharacters.set((Number)Short.MAX_VALUE);
        ((RichTextComponent)textBox.text.get()).set(setting.getStaticText());
        textBox.addEventListener(DLRichTextLabel.TextChangedEvent.class, (s, e) -> {
            setting.setStaticText(e.text().getPlainText());
            return false;
        });
        line.addComponent((DLGuiComponent)textBox);
    }

    static void buildTextScaleGui(ITextScaleSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("text_scale");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.SCALE.getAsSprite(16, 16));
        Holder.MutableHolder scaleInput = new Holder.MutableHolder(null);
        Holder.MutableHolder minScaleInput = new Holder.MutableHolder(null);
        CreateScrollNumberInput textMinScaleXBox = new CreateScrollNumberInput(0, 0, 32);
        minScaleInput.set((Object)textMinScaleXBox);
        textMinScaleXBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_min_x_scale"));
        textMinScaleXBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_min_x_scale.description"));
        textMinScaleXBox.min.set((Number)10.0);
        textMinScaleXBox.max.set((Number)100.0);
        textMinScaleXBox.shiftStep.set((Number)5.0);
        textMinScaleXBox.format.set((Object)new SpecialUnitNumberFormat(0, "%", false, false, (Double)textMinScaleXBox.min.get(), (Double)textMinScaleXBox.max.get()));
        textMinScaleXBox.value.set((Number)((double)setting.getMinXScale() * 100.0));
        textMinScaleXBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setMinXScale((float)e.value() / 100.0f);
            DLUtils.doIfNotNull((Object)((Object)((CreateScrollNumberInput)((Object)((Object)scaleInput.get())))), x -> {
                x.min.set((Number)MathUtils.clamp((double)e.value(), (double)10.0, (double)100.0));
                x.max.set((Number)100.0);
            });
            return false;
        });
        line.addComponent((DLGuiComponent)textMinScaleXBox);
        if (scaleInput.get() != null && minScaleInput.get() != null) {
            ((CreateScrollNumberInput)((Object)scaleInput.get())).min.set((Number)MathUtils.clamp((double)((Double)((CreateScrollNumberInput)((Object)minScaleInput.get())).value.get()), (double)10.0, (double)100.0));
            ((CreateScrollNumberInput)((Object)scaleInput.get())).max.set((Number)100.0);
            ((CreateScrollNumberInput)((Object)minScaleInput.get())).min.set((Number)10.0);
            ((CreateScrollNumberInput)((Object)minScaleInput.get())).max.set((Number)MathUtils.clamp((double)((Double)((CreateScrollNumberInput)((Object)scaleInput.get())).value.get()), (double)10.0, (double)100.0));
        }
        CreateScrollNumberInput textScaleXBox = new CreateScrollNumberInput(0, 0, 32);
        scaleInput.set((Object)textScaleXBox);
        textScaleXBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_x_scale"));
        textScaleXBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_x_scale.description"));
        textScaleXBox.min.set((Number)10.0);
        textScaleXBox.max.set((Number)100.0);
        textScaleXBox.shiftStep.set((Number)5.0);
        textScaleXBox.format.set((Object)new SpecialUnitNumberFormat(0, "%", false, false, (Double)textScaleXBox.min.get(), (Double)textScaleXBox.max.get()));
        textScaleXBox.value.set((Number)((double)setting.getXScale() * 100.0));
        textScaleXBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setXScale((float)e.value() / 100.0f);
            DLUtils.doIfNotNull((Object)((Object)((CreateScrollNumberInput)((Object)((Object)minScaleInput.get())))), x -> {
                x.min.set((Number)10.0);
                x.max.set((Number)MathUtils.clamp((double)e.value(), (double)10.0, (double)100.0));
            });
            return false;
        });
        line.addComponent((DLGuiComponent)textScaleXBox);
        if (scaleInput.get() != null && minScaleInput.get() != null) {
            ((CreateScrollNumberInput)((Object)scaleInput.get())).min.set((Number)MathUtils.clamp((double)((Double)((CreateScrollNumberInput)((Object)minScaleInput.get())).value.get()), (double)10.0, (double)100.0));
            ((CreateScrollNumberInput)((Object)scaleInput.get())).max.set((Number)100.0);
            ((CreateScrollNumberInput)((Object)minScaleInput.get())).min.set((Number)10.0);
            ((CreateScrollNumberInput)((Object)minScaleInput.get())).max.set((Number)MathUtils.clamp((double)((Double)((CreateScrollNumberInput)((Object)scaleInput.get())).value.get()), (double)10.0, (double)100.0));
        }
        CreateScrollNumberInput textScaleYBox = new CreateScrollNumberInput(0, 0, 32);
        textScaleYBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_y_scale"));
        textScaleYBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_y_scale.description"));
        textScaleYBox.min.set((Number)10.0);
        textScaleYBox.max.set((Number)100.0);
        textScaleYBox.shiftStep.set((Number)5.0);
        textScaleYBox.format.set((Object)new SpecialUnitNumberFormat(0, "%", false, false, (Double)textScaleYBox.min.get(), (Double)textScaleYBox.max.get()));
        textScaleYBox.value.set((Number)((double)setting.getYScale() * 100.0));
        textScaleYBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setYScale((float)e.value() / 100.0f);
            return false;
        });
        line.addComponent((DLGuiComponent)textScaleYBox);
    }

    static void buildTextPosGui(ITextPosSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("text_pos");
        Holder.MutableHolder posYInput = new Holder.MutableHolder(null);
        Holder.MutableHolder posXInput = new Holder.MutableHolder(null);
        Holder.MutableHolder leftAlignBtn = new Holder.MutableHolder(null);
        Holder.MutableHolder centerAlignBtn = new Holder.MutableHolder(null);
        Holder.MutableHolder rightAlignBtn = new Holder.MutableHolder(null);
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.TEXT_LEFT_ALIGNED.getAsSprite(16, 16));
        CreateScrollNumberInput textPosXBox = new CreateScrollNumberInput(0, 0, 45);
        posXInput.set((Object)textPosXBox);
        textPosXBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_pos_x"));
        textPosXBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_pos_x.description"));
        textPosXBox.min.set((Number)0.0);
        textPosXBox.max.set((Number)250.0);
        textPosXBox.step.set((Number)0.5);
        textPosXBox.shiftStep.set((Number)5.0);
        textPosXBox.format.set((Object)new SpecialUnitNumberFormat(1, "px", false, false, (Double)textPosXBox.min.get(), (Double)textPosXBox.max.get()));
        textPosXBox.value.set((Number)setting.getX());
        textPosXBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setX((float)e.value());
            return false;
        });
        line.addComponent((DLGuiComponent)textPosXBox);
        CreateScrollNumberInput textPosYBox = new CreateScrollNumberInput(0, 0, 45);
        posYInput.set((Object)textPosYBox);
        textPosYBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_pos_y"));
        textPosYBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_pos_y.description"));
        textPosYBox.min.set((Number)0.0);
        textPosYBox.max.set((Number)250.0);
        textPosYBox.step.set((Number)0.5);
        textPosYBox.shiftStep.set((Number)5.0);
        textPosYBox.format.set((Object)new SpecialUnitNumberFormat(1, "px", false, false, (Double)textPosYBox.min.get(), (Double)textPosYBox.max.get()));
        textPosYBox.value.set((Number)setting.getY());
        textPosYBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setY((float)e.value());
            return false;
        });
        line.addComponent((DLGuiComponent)textPosYBox);
        DLPanel alignPanel = new DLPanel(0, 0, 54, 18);
        FlowLayout layout = new FlowLayout();
        layout.flowDirection.set((Object)FlowLayout.Direction.HORIZONTAL);
        alignPanel.layout.set((Object)layout);
        CreateButton leftAlignButton = new CreateButton(0, 0, (ScreenElement)ModGuiIcons.TEXT_LEFT_ALIGNED.getAsCreateIcon());
        leftAlignBtn.set((Object)leftAlignButton);
        leftAlignButton.tooltip.set((Object)new DLTooltip(List.of(TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_left_aligned")), 200));
        alignPanel.addComponent((DLGuiComponent)leftAlignButton);
        CreateButton centerAlignButton = new CreateButton(0, 0, (ScreenElement)ModGuiIcons.TEXT_CENTERED.getAsCreateIcon());
        centerAlignBtn.set((Object)centerAlignButton);
        centerAlignButton.tooltip.set((Object)new DLTooltip(List.of(TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_centered")), 200));
        alignPanel.addComponent((DLGuiComponent)centerAlignButton);
        CreateButton rightAlignButton = new CreateButton(0, 0, (ScreenElement)ModGuiIcons.TEXT_RIGHT_ALIGNED.getAsCreateIcon());
        rightAlignBtn.set((Object)rightAlignButton);
        rightAlignButton.tooltip.set((Object)new DLTooltip(List.of(TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_right_aligned")), 200));
        alignPanel.addComponent((DLGuiComponent)rightAlignButton);
        alignPanel.layoutContraint.set((Object)FlowLayout.FlowConstraint.END);
        line.addComponent((DLGuiComponent)alignPanel);
        leftAlignButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            ((CreateButton)((Object)((Object)leftAlignBtn.get()))).enabled.set((Object)false);
            ((CreateButton)((Object)((Object)centerAlignBtn.get()))).enabled.set((Object)true);
            ((CreateButton)((Object)((Object)rightAlignBtn.get()))).enabled.set((Object)true);
            setting.setTextAlignment(ETextAlignment.LEFT);
            return false;
        });
        centerAlignButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            ((CreateButton)((Object)((Object)leftAlignBtn.get()))).enabled.set((Object)true);
            ((CreateButton)((Object)((Object)centerAlignBtn.get()))).enabled.set((Object)false);
            ((CreateButton)((Object)((Object)rightAlignBtn.get()))).enabled.set((Object)true);
            setting.setTextAlignment(ETextAlignment.CENTER);
            return false;
        });
        rightAlignButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            ((CreateButton)((Object)((Object)leftAlignBtn.get()))).enabled.set((Object)true);
            ((CreateButton)((Object)((Object)centerAlignBtn.get()))).enabled.set((Object)true);
            ((CreateButton)((Object)((Object)rightAlignBtn.get()))).enabled.set((Object)false);
            setting.setTextAlignment(ETextAlignment.RIGHT);
            return false;
        });
        leftAlignButton.enabled.set((Object)(setting.getTextAlignment() != ETextAlignment.LEFT ? 1 : 0));
        centerAlignButton.enabled.set((Object)(setting.getTextAlignment() != ETextAlignment.CENTER ? 1 : 0));
        rightAlignButton.enabled.set((Object)(setting.getTextAlignment() != ETextAlignment.RIGHT ? 1 : 0));
    }

    static void buildTextMaxWidthGui(ITextWidthSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("text_max_width");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.WIDTH.getAsSprite(16, 16));
        CreateScrollNumberInput textMaxWidthBox = new CreateScrollNumberInput(0, 0, 45);
        textMaxWidthBox.title.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_max_width"));
        textMaxWidthBox.hint.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.text_max_width.description"));
        textMaxWidthBox.min.set((Number)0.0);
        textMaxWidthBox.max.set((Number)250.0);
        textMaxWidthBox.step.set((Number)0.5);
        textMaxWidthBox.shiftStep.set((Number)20.0);
        textMaxWidthBox.format.set((Object)new SpecialUnitNumberFormat(1, "px", false, true, (Double)textMaxWidthBox.min.get(), (Double)textMaxWidthBox.max.get()));
        textMaxWidthBox.value.set((Number)setting.getTextMaxWidth());
        textMaxWidthBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            setting.setTextMaxWidth((float)e.value());
            return false;
        });
        line.addComponent((DLGuiComponent)textMaxWidthBox);
        CreateItemPicker scaleBoundsBox = new CreateItemPicker(0, 0, 0);
        scaleBoundsBox.title.set((Object)ITextWidthSetting.TextScaleBounds.CUT_OFF.getEnumTranslation());
        scaleBoundsBox.hint.set((Object)ITextWidthSetting.TextScaleBounds.CUT_OFF.getEnumDescriptionTranslation());
        scaleBoundsBox.formatter.set(item -> item == null ? TextUtils.empty() : item.getValueTranslation());
        scaleBoundsBox.items.addAll((Object[])ITextWidthSetting.TextScaleBounds.values());
        scaleBoundsBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        scaleBoundsBox.selectedItem.set(Optional.ofNullable(setting.getBoundsAction()));
        scaleBoundsBox.addEventListener(DLCycleButton.SelectedItemChanged.class, (s, e) -> {
            ((Optional)scaleBoundsBox.selectedItem.get()).ifPresent(item -> setting.setBoundsAction((ITextWidthSetting.TextScaleBounds)((Object)((Object)item))));
            return false;
        });
        line.addComponent(scaleBoundsBox);
    }

    static void buildTextBackgroundColorGui(ITextBackgroundColorSetting setting, GuiBuilderContext context) {
        DLPanel line = context.container().addLine("text_bg_color");
        IconSlotWidget icon = (IconSlotWidget)line.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        icon.icon.set((Object)ModGuiIcons.COLOR_PALETTE.getAsSprite(16, 16));
        ColorSlotWidget backgroundColor = new ColorSlotWidget(0, 0, setting.getTextBackgroundColor(), Constants.DEFAULT_TRAIN_TYPE_COLORS, true, true, b -> setting.setTextBackgroundColor((DLColor)b));
        backgroundColor.tooltip.set((Object)new DLTooltip(List.of(ITextBackgroundColorSetting.txtLabelBackgroundColor, IColorSetting.textClickToEdit), 200));
        line.addComponent((DLGuiComponent)backgroundColor);
        DLCheckBox fullLineBox = new DLCheckBox(0, 0, 0, 18);
        fullLineBox.text.set((Object)ITextBackgroundColorSetting.txtFullSize);
        fullLineBox.checked.set((Object)setting.isFullLabelBackgroundColor());
        fullLineBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        fullLineBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
            setting.setFullLabelBackgroundColor(e.checked());
            return false;
        });
        fullLineBox.tooltip.set((Object)new DLTooltip(List.of(ITextBackgroundColorSetting.txtFullSizeDescription), 200));
        line.addComponent((DLGuiComponent)fullLineBox);
    }
}

