/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties.components;

import de.mrjulsen.mcdragonlib.client.gui.widgets.util.INumberFormatAdapter;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Locale;

public class SpecialUnitNumberFormat
extends INumberFormatAdapter.DecimalNumberFormat {
    protected final String unit;
    protected final boolean allowAuto;
    protected final boolean allowMax;
    protected final double minLimit;
    protected final double maxLimit;

    public SpecialUnitNumberFormat(int decimals, String unit, boolean allowAuto, boolean allowMax, double minLimit, double maxLimit) {
        super(decimals);
        this.unit = unit;
        this.allowAuto = allowAuto;
        this.allowMax = allowMax;
        this.minLimit = minLimit;
        this.maxLimit = maxLimit;
    }

    public SpecialUnitNumberFormat(int decimals, String unit) {
        this(decimals, unit, false, false, 0.0, 0.0);
    }

    public String format(double value) {
        double epsilon = 1.0E-5;
        if (this.allowAuto && Math.abs(value - this.minLimit) < epsilon) {
            return TextUtils.translate((String)"gui.createrailwaysnavigator.common.auto").getString();
        }
        if (this.allowMax && Math.abs(value - this.maxLimit) < epsilon) {
            return TextUtils.translate((String)"gui.createrailwaysnavigator.common.max").getString();
        }
        return String.format(Locale.US, "%." + this.decimals + "f%s", value, this.unit);
    }

    public double parse(String input) throws NumberFormatException {
        String trimmedInput = input.trim();
        if (this.allowAuto && trimmedInput.equalsIgnoreCase(TextUtils.translate((String)"gui.createrailwaysnavigator.common.auto").getString())) {
            return this.minLimit;
        }
        if (this.allowMax && trimmedInput.equalsIgnoreCase(TextUtils.translate((String)"gui.createrailwaysnavigator.common.max").getString())) {
            return this.maxLimit;
        }
        String clean = trimmedInput.replace(this.unit, "").trim();
        return Double.parseDouble(clean);
    }
}

