/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import com.google.gson.JsonParser;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.StaticTextDisplaySettings;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.util.VariableManager;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERRichText
implements AbstractAdvancedDisplayRenderer<StaticTextDisplaySettings> {
    private BERLabel[] labels = new BERLabel[0];

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        for (int i = 0; i < this.labels.length && i < ((StaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getComponents().size(); ++i) {
            StaticTextDisplaySettings.TextComponent component = ((StaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getComponents().get(i);
            MutableComponent text = this.getText(component.getStaticText());
            this.labels[i].text.set((Object)text);
        }
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].render(graphics);
        }
    }

    private MutableComponent getText(String input) {
        String staticText = VariableManager.replacePlaceholders(input);
        MutableComponent text = TextUtils.empty();
        if (staticText != null) {
            try {
                JsonParser.parseString((String)staticText);
                text = Component.Serializer.m_130714_((String)staticText);
            }
            catch (Exception e) {
                text = TextUtils.text((String)staticText);
            }
        }
        if (text == null) {
            text = TextUtils.empty();
        }
        return text;
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        if (!blockEntity.isController()) {
            this.labels = new BERLabel[0];
            return;
        }
        ((StaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).verifyComponents();
        List<StaticTextDisplaySettings.TextComponent> components = ((StaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getComponents();
        this.labels = new BERLabel[components.size()];
        for (int i = 0; i < components.size(); ++i) {
            StaticTextDisplaySettings.TextComponent component = components.get(i);
            BERLabel label = new BERLabel();
            MutableComponent text = this.getText(component.getStaticText());
            label.clippingArea.set((Object)Rectangle.withSize((double)3.0, (double)3.0, (double)(blockEntity.getXSizeScaled() * 16 - 6), (double)(blockEntity.getYSizeScaled() * 16 - 6)));
            label.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
            label.horizontalScrollMode.set((Object)component.getBoundsAction().getMode());
            label.horizontalMinScale.set((Number)Float.valueOf(component.getMinXScale()));
            label.horizontalMaxScale.set((Number)Float.valueOf(component.getXScale()));
            label.verticalMinScale.set((Number)Float.valueOf(component.getYScale()));
            label.verticalMaxScale.set((Number)Float.valueOf(component.getYScale()));
            label.text.set((Object)text);
            label.color.set((Object)((StaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getFontColor());
            label.position.set((Object)Point.of((double)(3.0f + component.getX()), (double)(3.0f + component.getY())));
            label.horizontalAlign.set((Object)component.getTextAlignment());
            label.preferredWidth.set((Number)Float.valueOf((float)(component.getTextMaxWidth() >= 250.0f ? Math.min(3.4028234663852886E38, ((Rectangle)label.clippingArea.get()).width()) : (double)component.getTextMaxWidth())));
            label.backgroundColor.set((Object)component.getTextBackgroundColor());
            label.fullBackground.set((Object)component.isFullLabelBackgroundColor());
            label.glowing.set((Object)blockEntity.isGlowing());
            this.labels[i] = label;
        }
    }
}

