/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.TrainDestinationExtendedSettings;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERTrainDestinationDetailed
implements AbstractAdvancedDisplayRenderer<TrainDestinationExtendedSettings> {
    private final Component TEXT_OUT_OF_SERVICE = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.not_in_service");
    private final Component TEXT_DO_NOT_BOARD = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.do_not_board");
    private final BERLabel outOfServiceLabel = new BERLabel();
    private final BERLabel trainLineLabel = new BERLabel();
    private final BERLabel destinationLabel = new BERLabel();
    private final BERLabel viaLabel = new BERLabel();
    private final BERLabel stopoversLabel = new BERLabel();

    public BERTrainDestinationDetailed() {
        this.outOfServiceLabel.text.set((Object)this.TEXT_OUT_OF_SERVICE);
        this.outOfServiceLabel.position.set((Object)Point.of((double)3.0, (double)6.0));
        this.outOfServiceLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.5f)));
        this.outOfServiceLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
        this.outOfServiceLabel.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.outOfServiceLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        this.outOfServiceLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.trainLineLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.5f)));
        this.trainLineLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
        this.trainLineLabel.preferredWidth.set((Number)Float.valueOf(12.0f));
        this.trainLineLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.FLEX_FIT);
        this.destinationLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.5f)));
        this.destinationLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
        this.destinationLabel.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.destinationLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        this.trainLineLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.viaLabel.text.set((Object)CustomLanguage.translate("gui.createrailwaysnavigator.via").m_130940_(ChatFormatting.ITALIC));
        this.viaLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.35f), (Object)Float.valueOf(0.35f)));
        this.viaLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.35f), (Object)Float.valueOf(0.35f)));
        this.stopoversLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.35f), (Object)Float.valueOf(0.35f)));
        this.stopoversLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.35f), (Object)Float.valueOf(0.35f)));
        this.stopoversLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        this.stopoversLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().getState().isIrregular(((TrainDestinationExtendedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).showDoNotBoardText())) {
            this.outOfServiceLabel.render(graphics);
            return;
        }
        this.trainLineLabel.render(graphics);
        this.destinationLabel.render(graphics);
        this.viaLabel.render(graphics);
        this.stopoversLabel.render(graphics);
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        if (blockEntity.getTrainData() == null || blockEntity.getTrainData().getState().isIrregular(((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).showDoNotBoardText())) {
            this.outOfServiceLabel.clippingArea.set((Object)Rectangle.withSize((double)3.0, (double)3.0, (double)(blockEntity.getXSizeScaled() * 16 - 6), (double)(blockEntity.getYSizeScaled() * 16 - 6)));
            this.outOfServiceLabel.preferredWidth.set((Number)Float.valueOf((float)((Rectangle)this.outOfServiceLabel.clippingArea.get()).width()));
            this.outOfServiceLabel.color.set((Object)((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
            this.outOfServiceLabel.text.set((Object)(blockEntity.getTrainData() != null && blockEntity.getTrainData().getState().shouldNotBoard(((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).showDoNotBoardText()) ? this.TEXT_DO_NOT_BOARD : this.TEXT_OUT_OF_SERVICE));
            return;
        }
        this.trainLineLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        this.destinationLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        this.viaLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        this.stopoversLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        this.updateContent(blockEntity);
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity) {
        TrainDestinationExtendedSettings settings = (TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity);
        byte width = settings.getTrainNameWidth();
        this.trainLineLabel.position.set((Object)Point.of((double)3.0, (double)4.0));
        this.trainLineLabel.text.set((Object)(width == 0 ? TextUtils.empty() : TextUtils.text((String)blockEntity.getTrainData().getTrainData().getName()).m_130940_(ChatFormatting.BOLD)));
        this.trainLineLabel.preferredWidth.set((Number)Float.valueOf(settings.isFullTrainNameWidth() ? blockEntity.getXSizeScaled() * 16 - 6 : (settings.isAutoTrainNameWidth() ? 12 : Math.min(((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).getTrainNameWidth(), blockEntity.getXSizeScaled() * 16 - 6))));
        this.trainLineLabel.horizontalScrollMode.set((Object)(settings.isAutoTrainNameWidth() ? BERLabel.EScrollMode.FLEX_FIT : BERLabel.EScrollMode.WHEN_NEEDED));
        this.trainLineLabel.horizontalAlign.set((Object)(settings.isFullTrainNameWidth() ? ETextAlignment.CENTER : ETextAlignment.LEFT));
        if (settings.showLineColor() && blockEntity.getTrainData().getTrainData().hasColor()) {
            this.trainLineLabel.backgroundColor.set((Object)blockEntity.getTrainData().getTrainData().getColor());
            this.trainLineLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)blockEntity.getTrainData().getTrainData().getColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        } else {
            this.trainLineLabel.backgroundColor.set((Object)DLColor.TRANSPARENT);
            this.trainLineLabel.color.set((Object)settings.getFontColor());
        }
        this.destinationLabel.position.set((Object)Point.of((double)((settings.isAutoTrainNameWidth() ? this.trainLineLabel.getRenderedWidth() : (float)width) + 5.0f), (double)4.0));
        this.destinationLabel.preferredWidth.set((Number)Float.valueOf((float)(blockEntity.getXSizeScaled() * 16) - ((Float)this.destinationLabel.x.get()).floatValue() - 3.0f));
        this.destinationLabel.text.set((Object)(settings.isFullTrainNameWidth() ? TextUtils.empty() : TextUtils.text((String)(blockEntity.getTrainData().getCurrentStop().isPresent() ? blockEntity.getTrainData().getCurrentStop().get().getDestination() : ""))));
        this.destinationLabel.color.set((Object)((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        this.destinationLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.viaLabel.position.set((Object)Point.of((double)3.0, (double)10.0));
        this.viaLabel.color.set((Object)((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        this.stopoversLabel.position.set((Object)Point.of((double)(this.viaLabel.getRenderedWidth() + 5.0f), (double)10.0));
        this.stopoversLabel.preferredWidth.set((Number)Float.valueOf((float)(blockEntity.getXSizeScaled() * 16) - ((Float)this.stopoversLabel.x.get()).floatValue() - 3.0f));
        this.stopoversLabel.text.set((Object)TextUtils.concat((Component)TextUtils.text((String)" \u25cf "), blockEntity.getTrainData().getStopovers().stream().map(x -> TextUtils.text((String)x.getRealTimeStation().tagName())).toList()));
        this.stopoversLabel.color.set((Object)((TrainDestinationExtendedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
    }
}

