/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.TrainDestinationCompactSettings;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.util.DLGraphics;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERTrainDestinationSimple
implements AbstractAdvancedDisplayRenderer<TrainDestinationCompactSettings> {
    private final Component TEXT_OUT_OF_SERVICE = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.not_in_service");
    private final Component TEXT_DO_NOT_BOARD = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.do_not_board");
    private final BERLabel outOfServiceLabel = new BERLabel();
    private final BERLabel trainLineLabel = new BERLabel();
    private final BERLabel destinationLabel = new BERLabel();

    public BERTrainDestinationSimple() {
        this.outOfServiceLabel.text.set((Object)this.TEXT_OUT_OF_SERVICE);
        this.outOfServiceLabel.position.set((Object)Point.of((double)3.0, (double)6.0));
        this.outOfServiceLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.5f)));
        this.outOfServiceLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
        this.outOfServiceLabel.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.outOfServiceLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        this.outOfServiceLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.trainLineLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.6f)));
        this.trainLineLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.8f), (Object)Float.valueOf(0.8f)));
        this.destinationLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.5f)));
        this.destinationLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
        this.destinationLabel.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.destinationLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().getState().isIrregular(((TrainDestinationCompactSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).showDoNotBoardText())) {
            this.outOfServiceLabel.render(graphics, light);
            return;
        }
        DLUtils.doIfNotNull((Object)this.trainLineLabel, x -> x.render((DLGraphics)graphics, light));
        DLUtils.doIfNotNull((Object)this.destinationLabel, x -> x.render((DLGraphics)graphics, light));
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        if (blockEntity.getTrainData() == null || blockEntity.getTrainData().getState().isIrregular(((TrainDestinationCompactSettings)this.getDisplaySettings(blockEntity)).showDoNotBoardText())) {
            this.outOfServiceLabel.clippingArea.set((Object)Rectangle.withSize((double)3.0, (double)3.0, (double)(blockEntity.getXSizeScaled() * 16 - 6), (double)(blockEntity.getYSizeScaled() * 16 - 6)));
            this.outOfServiceLabel.preferredWidth.set((Number)Float.valueOf((float)((Rectangle)this.outOfServiceLabel.clippingArea.get()).width()));
            this.outOfServiceLabel.color.set((Object)((TrainDestinationCompactSettings)this.getDisplaySettings(blockEntity)).getFontColor());
            this.outOfServiceLabel.text.set((Object)(blockEntity.getTrainData() != null && blockEntity.getTrainData().getState().shouldNotBoard(((TrainDestinationCompactSettings)this.getDisplaySettings(blockEntity)).showDoNotBoardText()) ? this.TEXT_DO_NOT_BOARD : this.TEXT_OUT_OF_SERVICE));
            return;
        }
        this.trainLineLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 6), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        this.destinationLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 6), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        this.updateContent(blockEntity);
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity) {
        TrainDestinationCompactSettings settings = (TrainDestinationCompactSettings)this.getDisplaySettings(blockEntity);
        byte width = settings.getTrainNameWidth();
        this.trainLineLabel.position.set((Object)Point.of((double)3.0, (double)5.0));
        this.trainLineLabel.text.set((Object)(width == 0 ? TextUtils.empty() : TextUtils.text((String)blockEntity.getTrainData().getTrainData().getName()).m_130940_(ChatFormatting.BOLD)));
        this.trainLineLabel.preferredWidth.set((Number)Float.valueOf((float)(settings.isFullTrainNameWidth() ? ((Rectangle)this.trainLineLabel.clippingArea.get()).width() : (settings.isAutoTrainNameWidth() ? 12.0 : Math.min((double)((TrainDestinationCompactSettings)this.getDisplaySettings(blockEntity)).getTrainNameWidth(), ((Rectangle)this.trainLineLabel.clippingArea.get()).width())))));
        this.trainLineLabel.horizontalScrollMode.set((Object)(settings.isAutoTrainNameWidth() ? BERLabel.EScrollMode.FLEX_FIT : BERLabel.EScrollMode.WHEN_NEEDED));
        this.trainLineLabel.horizontalAlign.set((Object)(settings.isFullTrainNameWidth() ? ETextAlignment.CENTER : ETextAlignment.LEFT));
        if (settings.showLineColor() && blockEntity.getTrainData().getTrainData().hasColor()) {
            this.trainLineLabel.backgroundColor.set((Object)blockEntity.getTrainData().getTrainData().getColor());
            this.trainLineLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)blockEntity.getTrainData().getTrainData().getColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        } else {
            this.trainLineLabel.backgroundColor.set((Object)DLColor.TRANSPARENT);
            this.trainLineLabel.color.set((Object)settings.getFontColor());
        }
        this.destinationLabel.position.set((Object)Point.of((double)((settings.isAutoTrainNameWidth() ? this.trainLineLabel.getRenderedWidth() : (float)width) + 5.0f), (double)6.0));
        this.destinationLabel.preferredWidth.set((Number)Float.valueOf((float)(blockEntity.getXSizeScaled() * 16) - ((Float)this.destinationLabel.x.get()).floatValue() - 3.0f));
        this.destinationLabel.text.set((Object)(settings.isFullTrainNameWidth() ? TextUtils.empty() : TextUtils.text((String)(blockEntity.getTrainData().getCurrentStop().isPresent() ? blockEntity.getTrainData().getCurrentStop().get().getDestination() : ""))));
        this.destinationLabel.color.set((Object)((TrainDestinationCompactSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        this.destinationLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
    }
}

