/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.flyout;

import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.FlatIconButton;
import de.mrjulsen.crn.client.gui.widgets.SearchBox;
import de.mrjulsen.crn.client.gui.widgets.SelectionListBox;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLAbstractCollectionComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.DLAbstractRichTextInputField;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class FlyoutTrainCategoriesWidget
extends AbstractFlyoutWidget {
    private final MutableComponent textTrainCategories = TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_categories").m_130940_(ChatFormatting.BOLD);
    private final UserSettings settings;
    private final SelectionListBox<TrainCategory> trainCategories;
    private final Supplier<UserSettings.UserSetting<Set<UUID>>> getUserSetting;

    public FlyoutTrainCategoriesWidget(DLWindowManager manager, DLGuiComponent parentComponent, AbstractFlyoutWidget.FlyoutPointer pointer, CreateDynamicWidgets.ColorShade pointerShade, UserSettings settings, Supplier<UserSettings.UserSetting<Set<UUID>>> getUserSetting) {
        super(manager, parentComponent, 1, 135, pointer, pointerShade);
        this.setWidth(Math.max(150, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.textTrainCategories) + 18 + 20 + 14));
        this.settings = settings;
        this.getUserSetting = getUserSetting;
        int top = (int)((Rectangle)this.contentArea.get()).y() + 21;
        int contentHeight = (int)((Rectangle)this.contentArea.get()).height() - 21 - 2 - 15;
        this.trainCategories = (SelectionListBox)this.addComponent((DLGuiComponent)new SelectionListBox((int)((Rectangle)this.contentArea.get()).x() + 2, top + 15, (int)((Rectangle)this.contentArea.get()).width() - 4, contentHeight));
        this.trainCategories.textFormat.set(item -> TextUtils.text((String)item.getCategoryName()));
        this.trainCategories.multiselect.set((Object)true);
        this.trainCategories.addEventListener(DLAbstractCollectionComponent.FilterChangedEvent.class, (s, e) -> {
            this.trainCategories.selectIf(arg_0 -> FlyoutTrainCategoriesWidget.lambda$new$1((Supplier)getUserSetting, arg_0));
            return false;
        });
        SearchBox searchBox = (SearchBox)this.addComponent((DLGuiComponent)new SearchBox((int)((Rectangle)this.contentArea.get()).x() + 5, top, (int)((Rectangle)this.contentArea.get()).width() - 10));
        searchBox.addEventListener(DLAbstractRichTextInputField.TextAcceptKeyPressedEvent.class, (s, e) -> {
            this.trainCategories.filter.set(cat -> cat.getCategoryName().toLowerCase().contains(((RichTextComponent)searchBox.text.get()).getPlainText().toLowerCase()));
            return false;
        });
        FlatIconButton resetBtn = (FlatIconButton)this.addComponent((DLGuiComponent)new FlatIconButton((int)((Rectangle)this.contentArea.get()).right() - 18 - 2, (int)((Rectangle)this.contentArea.get()).top() + 2, ModGuiIcons.REFRESH.getAsSprite(16, 16)));
        resetBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            ((UserSettings.UserSetting)getUserSetting.get()).setToDefault();
            this.onOpen();
            return false;
        });
    }

    @Override
    public void renderFlyoutContent(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle contentArea) {
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)((int)contentArea.x() + 8), (int)((int)contentArea.y() + 8), (FormattedText)this.textTrainCategories, (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
    }

    @Override
    protected void onOpen() {
        this.trainCategories.enabled.set((Object)false);
        this.reload(() -> this.trainCategories.enabled.set((Object)true));
    }

    private void reload(Runnable andThen) {
        ModNetworkManager.GET_ALL_TRAIN_CATEGORIES.send((NetworkDirection)NetworkDirection.toServer(), response -> {
            this.trainCategories.items.set(new ArrayList(response.getCategories().stream().sorted((a, b) -> a.getCategoryName().compareToIgnoreCase(b.getCategoryName())).toList()));
            this.trainCategories.selectIf(x -> !this.getUserSetting.get().getValue().contains(x.getId()));
            andThen.run();
        }, () -> {});
    }

    @Override
    protected void onClose() {
        DLUtils.doIfNotNull((Object)this.settings, x -> {
            this.getUserSetting.get().setValue(new HashSet(this.trainCategories.items.get().stream().filter(a -> !((List)this.trainCategories.selectedItems.get()).contains(a) && ((Predicate)this.trainCategories.filter.get()).test(a)).map(a -> a.getId()).collect(Collectors.toSet())));
            x.clientSave(() -> super.close());
        });
    }

    private static /* synthetic */ boolean lambda$new$1(Supplier getUserSetting, TrainCategory x) {
        return !((Set)((UserSettings.UserSetting)getUserSetting.get()).getValue()).contains(x.getId());
    }
}

