/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay.pages;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.overlay.pages.AbstractRouteDetailsPage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.util.ETimeFormat;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class RouteOverviewPage
extends AbstractRouteDetailsPage {
    public static final int ENTRY_HEIGHT = 14;
    private static final MutableComponent textTransfer = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.schedule_transfer");
    private static final MutableComponent textConnectionEndangered = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.connection_endangered");
    private static final MutableComponent textConnectionMissed = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.connection_missed");

    public RouteOverviewPage(ClientRoute route) {
        super(route);
    }

    @Override
    public boolean isImportant() {
        return false;
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        int y = -2;
        int n = 0;
        List parts = this.route.getClientParts().stream().skip(Math.max(this.route.getCurrentPartIndex(), 0)).toList();
        for (int i = 0; i < parts.size(); ++i) {
            ClientRoutePart part = (ClientRoutePart)parts.get(i);
            int toSkip = Math.max(part.getNextStopIndex(), 0);
            List stops = part.getAllStops().stream().skip(toSkip).toList();
            for (int k = 0; k < stops.size() && n < 5; ++k, ++n) {
                TrainStop stop = (TrainStop)stops.get(k);
                RouteOverviewPage.renderStation(graphics, y, this.width(), this.font, stop, toSkip <= 0 && i > 0 && k == 0 ? RoutePathIcons.TRANSFER_STOP : RoutePathIcons.STOP, stop == part.getFirstStop(), !this.route.isPartReachable(part));
                y += 14;
                if (i >= parts.size() - 1 || k < stops.size() - 1) continue;
                Optional<TransferConnection> connection = this.route.getConnectionWith(stop);
                if (connection.isPresent()) {
                    RouteOverviewPage.renderTransfer(graphics, y, this.width(), this.font, connection.get());
                }
                y += 14;
            }
        }
    }

    public static void renderStation(DLGuiGraphics graphics, int y, int width, Font font, TrainStop stop, RoutePathIcons icon, boolean isStart, boolean isMissed) {
        int precision = (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get();
        long scheduledTime = isStart ? stop.getScheduledDepartureTime() : stop.getScheduledArrivalTime();
        String scheduledTimeText = DLTime.fromTicks((double)scheduledTime, (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME);
        long currentTime = isStart ? stop.getScheduledDepartureTime() + stop.getDepartureTimeDeviation() / (long)precision * (long)precision : stop.getScheduledArrivalTime() + stop.getArrivalTimeDeviation() / (long)precision * (long)precision;
        String currentTimeText = DLTime.fromTicks((double)currentTime, (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME);
        Objects.requireNonNull(font);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)7, (int)(y + 14 - 2 - 9 / 2), (FormattedText)TextUtils.text((String)scheduledTimeText).m_130940_(isMissed ? ChatFormatting.STRIKETHROUGH : ChatFormatting.RESET), (DLColor)(isMissed ? Constants.COLOR_DELAYED : DLColor.fromInt((int)-2368549)), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        if (stop.shouldRenderRealTime() && !isMissed) {
            Objects.requireNonNull(font);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)39, (int)(y + 14 - 2 - 9 / 2), (FormattedText)TextUtils.text((String)currentTimeText), (DLColor)(stop.isArrivalDelayed() ? Constants.COLOR_DELAYED : Constants.COLOR_ON_TIME), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        }
        icon.getAsSprite().render(graphics, 74, y);
        Objects.requireNonNull(font);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)88, (int)(y + 14 - 2 - 9 / 2), (FormattedText)TextUtils.truncateWithEllipsis((Font)font, (Component)TextUtils.text((String)stop.getRealTimeStationTag().tagName()), (int)(width - 88 - font.m_92895_(stop.getRealTimeStationTag().info().platform()) - 10)), (DLColor)DLColor.fromInt((int)-2368549), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        Objects.requireNonNull(font);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)(width - 4), (int)(y + 14 - 2 - 9 / 2), (String)stop.getRealTimeStationTag().info().platform(), (DLColor)(stop.isStationInfoChanged() ? Constants.COLOR_DELAYED : DLColor.fromInt((int)-2368549)), (ETextAlignment)ETextAlignment.RIGHT, (boolean)false);
    }

    public static void renderTransfer(DLGuiGraphics graphics, int y, int width, Font font, TransferConnection connection) {
        if (connection.isConnectionMissed()) {
            ModGuiIcons.CROSS.getAsSprite(16, 16).render(graphics, 5, y + 14 - 2 - 8);
            Objects.requireNonNull(font);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)88, (int)(y + 14 - 2 - 9 / 2), (FormattedText)textConnectionMissed.m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        } else if (connection.isConnectionEndangered()) {
            ModGuiIcons.WARN.getAsSprite(16, 16).render(graphics, 5, y + 14 - 2 - 8);
            Objects.requireNonNull(font);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)88, (int)(y + 14 - 2 - 9 / 2), (FormattedText)textConnectionEndangered.m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GOLD), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        } else {
            long transferTime = connection.getRealTimeTransferTime();
            String transferTimeText = DLTime.fromTicks((double)transferTime, (ITimeSystem)new ConfiguredTimeSystem()).format(Constants.DEFAULT_VERBOSE_GAME_DURATION_FORMAT, TimeContext.INGAME);
            Objects.requireNonNull(font);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)7, (int)(y + 14 - 2 - 9 / 2), (FormattedText)TextUtils.text((String)transferTimeText).m_130940_(ChatFormatting.ITALIC), (DLColor)DLColor.fromInt((int)-2368549), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
            Objects.requireNonNull(font);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)88, (int)(y + 14 - 2 - 9 / 2), (FormattedText)textTransfer.m_130940_(ChatFormatting.ITALIC), (DLColor)DLColor.fromInt((int)-2368549), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        }
        RoutePathIcons.TRANSFER.getAsSprite().render(graphics, 74, y);
    }

    public static enum RoutePathIcons {
        CURRENT(0),
        STOP(1),
        TRANSFER_STOP(2),
        TRANSFER(3),
        START(4);

        private static final int V = 30;
        private static final int START_U = 21;
        private static final int SPRITE_WIDTH = 7;
        private static final int SPRITE_HEIGHT = 14;
        private int index;

        private RoutePathIcons(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static RoutePathIcons getByIndex(int index) {
            return Arrays.stream(RoutePathIcons.values()).filter(x -> x.getIndex() == index).findFirst().orElse(START);
        }

        public DLSprite getAsSprite() {
            return new DLSprite(CRNGui.GUI, 7, 14, 21 + this.getIndex() * 7, 30, 7, 14);
        }
    }
}

