/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay.pages;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.overlay.pages.AbstractRouteDetailsPage;
import de.mrjulsen.crn.client.gui.overlay.pages.RouteOverviewPage;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class TransferPage
extends AbstractRouteDetailsPage {
    private static final String keyScheduleTransfer = "gui.createrailwaysnavigator.route_overview.schedule_transfer";
    private static final String keyTransfer = "gui.createrailwaysnavigator.route_overview.transfer";
    private static final String keyTransferWithPlatform = "gui.createrailwaysnavigator.route_overview.transfer_with_platform";
    private static final String keyTimeNow = "gui.createrailwaysnavigator.time.now";
    private final TransferConnection connection;
    private MultiLineLabel messageLabel;

    public TransferPage(ClientRoute route, TransferConnection connection) {
        super(route);
        this.connection = connection;
        String terminus = connection.getDepartureStation().getDisplayTitle();
        StationTag.StationInfo info = connection.getDepartureStation().getRealTimeStationTag().info();
        this.messageLabel = MultiLineLabel.m_94341_((Font)this.font, (FormattedText)(info.platform() == null || info.platform().isBlank() ? CustomLanguage.translate(keyTransfer, connection.getDepartureStation().getTrainDisplayName(), terminus) : CustomLanguage.translate(keyTransferWithPlatform, connection.getDepartureStation().getTrainDisplayName(), terminus, info.platform())), (int)(this.width() - 31));
    }

    @Override
    public boolean isImportant() {
        return true;
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        int y = 0;
        RouteOverviewPage.renderStation(graphics, -4, this.width(), this.font, this.connection.getDepartureStation(), RouteOverviewPage.RoutePathIcons.START, true, this.connection.isConnectionMissed());
        GuiUtils.fill((DLGuiGraphics)graphics, (int)0, (int)(y += 16), (int)this.width(), (int)1, (DLColor)DLColor.WHITE);
        ModGuiIcons.WALK.render(graphics, 5, y + 3);
        long transferTime = this.connection.getDepartureStation().getRealTimeDepartureTime() - DragonLib.getCurrentWorldTime();
        MutableComponent transferTimeText = TextUtils.text((String)DLTime.fromTicks((double)transferTime, (ITimeSystem)new ConfiguredTimeSystem()).format(Constants.DEFAULT_VERBOSE_GAME_DURATION_FORMAT, TimeContext.INGAME));
        Objects.requireNonNull(this.font);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)26, (int)(y + 3 + 8 - 9 / 2), (FormattedText)CustomLanguage.translate(keyScheduleTransfer).m_130946_(" ").m_7220_((Component)(transferTime > 0L ? transferTimeText : CustomLanguage.translate(keyTimeNow))).m_130940_(ChatFormatting.BOLD), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        GuiGraphics guiGraphics = graphics.graphics();
        Objects.requireNonNull(this.font);
        this.messageLabel.m_6508_(guiGraphics, 26, y += 21, 9, -2368549);
    }
}

