/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.Animator;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.ModalId;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.RenderLayer;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLTexture;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.util.Cache;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import net.minecraft.client.Minecraft;

public abstract class AbstractFlyoutWidget
extends DLWindow {
    protected final DLGuiComponent parentComponent;
    protected final FlyoutPointer pointer;
    protected final CreateDynamicWidgets.ColorShade pointerShade;
    protected final int distanceToParent = 0;
    protected final Animator animator;
    private int xOffset;
    private int yOffset;
    private boolean isClosing = false;
    private boolean isClosed = false;
    protected final Cache<Rectangle> contentArea = new Cache(() -> Rectangle.withSize((double)5.0, (double)5.0, (double)(this.width() - 10), (double)(this.height() - 10)));

    public AbstractFlyoutWidget(DLWindowManager manager, DLGuiComponent parentComponent, int width, int height, FlyoutPointer pointer, CreateDynamicWidgets.ColorShade pointerShade) {
        super(manager);
        this.setSize(width, height);
        this.parentComponent = parentComponent;
        this.pointerShade = pointerShade;
        this.pointer = pointer;
        this.animator = (Animator)this.addComponent(new Animator());
        this.addEventListener(DLWindow.WindowFocusEvent.class, (src, e) -> {
            if (!e.focus()) {
                for (DLWindow win : this.getWindowManager().getWindows((ModalId)this.getAssignedModal().get())) {
                    if (this.getWindowManager().getFocusedWindow() != win) continue;
                    return false;
                }
                this.close();
            }
            return false;
        });
        this.addEventListener(DLWindow.WindowCreatedEvent.class, (s, e) -> {
            this.enabled.set((Object)false);
            this.onOpen();
            Point componentPos = parentComponent.toScreenCoordinates();
            switch (pointer.ordinal()) {
                case 0: {
                    this.setX(MathUtils.clamp((int)(this.xOffset + (int)componentPos.x() + parentComponent.width() / 2 - this.width() / 2), (int)0, (int)(Minecraft.m_91087_().f_91080_.f_96543_ - this.width())));
                    this.setY(MathUtils.clamp((int)(this.yOffset + (int)componentPos.y() + parentComponent.height() + 0), (int)0, (int)(Minecraft.m_91087_().f_91080_.f_96544_ - this.height() - 0)));
                    break;
                }
                case 1: {
                    this.setX(MathUtils.clamp((int)(this.xOffset + (int)componentPos.x() + parentComponent.width() / 2 - this.width() / 2), (int)0, (int)(Minecraft.m_91087_().f_91080_.f_96543_ - this.width())));
                    this.setY(MathUtils.clamp((int)(this.yOffset + (int)componentPos.y() - this.height() - 0), (int)0, (int)(Minecraft.m_91087_().f_91080_.f_96544_ - this.height() - 0)));
                    break;
                }
                case 2: {
                    this.setX(MathUtils.clamp((int)(this.xOffset + (int)componentPos.x() - this.width() - 0), (int)0, (int)(Minecraft.m_91087_().f_91080_.f_96543_ - this.width() - 0)));
                    this.setY(MathUtils.clamp((int)(this.yOffset + (int)componentPos.y() + parentComponent.height() / 2 - this.height() / 2), (int)0, (int)(Minecraft.m_91087_().f_91080_.f_96544_ - this.height())));
                    break;
                }
                case 3: {
                    this.setX(MathUtils.clamp((int)(this.xOffset + (int)componentPos.x() + parentComponent.width() + 0), (int)0, (int)(Minecraft.m_91087_().f_91080_.f_96543_ - this.width() - 0)));
                    this.setY(MathUtils.clamp((int)(this.yOffset + (int)componentPos.y() + parentComponent.height() / 2 - this.height() / 2), (int)0, (int)(Minecraft.m_91087_().f_91080_.f_96544_ - this.height())));
                }
            }
            this.contentArea.clear();
            this.animator.start(3, null, null, () -> this.enabled.set((Object)true));
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.RenderPreEvent.class, (s, e) -> {
            if (e.layer() != RenderLayer.MAIN) {
                return false;
            }
            this.renderBasePre(e.graphics(), e.mouseX(), e.mouseY(), e.renderBounds());
            return false;
        }, 100);
        this.addEventListener(DLGuiStandardEvents.RenderPostEvent.class, (s, e) -> {
            if (e.layer() != RenderLayer.MAIN) {
                return false;
            }
            this.renderBasePost(e.graphics(), e.mouseX(), e.mouseY(), e.renderBounds());
            return false;
        }, -100);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() {
        this.isClosing = true;
        this.enabled.set((Object)false);
        this.animator.start(3, null, null, () -> this.closeImmediately());
    }

    public void closeImmediately() {
        this.isClosing = true;
        this.onClose();
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.getWindowManager().closeModal((ModalId)this.getAssignedModal().get());
    }

    protected void onOpen() {
    }

    protected void onClose() {
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        this.renderFlyout(graphics, mouseX, mouseY, (Rectangle)this.contentArea.get());
        this.renderFlyoutContent(graphics, mouseX, mouseY, (Rectangle)this.contentArea.get());
    }

    public void renderBasePre(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        graphics.poseStack().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (this.animator.isRunning()) {
            if (this.isClosing) {
                switch (this.pointer.ordinal()) {
                    case 0: {
                        graphics.poseStack().m_252880_(0.0f, -this.animator.getCurrentTicksSmooth() * 2.0f, 0.0f);
                        break;
                    }
                    case 1: {
                        graphics.poseStack().m_252880_(0.0f, (float)(this.animator.getTotalTicks() * 2) - this.animator.getCurrentTicksSmooth() * 2.0f, 0.0f);
                        break;
                    }
                    case 3: {
                        graphics.poseStack().m_252880_((float)(this.animator.getTotalTicks() * 2) - this.animator.getCurrentTicksSmooth() * 2.0f, 0.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        graphics.poseStack().m_252880_(this.animator.getCurrentTicksSmooth() * 2.0f, 0.0f, 0.0f);
                    }
                }
                GuiUtils.setTint((DLColor)DLColor.of((float)(1.0f - this.animator.getPercentage()), (float)1.0f, (float)1.0f, (float)1.0f));
            } else {
                switch (this.pointer.ordinal()) {
                    case 0: {
                        graphics.poseStack().m_252880_(0.0f, (float)(-this.animator.getTotalTicks() * 2) + this.animator.getCurrentTicksSmooth() * 2.0f, 0.0f);
                        break;
                    }
                    case 1: {
                        graphics.poseStack().m_252880_(0.0f, this.animator.getCurrentTicksSmooth() * 2.0f, 0.0f);
                        break;
                    }
                    case 3: {
                        graphics.poseStack().m_252880_(-this.animator.getCurrentTicksSmooth() * 2.0f, 0.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        graphics.poseStack().m_252880_((float)(this.animator.getTotalTicks() * 2) - this.animator.getCurrentTicksSmooth() * 2.0f, 0.0f, 0.0f);
                    }
                }
                GuiUtils.setTint((DLColor)DLColor.of((float)this.animator.getPercentage(), (float)1.0f, (float)1.0f, (float)1.0f));
            }
        }
        graphics.poseStack().m_85836_();
    }

    public void renderBasePost(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        graphics.poseStack().m_85849_();
        graphics.poseStack().m_85849_();
        GuiUtils.resetTint();
        RenderSystem.disableBlend();
    }

    public void renderFlyoutContent(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle contentArea) {
    }

    public void renderFlyout(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle contentArea) {
        CreateDynamicWidgets.renderShadow(graphics, (int)contentArea.x(), (int)contentArea.y(), (int)contentArea.width(), (int)contentArea.height());
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, (int)contentArea.x(), (int)contentArea.y(), (int)contentArea.width(), (int)contentArea.height(), this.pointerShade);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        switch (this.pointer.ordinal()) {
            case 0: {
                this.pointer.render(graphics, this.width() / 2 - 3, 0, this.pointerShade);
                break;
            }
            case 1: {
                this.pointer.render(graphics, this.width() / 2 - 3, this.height() - 7, this.pointerShade);
                break;
            }
            case 3: {
                this.pointer.render(graphics, 0, this.height() / 2 - 3, this.pointerShade);
                break;
            }
            case 2: {
                this.pointer.render(graphics, this.width() - 7, this.height() / 2 - 3, this.pointerShade);
                break;
            }
        }
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public static enum FlyoutPointer {
        UP(0, 54),
        DOWN(14, 54),
        RIGHT(28, 54),
        LEFT(42, 54);

        private final int u;
        private final int v;
        public static final int WIDTH = 7;
        public static final int HEIGHT = 7;

        private FlyoutPointer(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public int getU() {
            return this.u;
        }

        public int getV() {
            return this.v;
        }

        public void render(DLGuiGraphics graphics, int x, int y, CreateDynamicWidgets.ColorShade shade) {
            int u = shade == CreateDynamicWidgets.ColorShade.LIGHT ? this.getU() : this.getU() + 7;
            GuiUtils.drawTexture((DLTexture)CRNGui.GUI, (DLGuiGraphics)graphics, (int)x, (int)y, (int)7, (int)7, (int)u, (int)this.v);
        }
    }
}

