/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.builtin.DLColorPickerWindow;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;

public class ColorPickerWidget
extends DLGuiComponent {
    private DLColor selectedColor = DLColor.TRANSPARENT;

    public ColorPickerWidget(int px, int py, DLColor[] sampleColors, int maxColorsPerLine, DLColor preselectedColor, boolean allowCustom, boolean allowNone, Consumer<DLColor> onAccept) {
        super(px, py, 1, 1);
        this.selectedColor = preselectedColor;
        int lines = (int)Math.ceil((double)sampleColors.length / (double)maxColorsPerLine);
        this.setHeight(18 * ((allowCustom ? 1 : 0) + (allowNone ? 1 : 0)) + lines * 13 - 1);
        this.setWidth(maxColorsPerLine * 13 - 1);
        int currentY = 0;
        if (allowCustom) {
            this.addComponent((DLGuiComponent)new ColorBrowserButton(0, currentY, this.width(), () -> this.selectedColor, btn -> this.getWindowManager().createModal(mgr -> new DLColorPickerWindow(mgr, false, this.selectedColor.withAlpha(255), a -> onAccept.accept((DLColor)a)))));
            currentY += 18;
        }
        int i = 0;
        for (int y = 0; y < lines && i < sampleColors.length; ++y) {
            for (int x = 0; x < maxColorsPerLine && i < sampleColors.length; ++x) {
                int j = i++;
                this.addComponent((DLGuiComponent)new ColorButton(x * 13, currentY + y * 13, sampleColors[j], btn -> onAccept.accept(sampleColors[j])));
            }
        }
        if (allowNone) {
            this.addComponent((DLGuiComponent)new NoColorButton(0, this.height() - 16, this.width(), btn -> onAccept.accept(DLColor.TRANSPARENT)));
        }
    }

    public DLColor getSelectedColor() {
        return this.selectedColor;
    }

    private static class ColorBrowserButton
    extends DLButton {
        private final Supplier<DLColor> color;

        public ColorBrowserButton(int pX, int pY, int pWidth, Supplier<DLColor> color, Consumer<ColorBrowserButton> pOnPress) {
            super(pX, pY, pWidth, 16);
            this.color = color;
            this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                pOnPress.accept(this);
                return false;
            });
        }

        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            GuiUtils.drawBox((DLGuiGraphics)graphics, (int)0, (int)0, (int)this.width(), (int)this.height(), (DLColor)this.color.get(), (DLColor)(this.isSelected() ? DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR : DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR));
            Font font = graphics.defaultFont();
            int n = this.x() + this.width() / 2;
            int n2 = this.y() + this.height() / 2;
            Objects.requireNonNull(graphics.defaultFont());
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)n, (int)(n2 - 9 / 2), (FormattedText)TextUtils.text((String)"Custom..."), (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.CENTER, (boolean)true);
        }
    }

    private static class ColorButton
    extends DLButton {
        private final DLColor color;

        public ColorButton(int pX, int pY, DLColor color, Consumer<ColorButton> pOnPress) {
            super(pX, pY, 12, 12);
            this.color = color;
            this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                pOnPress.accept(this);
                return false;
            });
        }

        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            GuiUtils.drawBox((DLGuiGraphics)graphics, (int)0, (int)0, (int)this.width(), (int)this.height(), (DLColor)this.color, (DLColor)(this.isSelected() ? DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR : DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR));
            Font font = graphics.defaultFont();
            int n = this.x() + this.width() / 2;
            int n2 = this.y() + this.height() / 2;
            Objects.requireNonNull(graphics.defaultFont());
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)n, (int)(n2 - 9 / 2), (FormattedText)TextUtils.empty(), (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.CENTER, (boolean)true);
        }
    }

    private static class NoColorButton
    extends DLButton {
        public NoColorButton(int pX, int pY, int pWidth, Consumer<NoColorButton> pOnPress) {
            super(pX, pY, pWidth, 16);
            this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                pOnPress.accept(this);
                return false;
            });
        }

        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            GuiUtils.drawBox((DLGuiGraphics)graphics, (int)0, (int)0, (int)this.width(), (int)this.height(), (DLColor)DLColor.TRANSPARENT, (DLColor)(this.isSelected() ? DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR : DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR));
            Font font = graphics.defaultFont();
            int n = this.x() + this.width() / 2;
            int n2 = this.y() + this.height() / 2;
            Objects.requireNonNull(graphics.defaultFont());
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)n, (int)(n2 - 9 / 2), (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.color_picker.no_color"), (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.CENTER, (boolean)true);
        }
    }
}

