/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.VanillaSimpleButtonRenderer;
import de.mrjulsen.mcdragonlib.client.render.DefaultGuiTextures;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.Objects;
import net.minecraft.client.gui.Font;

public class DBNavigatorWidget
extends DLGuiComponent {
    public static final int WIDTH = 54;
    private final String txt;

    public DBNavigatorWidget(int x, int y, int height, int currentIndex, int max, Runnable next, Runnable previous) {
        super(x, y, 54, height);
        DLButton backBtn = (DLButton)this.addComponent((DLGuiComponent)new DLButton(0, 0, 10, this.height()));
        backBtn.icon.set((Object)GuiIcons.ARROW_LEFT.getAsSprite(16, 16));
        backBtn.text.set((Object)TextUtils.EMPTY);
        backBtn.componentRenderer.set((Object)VanillaSimpleButtonRenderer.VANILLA_BUTTON_GRAY);
        backBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            DLUtils.doIfNotNull((Object)previous, Runnable::run);
            return false;
        });
        DLButton nextBtn = (DLButton)this.addComponent((DLGuiComponent)new DLButton(this.width() - 10, 0, 10, this.height()));
        nextBtn.icon.set((Object)GuiIcons.ARROW_RIGHT.getAsSprite(16, 16));
        nextBtn.text.set((Object)TextUtils.EMPTY);
        nextBtn.componentRenderer.set((Object)VanillaSimpleButtonRenderer.VANILLA_BUTTON_GRAY);
        nextBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            DLUtils.doIfNotNull((Object)next, Runnable::run);
            return false;
        });
        this.txt = String.format("%s/%s", currentIndex + 1, max);
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        DefaultGuiTextures.DRAGONLIB_UI.getSprite("button_gray_normal").render(graphics, 10, 0, this.width() - 20, this.height());
        Font font = graphics.defaultFont();
        int n = this.width() / 2;
        int n2 = this.height() / 2;
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)n, (int)(n2 - 9 / 2), (String)this.txt, (DLColor)DragonLib.VANILLA_UI_FONT_COLOR, (ETextAlignment)ETextAlignment.CENTER, (boolean)false);
    }
}

