/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.create;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.utility.CreateLang;
import de.mrjulsen.crn.client.gui.flyout.FlyoutItemSelectionBrowser;
import de.mrjulsen.crn.client.gui.widgets.create.CreateItemPickerRenderer;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLItemPicker;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;

public class CreateItemPicker<T>
extends DLItemPicker<T> {
    protected final Component scrollToModify = CreateLang.translateDirect((String)"gui.scrollInput.scrollToModify", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY});
    protected final Component shiftScrollsFaster = CreateLang.translateDirect((String)"gui.scrollInput.shiftScrollsFaster", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY});
    protected final Component clickToSearch = TextUtils.translate((String)"gui.createrailwaysnavigator.common.click_to_search").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC);
    public final Property<Component> title = new Property((Object)CreateLang.translateDirect((String)"gui.scrollInput.defaultTitle", (Object[])new Object[0]));
    public final Property<Component> hint = new Property((Object)TextUtils.empty());
    public final Property<Function<T, Component>> formatter = new Property(t -> TextUtils.text((String)t.toString()));
    public final Property<BiPredicate<T, String>> filter = new Property((i, s) -> String.valueOf(i).toLowerCase().contains(s.toLowerCase()));
    public final BooleanProperty renderArrow = new BooleanProperty(false);

    public CreateItemPicker(int x, int y, int w) {
        super(x, y, w, 18);
        this.componentRenderer.set((Object)CreateItemPickerRenderer.INSTANCE);
        this.showButtons.set((Object)false);
        this.drawFontShadow.set((Object)true);
        this.formatter.withAfterPropertyChangedCallback((o, n) -> this.textFormat.set(item -> (Component)((Function)this.formatter.get()).apply(((Optional)item.selectedItem.get()).orElse(null))));
        this.addEventListener(DLCycleButton.SelectedItemChanged.class, (s, e) -> {
            this.updateTooltip();
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (s, e) -> {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)(1.5f + 0.1f * (float)((Integer)this.selectedIndex.get() - 0) / (float)this.items.size())));
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new FlyoutItemSelectionBrowser(mgr, this, (BiPredicate)this.filter.get()));
            return false;
        });
    }

    protected void updateSelectedItem(boolean firstIfUnselected) {
        this.updateTooltip();
        super.updateSelectedItem(firstIfUnselected);
    }

    public void changeValueOnScroll(int direction) {
        super.changeValueOnScroll(direction * -1);
    }

    protected void updateTooltip() {
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add(((Component)this.title.get()).m_6879_().m_130938_(s -> s.m_178520_(AbstractSimiWidget.HEADER_RGB.getRGB())));
        int min = Math.max(0, Math.min(this.items.size(), (Integer)this.selectedIndex.get() + 8) - 16);
        int max = Math.min(this.items.size(), min + 16);
        if (min > 0) {
            lines.add(TextUtils.text((String)"> ...").m_130940_(ChatFormatting.GRAY));
        }
        for (int i = min; i < max; ++i) {
            Object item = this.items.get(i);
            if ((Integer)this.selectedIndex.get() == i) {
                lines.add(TextUtils.text((String)"-> ").m_7220_((Component)((Component)((Function)this.formatter.get()).apply(item)).m_6879_()).m_130940_(ChatFormatting.WHITE));
                continue;
            }
            lines.add(TextUtils.text((String)"> ").m_7220_((Component)((Component)((Function)this.formatter.get()).apply(item)).m_6879_()).m_130940_(ChatFormatting.GRAY));
        }
        if (max < this.items.size()) {
            lines.add(TextUtils.text((String)"> ...").m_130940_(ChatFormatting.GRAY));
        }
        lines.add(((Component)this.hint.get()).m_6879_().m_130938_(s -> s.m_178520_(AbstractSimiWidget.HINT_RGB.getRGB())));
        lines.add(this.scrollToModify);
        lines.add(this.shiftScrollsFaster);
        lines.add(this.clickToSearch);
        this.tooltip.set((Object)new DLTooltip(lines, 200));
    }
}

