/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.routedetails;

import de.mrjulsen.crn.client.gui.widgets.routedetails.RouteDetailsTransferWidget;
import de.mrjulsen.crn.client.gui.widgets.routedetails.RoutePartWidget;
import de.mrjulsen.crn.client.gui.widgets.skins.ModernScrollbarComponentRenderer;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.FlowLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;

public class RouteDetailsViewer
extends DLGuiComponent {
    private final DLPanel contentPanel;
    private final DLScrollBar scrollbar;
    public final BooleanProperty expanded = new BooleanProperty(false);
    public final BooleanProperty showTrainDetails = new BooleanProperty(true);
    public final BooleanProperty showEntireJourney = new BooleanProperty(false);
    public final BooleanProperty canExpandCollapse = new BooleanProperty(true);

    public RouteDetailsViewer(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.contentPanel = (DLPanel)this.addComponent((DLGuiComponent)new DLPanel(0, 0, this.width(), this.height()));
        this.contentPanel.anchor.set2((Enum[])EAlign.values());
        this.contentPanel.inputConsumptionPolicy.set(type -> false);
        FlowLayout layout = new FlowLayout();
        layout.fillCrossAxis.set((Object)true);
        layout.flowDirection.set((Object)FlowLayout.Direction.VERTICAL);
        layout.padding.set((Object)new Padding(10, 9, 10, 0));
        layout.wrap.set((Object)false);
        this.contentPanel.layout.set((Object)layout);
        this.scrollbar = (DLScrollBar)this.addComponent((DLGuiComponent)new DLScrollBar(this.width() - 5, 0, 5, this.height(), DLScrollBar.Orientation.VERTICAL));
        this.scrollbar.componentRenderer.set((Object)ModernScrollbarComponentRenderer.INSTANCE);
        this.scrollbar.anchor.set2((Enum[])new EAlign[]{EAlign.TOP, EAlign.BOTTOM, EAlign.RIGHT});
        this.scrollbar.scrollerSize.set((Number)0);
        this.scrollbar.screenSize.set((Number)this.contentPanel.height());
        this.scrollbar.scrollSteps.set((Number)15);
        this.scrollbar.max.set((Number)0);
        this.scrollbar.inputConsumptionPolicy.set(type -> true);
        this.scrollbar.addEventListener(DLScrollBar.ValueChangedEvent.class, (s, e) -> {
            this.contentPanel.setScrollOffsetY(e.value());
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (arg_0, arg_1) -> ((DLScrollBar)this.scrollbar).invokeEvent(arg_0, arg_1));
        this.contentPanel.addEventListener(DLGuiStandardEvents.ComponentLayoutUpdatedEvent.class, (s, e) -> {
            this.scrollbar.max.set((Number)e.layoutResult().contentHeight());
            this.scrollbar.screenSize.set((Number)this.contentPanel.height());
            return false;
        });
    }

    public void displayRoute(ClientRoute route) {
        this.displayRouteInternal(route, route.getClientParts(), true);
    }

    public void displayPart(ClientRoute route, Predicate<RoutePart> verifiedSelector) {
        this.displayRouteInternal(route, route.getClientParts().stream().filter(verifiedSelector).toList(), false);
    }

    public void displayRouteInternal(ClientRoute route, List<ClientRoutePart> parts, boolean showTransfers) {
        this.contentPanel.clearComponents();
        ConcurrentLinkedQueue<TransferConnection> connections = new ConcurrentLinkedQueue<TransferConnection>(route.getConnections());
        for (int i = 0; i < parts.size(); ++i) {
            ClientRoutePart part = parts.get(i);
            RoutePartWidget widget = new RoutePartWidget(this.width(), route, part);
            widget.expanded.set((Object)((Boolean)this.expanded.get()));
            widget.canExpandCollapse.set((Object)((Boolean)this.canExpandCollapse.get()));
            widget.showTrainDetails.set((Object)((Boolean)this.showTrainDetails.get()));
            widget.showEntireJourney.set((Object)((Boolean)this.showEntireJourney.get()));
            this.contentPanel.addComponent((DLGuiComponent)widget);
            if (connections.isEmpty() || !showTransfers) continue;
            RouteDetailsTransferWidget routeDetailsTransferWidget = (RouteDetailsTransferWidget)this.contentPanel.addComponent((DLGuiComponent)new RouteDetailsTransferWidget((TransferConnection)connections.poll()));
        }
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (this.scrollbar.canScroll() && (Double)this.scrollbar.value.get() > 0.0) {
            GuiUtils.fillGradient((DLGuiGraphics)graphics, (int)0, (int)0, (int)this.width(), (int)10, (DLColor)DLColor.fromInt((int)0x77000000), (DLColor)DLColor.TRANSPARENT, (EAlign)EAlign.TOP);
        }
        if (this.scrollbar.canScroll() && (Double)this.scrollbar.value.get() < (double)((Integer)this.scrollbar.max.get()).intValue()) {
            GuiUtils.fillGradient((DLGuiGraphics)graphics, (int)0, (int)(this.height() - 10), (int)this.width(), (int)10, (DLColor)DLColor.fromInt((int)0x77000000), (DLColor)DLColor.TRANSPARENT, (EAlign)EAlign.BOTTOM);
        }
    }
}

