/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.routedetails;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.windows.ScheduleBoardWindow;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.util.ETimeFormat;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLTexture;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.VanillaTimeSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;

public class RoutePartEntryWidget
extends DLButton {
    protected static final DLTexture GUI = new DLTexture(DLUtils.resourceLocation((String)"createrailwaysnavigator", (String)"textures/gui/widgets.png"), 256, 256);
    protected static final int ENTRY_WIDTH = 225;
    private final ClientRoute route;
    private final ClientRoutePart part;
    private final ClientTrainStop stop;
    private final TrainStopType type;
    private boolean valid;

    public RoutePartEntryWidget(ClientRoutePart part, ClientRoute route, ClientTrainStop stop, TrainStopType type, boolean valid) {
        super(0, 0, 225, type.h);
        this.route = route;
        this.part = part;
        this.stop = stop;
        this.type = type;
        this.valid = valid;
        this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new ScheduleBoardWindow(mgr, stop.getRealTimeStationTag()));
            return false;
        });
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        GuiUtils.drawTexture((DLTexture)GUI, (DLGuiGraphics)graphics, (int)0, (int)0, (int)225, (int)this.height(), (int)0, (int)this.type.v, (int)225, (int)this.height(), (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH);
        this.renderData(graphics, this.type.dy);
        if (this.isSelected()) {
            GuiUtils.fill((DLGuiGraphics)graphics, (int)24, (int)(this.type.dy - 1), (int)199, (int)20, (DLColor)DLColor.fromInt((int)0x22FFFFFF));
        }
    }

    public void tick() {
        super.tick();
        this.valid = this.route.isPartReachable(this.part);
    }

    protected void renderData(DLGuiGraphics graphics, int y) {
        float scale = 0.75f;
        String platformText = this.stop.getRealTimeStationTag().info().platform();
        String nameText = this.stop.getRealTimeStationTag().tagName();
        int maxStationNameWidth = 130 - graphics.defaultFont().m_92895_(platformText) - 6;
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)80, (int)(this.type.dy + 5), (String)TextUtils.truncateWithEllipsis((Font)graphics.defaultFont(), (String)nameText, (int)maxStationNameWidth), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)(this.width() - 12), (int)(this.type.dy + 5), (String)platformText, (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.RIGHT, (boolean)false);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(0.75f, 0.75f, 1.0f);
        int precision = (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get();
        if (this.type == TrainStopType.TRANSIT) {
            graphics.poseStack().m_252880_((float)(this.x() + 28) / 0.75f, (float)(y + 2) / 0.75f, 0.0f);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)0, (int)0, (FormattedText)TextUtils.text((String)DLTime.fromTicks((double)this.stop.getScheduledArrivalTime(), (ITimeSystem)VanillaTimeSystem.INSTANCE).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME)).m_130940_(this.valid ? ChatFormatting.RESET : ChatFormatting.STRIKETHROUGH), (DLColor)(this.valid ? DLColor.WHITE : Constants.COLOR_DELAYED), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)0, (int)12, (FormattedText)TextUtils.text((String)DLTime.fromTicks((double)this.stop.getScheduledDepartureTime(), (ITimeSystem)VanillaTimeSystem.INSTANCE).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME)).m_130940_(this.valid ? ChatFormatting.RESET : ChatFormatting.STRIKETHROUGH), (DLColor)(this.valid ? DLColor.WHITE : Constants.COLOR_DELAYED), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
            if (this.stop.shouldRenderRealTime() && !this.part.isCancelled() && this.valid) {
                GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)30, (int)0, (FormattedText)TextUtils.text((String)DLTime.fromTicks((double)(this.stop.getScheduledArrivalTime() + this.stop.getArrivalTimeDeviation() / (long)precision * (long)precision), (ITimeSystem)VanillaTimeSystem.INSTANCE).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME)), (DLColor)(this.stop.isArrivalDelayed() ? Constants.COLOR_DELAYED : Constants.COLOR_ON_TIME), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
                GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)30, (int)12, (FormattedText)TextUtils.text((String)DLTime.fromTicks((double)(this.stop.getScheduledDepartureTime() + this.stop.getDepartureTimeDeviation() / (long)precision * (long)precision), (ITimeSystem)VanillaTimeSystem.INSTANCE).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME)), (DLColor)(this.stop.isDepartureDelayed() ? Constants.COLOR_DELAYED : Constants.COLOR_ON_TIME), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
            }
        } else {
            graphics.poseStack().m_252880_(37.333332f, (float)(y + 6) / 0.75f, 0.0f);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)0, (int)0, (FormattedText)TextUtils.text((String)DLTime.fromTicks((double)(this.type == TrainStopType.START ? this.stop.getScheduledDepartureTime() : this.stop.getScheduledArrivalTime()), (ITimeSystem)VanillaTimeSystem.INSTANCE).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME)).m_130940_(this.valid ? ChatFormatting.RESET : ChatFormatting.STRIKETHROUGH), (DLColor)(this.valid ? DLColor.WHITE : Constants.COLOR_DELAYED), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
            if (this.stop.shouldRenderRealTime() && !this.part.isCancelled() && this.valid) {
                long realTime = this.type == TrainStopType.START ? this.stop.getScheduledDepartureTime() + this.stop.getDepartureTimeDeviation() / (long)precision * (long)precision : this.stop.getScheduledArrivalTime() + this.stop.getArrivalTimeDeviation() / (long)precision * (long)precision;
                GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)30, (int)0, (FormattedText)TextUtils.text((String)DLTime.fromTicks((double)realTime, (ITimeSystem)VanillaTimeSystem.INSTANCE).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME)), (DLColor)((this.type == TrainStopType.START ? this.stop.isDepartureDelayed() : this.stop.isArrivalDelayed()) ? Constants.COLOR_DELAYED : Constants.COLOR_ON_TIME), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
            }
        }
        graphics.poseStack().m_85849_();
    }

    public static enum TrainStopType {
        START(48, 24, 4),
        TRANSIT(72, 21, 1),
        END(122, 33, 11);

        private int v;
        private int h;
        private int dy;

        private TrainStopType(int v, int h, int dy) {
            this.v = v;
            this.h = h;
            this.dy = dy;
        }
    }
}

