/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.windows;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.AdvancedDisplaySettingsData;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.properties.EDisplayType;
import de.mrjulsen.crn.block.properties.ESide;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.flyout.FlyoutConfirmDialog;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.FlatIconButton;
import de.mrjulsen.crn.client.gui.widgets.IconSlotWidget;
import de.mrjulsen.crn.client.gui.widgets.ModularWidgetContainer;
import de.mrjulsen.crn.client.gui.widgets.create.CreateButton;
import de.mrjulsen.crn.client.gui.widgets.create.CreateItemPicker;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import de.mrjulsen.crn.client.gui.widgets.skins.CRNFlatButtonRenderer;
import de.mrjulsen.crn.client.gui.windows.GlobalSettingsWindow;
import de.mrjulsen.crn.network.packets.cts.AdvancedDisplayUpdatePacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLCheckBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLToggleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.FlowLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLTexture;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.Cache;
import de.mrjulsen.mcdragonlib.util.Clipboard;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedDisplaySettingsWindow
extends DLWindow {
    private static boolean advancedSettingsExpanded = false;
    private static final MutableComponent title = TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.title");
    private static final int GUI_WIDTH = 212;
    private static final CreateDynamicWidgets.FooterSize headerSize = CreateDynamicWidgets.FooterSize.DEFAULT;
    private static final CreateDynamicWidgets.FooterSize footerSize = CreateDynamicWidgets.FooterSize.SMALL;
    private static final int BASIC_GUI_HEIGHT = headerSize.size() + footerSize.size() + 76 + 5 + 18;
    private final ItemStack renderedItem;
    private final AbstractContraptionEntity contraption;
    private final Level level;
    private final BlockPos pos;
    private final boolean canBeDoubleSided;
    private AdvancedDisplaysRegistry.DisplayTypeResourceKey typeKey;
    private EDisplayType type;
    private IDisplaySettings settings;
    private boolean doubleSided;
    private CreateButton globalSettingsButton;
    private final MutableComponent tooltipGlobalSettings = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.global_settings.tooltip");
    private final MutableComponent tooltipDisplayType = TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.display_type");
    private final MutableComponent tooltipInfoType = TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.info_type");
    private final MutableComponent textDoubleSided = TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.double_sided");
    private Rectangle workingArea;
    private CreateButton backButton;
    private ModularWidgetContainer commonSettingsContainer;
    private DLPanel advancedSettingsPanel;
    private ModularWidgetContainer advancedSettingsContainer;
    private final Cache<List<AdvancedDisplaysRegistry.DisplayTypeResourceKey>> displayTypes = new Cache(() -> AdvancedDisplaysRegistry.getAllOfTypeAsKey(this.type), ECachingPriority.ALWAYS);
    private final AdvancedDisplayBlockEntity blockEntity;

    private final MutableComponent textAdvancedSettings(int maxWidth) {
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent comp = TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.advanced_settings").m_130940_(ChatFormatting.BOLD);
        MutableComponent ellipsisText = TextUtils.text((String)"...").m_130940_(ChatFormatting.BOLD);
        boolean tooWide = font.m_92852_((FormattedText)comp) + font.m_92852_((FormattedText)ellipsisText) > maxWidth;
        return tooWide ? TextUtils.text((String)(font.m_92854_((FormattedText)comp, maxWidth - font.m_92852_((FormattedText)ellipsisText)).getString() + "...")).m_130940_(ChatFormatting.BOLD) : comp;
    }

    public AdvancedDisplaySettingsWindow(DLWindowManager manager, AdvancedDisplayBlockEntity blockEntity, AbstractContraptionEntity contraption) {
        super(manager);
        this.setSize(212.0, BASIC_GUI_HEIGHT);
        this.windowSpawnPosition.set((Object)DLWindow.WindowPosition.CENTER);
        this.blockEntity = blockEntity;
        this.settings = blockEntity.getSettings();
        this.pos = blockEntity.m_58899_();
        boolean isOnContraption = contraption != null;
        this.contraption = contraption;
        this.level = isOnContraption ? contraption.getContraption().getContraptionWorld() : blockEntity.m_58904_();
        this.type = blockEntity.getDisplayType().category();
        this.typeKey = blockEntity.getDisplayType();
        BlockState state = this.level.m_8055_(blockEntity.m_58899_());
        this.renderedItem = new ItemStack((ItemLike)state.m_60734_());
        this.canBeDoubleSided = state.m_60734_() instanceof AbstractAdvancedSidedDisplayBlock;
        this.doubleSided = !this.canBeDoubleSided || state.m_61143_(AbstractAdvancedSidedDisplayBlock.SIDE) == ESide.BOTH;
        this.init();
    }

    public void close() {
        ModNetworkManager.ADVANCED_DISPLAY_UPDATE_PACKET.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new AdvancedDisplayUpdatePacketData(this.level, this.pos, this.contraption, this.typeKey, this.doubleSided, this.settings));
    }

    private void reinit() {
        this.setHeight(headerSize.size() + footerSize.size() + this.commonSettingsContainer.height() + 2 + this.advancedSettingsPanel.height() + 3 + (advancedSettingsExpanded ? this.advancedSettingsContainer.height() : 0));
        this.setPosition(this.getWindowManager().getScreenWidth() / 2.0 - (double)(this.width() / 2), this.getWindowManager().getScreenHeight() / 2.0 - (double)(this.height() / 2));
        this.advancedSettingsContainer.clearLines();
        if (advancedSettingsExpanded) {
            this.settings.buildGui(new GuiBuilderContext(this.advancedSettingsContainer));
        }
    }

    protected void init() {
        this.backButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(187, this.height() - 6 - 18, (ScreenElement)AllIcons.I_CONFIRM));
        this.backButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().closeWindow((DLWindow)this);
            return false;
        });
        CreateButton helpButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(159, this.height() - 6 - 18, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()));
        helpButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Advanced-Displays");
            return false;
        });
        helpButton.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_HELP), 200));
        this.globalSettingsButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(7, this.height() - 6 - 18, (ScreenElement)ModGuiIcons.SETTINGS.getAsCreateIcon()));
        this.globalSettingsButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new GlobalSettingsWindow(mgr));
            return false;
        });
        this.globalSettingsButton.tooltip.set((Object)new DLTooltip(List.of(this.tooltipGlobalSettings), 200));
        this.commonSettingsContainer = (ModularWidgetContainer)this.addComponent(new ModularWidgetContainer(3, headerSize.size() + 1, this.width() - 6, 1));
        Object object = this.commonSettingsContainer.contentPanel.layout.get();
        if (object instanceof FlowLayout) {
            FlowLayout fl = (FlowLayout)object;
            fl.padding.set((Object)new Padding(6, 16, 6, 16));
        }
        this.commonSettingsContainer.addEventListener(ModularWidgetContainer.ContentLayoutUpdatedEvent.class, (s, e) -> {
            this.commonSettingsContainer.setHeight(e.layoutResult().contentHeight());
            return false;
        });
        DLPanel displayTypeLine = this.commonSettingsContainer.addLine("displayType");
        IconSlotWidget displayTypeIcon = (IconSlotWidget)displayTypeLine.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        displayTypeIcon.icon.set((Object)this.type.getIcon().getAsSprite(16, 16));
        CreateItemPicker displayTypePicker = (CreateItemPicker)displayTypeLine.addComponent(new CreateItemPicker(0, 0, 100));
        displayTypePicker.formatter.set(item -> item == null ? TextUtils.empty() : item.getValueTranslation());
        displayTypePicker.renderArrow.set((Object)true);
        displayTypePicker.hint.set((Object)EDisplayType.DEPARTURE_BOARD.getEnumDescriptionTranslation());
        displayTypePicker.title.set((Object)this.tooltipDisplayType);
        displayTypePicker.items.addAll((Object[])EDisplayType.values());
        displayTypePicker.selectedItem.set(Optional.ofNullable(this.type));
        displayTypePicker.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        DLPanel displayVariantLine = this.commonSettingsContainer.addLine("displayVariant");
        IconSlotWidget displayVariantIcon = (IconSlotWidget)displayVariantLine.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        displayVariantIcon.icon.set((Object)ModGuiIcons.VERY_DETAILED.getAsSprite(16, 16));
        CreateItemPicker displayVariantPicker = (CreateItemPicker)displayVariantLine.addComponent(new CreateItemPicker(0, 0, 100));
        displayVariantPicker.formatter.set(item -> item == null ? TextUtils.empty() : TextUtils.translate((String)item.getTranslationKey()));
        displayVariantPicker.renderArrow.set((Object)true);
        displayVariantPicker.hint.set((Object)EDisplayType.DEPARTURE_BOARD.getEnumDescriptionTranslation());
        displayVariantPicker.title.set((Object)this.tooltipDisplayType);
        displayVariantPicker.items.addAll((Collection)this.displayTypes.get());
        displayVariantPicker.selectedItem.set(Optional.ofNullable(this.typeKey));
        displayVariantPicker.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        displayTypePicker.addEventListener(DLCycleButton.SelectedItemChanged.class, (s, e) -> {
            ((Optional)displayTypePicker.selectedItem.get()).ifPresent(item -> {
                this.type = item;
            });
            displayTypeIcon.icon.set((Object)this.type.getIcon().getAsSprite(16, 16));
            this.displayTypes.clear();
            displayVariantPicker.items.set((List)this.displayTypes.get());
            displayVariantPicker.selectedItem.set(Optional.ofNullable(this.typeKey));
            return false;
        });
        displayVariantPicker.addEventListener(DLCycleButton.SelectedItemChanged.class, (s, e) -> {
            if (e.index() < 0) {
                return false;
            }
            this.typeKey = (AdvancedDisplaysRegistry.DisplayTypeResourceKey)((List)this.displayTypes.get()).get(e.index());
            IDisplaySettings oldSettings = this.settings;
            this.settings = this.blockEntity.getDisplayType().equals(this.typeKey) ? this.blockEntity.getSettings() : AdvancedDisplaysRegistry.createSettings(this.typeKey);
            this.settings.onChangeSettings(oldSettings);
            this.reinit();
            return false;
        });
        DLPanel doubleSidedLine = this.commonSettingsContainer.addLine("doubleSided");
        IconSlotWidget doubleSidedIcon = (IconSlotWidget)doubleSidedLine.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        doubleSidedIcon.icon.set((Object)ModGuiIcons.DOUBLE_SIDED.getAsSprite(16, 16));
        DLCheckBox doubleSidedBox = (DLCheckBox)doubleSidedLine.addComponent((DLGuiComponent)new DLCheckBox(0, 0, 100, 18));
        doubleSidedBox.enabled.set((Object)this.canBeDoubleSided);
        doubleSidedBox.checked.set((Object)this.doubleSided);
        doubleSidedBox.text.set((Object)this.textDoubleSided);
        doubleSidedBox.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        doubleSidedBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
            this.doubleSided = e.checked();
            return false;
        });
        this.advancedSettingsPanel = (DLPanel)this.addComponent((DLGuiComponent)new DLPanel(this.commonSettingsContainer.x(), this.commonSettingsContainer.y() + this.commonSettingsContainer.height() + 3, this.commonSettingsContainer.width(), 18));
        FlowLayout advancedSettingsPanelLayout = new FlowLayout();
        advancedSettingsPanelLayout.flowDirection.set((Object)FlowLayout.Direction.HORIZONTAL);
        this.advancedSettingsPanel.layout.set((Object)advancedSettingsPanelLayout);
        FlatIconButton copyBtn = (FlatIconButton)this.advancedSettingsPanel.addComponent((DLGuiComponent)new FlatIconButton(0, 0, ModGuiIcons.COPY.getAsSprite(16, 16)));
        copyBtn.layoutContraint.set((Object)FlowLayout.FlowConstraint.END);
        copyBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Clipboard.put(AdvancedDisplaySettingsData.class, (INBTSerializable)new AdvancedDisplaySettingsData(this.typeKey, this.settings, this.doubleSided));
            return false;
        });
        copyBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_COPY), 200));
        FlatIconButton pasteBtn = (FlatIconButton)this.advancedSettingsPanel.addComponent((DLGuiComponent)new FlatIconButton(0, 0, ModGuiIcons.PASTE.getAsSprite(16, 16)));
        pasteBtn.layoutContraint.set((Object)FlowLayout.FlowConstraint.END);
        pasteBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Clipboard.get(AdvancedDisplaySettingsData.class).ifPresent(x -> {
                this.typeKey = x.getKey();
                this.type = x.getKey().category();
                this.settings = x.getSettings();
                this.doubleSided = x.isDoubleSided();
                this.reinit();
            });
            return false;
        });
        pasteBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_PASTE), 200));
        FlatIconButton resetBtn = (FlatIconButton)this.advancedSettingsPanel.addComponent((DLGuiComponent)new FlatIconButton(0, 0, ModGuiIcons.REFRESH.getAsSprite(16, 16)));
        resetBtn.layoutContraint.set((Object)FlowLayout.FlowConstraint.END);
        resetBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new FlyoutConfirmDialog(mgr, (DLGuiComponent)resetBtn, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, () -> {
                this.settings = AdvancedDisplaysRegistry.createSettings(this.typeKey);
                this.reinit();
            }));
            return false;
        });
        resetBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_RESET), 200));
        DLButton expandBtn = (DLButton)this.advancedSettingsPanel.addComponent((DLGuiComponent)new DLButton(0, 0, 0, 18));
        expandBtn.icon.set((Object)(advancedSettingsExpanded ? GuiIcons.ARROW_DOWN : GuiIcons.ARROW_RIGHT).getAsSprite(16, 16));
        expandBtn.text.set((Object)this.textAdvancedSettings(200));
        expandBtn.layoutContraint.set((Object)FlowLayout.FlowConstraint.FILL);
        expandBtn.textAlignment.set((Object)ETextAlignment.LEFT);
        expandBtn.iconAlignment.set((Object)ETextAlignment.LEFT);
        expandBtn.componentRenderer.set((Object)CRNFlatButtonRenderer.INSTANCE);
        expandBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            advancedSettingsExpanded = !advancedSettingsExpanded;
            this.reinit();
            return false;
        });
        this.advancedSettingsContainer = (ModularWidgetContainer)this.addComponent(new ModularWidgetContainer(this.advancedSettingsPanel.x(), this.advancedSettingsPanel.y() + this.advancedSettingsPanel.height(), this.advancedSettingsPanel.width(), 100));
        Object object2 = this.advancedSettingsContainer.contentPanel.layout.get();
        if (object2 instanceof FlowLayout) {
            FlowLayout fl = (FlowLayout)object2;
            fl.padding.set((Object)new Padding(2, 16, 6, 16));
        }
        this.reinit();
        this.addEventListener(DLGuiStandardEvents.ComponentPosAndSizeChanged.class, (s, e) -> {
            this.backButton.setPosition(187.0, this.height() - 6 - 18);
            helpButton.setPosition(159.0, this.height() - 6 - 18);
            this.globalSettingsButton.setPosition(7.0, this.height() - 6 - 18);
            return false;
        });
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        CreateDynamicWidgets.renderWindow(graphics, 0, 0, 212, this.height(), CreateDynamicWidgets.ContainerColor.PURPLE, CreateDynamicWidgets.BarColor.GOLD, CreateDynamicWidgets.BarColor.GRAY, headerSize.size(), footerSize.size(), false);
        CreateDynamicWidgets.renderVerticalSeparator(graphics, 181, this.height() - footerSize.size() + 2, footerSize.size() - 4, CreateDynamicWidgets.BarColor.GRAY);
        GuiUtils.drawTexture((DLTexture)CRNGui.GUI, (DLGuiGraphics)graphics, (int)209, (int)(this.height() - footerSize.size() / 2 - 9), (int)11, (int)18, (int)0, (int)12, (int)11, (int)18, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH);
        CreateDynamicWidgets.renderContainer(graphics, this.commonSettingsContainer.x() - 2, this.commonSettingsContainer.y() - 2, this.commonSettingsContainer.width() + 4, this.commonSettingsContainer.height() + 4, CreateDynamicWidgets.ContainerColor.PURPLE);
        CreateDynamicWidgets.renderContainer(graphics, this.advancedSettingsPanel.x() - 2, this.advancedSettingsPanel.y() - 2, this.advancedSettingsPanel.width() + 4, this.advancedSettingsPanel.height() + 4 + (advancedSettingsExpanded ? this.advancedSettingsContainer.height() : 0), CreateDynamicWidgets.ContainerColor.GRAY);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)6, (int)4, (FormattedText)title, (DLColor)DragonLib.VANILLA_UI_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)this.renderedItem).at(223.0f, (float)(this.height() - 48), -200.0f)).scale(4.0).render(graphics.graphics());
    }
}

