/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.windows;

import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.flyout.FlyoutDepartureInWidget;
import de.mrjulsen.crn.client.gui.flyout.FlyoutTrainCategoriesWidget;
import de.mrjulsen.crn.client.gui.flyout.FlyoutTransferTimeWidget;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.RouteViewer;
import de.mrjulsen.crn.client.gui.widgets.SearchOptionButton;
import de.mrjulsen.crn.client.gui.widgets.autocomplete.StationTagsAutocomplete;
import de.mrjulsen.crn.client.gui.widgets.create.CreateButton;
import de.mrjulsen.crn.client.gui.widgets.create.CreateTextBox;
import de.mrjulsen.crn.client.gui.windows.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.windows.GlobalSettingsWindow;
import de.mrjulsen.crn.client.gui.windows.SavedRoutesWindow;
import de.mrjulsen.crn.client.gui.windows.ScheduleBoardWindow;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.network.packets.pain.GetNearestStationPacketData;
import de.mrjulsen.crn.network.packets.pain.GetUserSettingsPacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class NavigatorWindow
extends AbstractNavigatorScreen {
    private UserSettings userSettings;
    private RouteViewer routeViewer;

    public NavigatorWindow(DLWindowManager manager) {
        super(manager, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.title"), CreateDynamicWidgets.ContainerColor.GRAY, CreateDynamicWidgets.BarColor.GRAY);
        this.userSettings = new UserSettings(Minecraft.m_91087_().f_91074_.m_20148_(), false);
        manager.setPauseScreen(false);
        CreateTextBox fromBox = (CreateTextBox)this.addComponent((DLGuiComponent)new CreateTextBox(40, 20, 150));
        fromBox.autocompleteManager.set((Object)new StationTagsAutocomplete());
        CreateTextBox toBox = (CreateTextBox)this.addComponent((DLGuiComponent)new CreateTextBox(40, fromBox.y() + fromBox.height() + 4, 150));
        toBox.autocompleteManager.set((Object)new StationTagsAutocomplete());
        this.routeViewer = (RouteViewer)this.addComponent(new RouteViewer(3, 88, this.width() - 6, 128));
        this.routeViewer.displayRecentSearchQueries.set((Object)true);
        CreateButton positionBtn = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(fromBox.x() + fromBox.width() + 4, fromBox.y(), (ScreenElement)ModGuiIcons.POSITION.getAsCreateIcon()));
        positionBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            ModNetworkManager.GET_NEAREST_STATION.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new GetNearestStationPacketData.Request(Minecraft.m_91087_().f_91074_.m_20183_()), response -> ((RichTextComponent)fromBox.text.get()).set(response.getResult().tagName.get().get()), () -> {});
            return false;
        });
        CreateButton searchBtn = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(toBox.x() + toBox.width() + 4, toBox.y(), (ScreenElement)AllIcons.I_MTD_SCAN));
        searchBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            searchBtn.enabled.set((Object)false);
            this.routeViewer.search(((RichTextComponent)fromBox.text.get()).getPlainText(), ((RichTextComponent)toBox.text.get()).getPlainText(), () -> searchBtn.enabled.set((Object)true));
            return false;
        });
        CreateButton globalSettingsButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(30, 223, (ScreenElement)ModGuiIcons.SETTINGS.getAsCreateIcon()));
        globalSettingsButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new GlobalSettingsWindow(mgr));
            return false;
        });
        CreateButton departureBoardBtn = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(this.width() - 18 - 8, 223, (ScreenElement)ModGuiIcons.VERY_DETAILED.getAsCreateIcon()));
        departureBoardBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new ScheduleBoardWindow(mgr, null));
            return false;
        });
        CreateButton savedRoutesBtn = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(this.width() - 18 - 37, 223, (ScreenElement)ModGuiIcons.MAP_PATH.getAsCreateIcon()));
        savedRoutesBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new SavedRoutesWindow(mgr));
            return false;
        });
        int btnCount = 3;
        int btnWidth = 72;
        this.addComponent((DLGuiComponent)new SearchOptionButton(3, 54 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, btnWidth, 18, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.departure_in"), () -> this.userSettings.navigationDepartureInTicks.toString(), b -> this.getWindowManager().createModal(mgr -> new FlyoutDepartureInWidget(mgr, (DLGuiComponent)b, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, this.userSettings, () -> this.userSettings.navigationDepartureInTicks))));
        this.addComponent((DLGuiComponent)new SearchOptionButton(3 + btnWidth, 54 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, btnWidth, 18, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.transfer_time"), () -> this.userSettings.navigationTransferTime.toString(), b -> this.getWindowManager().createModal(mgr -> new FlyoutTransferTimeWidget(mgr, (DLGuiComponent)b, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, this.userSettings, () -> this.userSettings.navigationTransferTime))));
        this.addComponent((DLGuiComponent)new SearchOptionButton(3 + btnWidth * 2, 54 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, btnWidth, 18, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_categories"), () -> this.userSettings.navigationExcludedTrainCategories.toString(), b -> this.getWindowManager().createModal(mgr -> new FlyoutTrainCategoriesWidget(mgr, (DLGuiComponent)b, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, this.userSettings, () -> this.userSettings.navigationExcludedTrainCategories))));
        this.reloadUserSettings();
    }

    private void reloadUserSettings() {
        ModNetworkManager.GET_USER_SETTINGS.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new GetUserSettingsPacketData.Request(Minecraft.m_91087_().f_91074_.m_20148_()), response -> response.getData().ifPresent(a -> {
            this.userSettings = a;
            this.routeViewer.updateSettings((UserSettings)a);
        }), () -> {});
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        super.renderMainLayer(graphics, mouseX, mouseY, renderBounds);
        int y = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        CreateDynamicWidgets.renderContainer(graphics, 1, y, 238, 52, CreateDynamicWidgets.ContainerColor.BLUE);
        CreateDynamicWidgets.renderContainer(graphics, 1, y + 52 - 1, 238, 22, CreateDynamicWidgets.ContainerColor.GOLD);
        CreateDynamicWidgets.renderContainer(graphics, 1, y += 72, 238, 247 - y - CreateDynamicWidgets.FooterSize.SMALL.size() + 1, CreateDynamicWidgets.ContainerColor.GRAY);
        CreateDynamicWidgets.renderVerticalSeparator(graphics, 208, 218, 27, CreateDynamicWidgets.BarColor.GRAY);
        CRNGui.GUI_SPRITES.getSprite("route_start").render(graphics, 16, 16, 7, 24);
        CRNGui.GUI_SPRITES.getSprite("route_end").render(graphics, 16, 40, 7, 24);
    }
}

