/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.windows;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.Indicator;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.FlatIconButton;
import de.mrjulsen.crn.client.gui.widgets.autocomplete.StationsAutocomplete;
import de.mrjulsen.crn.client.gui.widgets.create.CreateButton;
import de.mrjulsen.crn.client.gui.widgets.create.CreateIndicator;
import de.mrjulsen.crn.client.gui.widgets.create.CreateTextBox;
import de.mrjulsen.crn.client.gui.widgets.skins.ModernScrollbarComponentRenderer;
import de.mrjulsen.crn.data.schedule.instruction.PrioritizedDestinationInstruction;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLRichTextLabel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.CursorType;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.render.DefaultGuiTextures;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLTexture;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PrioritizedDestinationInstructionSettingsWindow
extends DLWindow {
    private static final MutableComponent TITLE = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings");
    private static final ItemStack DISPLAY_ITEM = new ItemStack((ItemLike)AllItems.SCHEDULE.get());
    private static final int GUI_WIDTH = 250;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private static final CreateDynamicWidgets.FooterSize headerSize = CreateDynamicWidgets.FooterSize.DEFAULT;
    private static final CreateDynamicWidgets.FooterSize footerSize = CreateDynamicWidgets.FooterSize.EXTENDED;
    private static final int GUI_HEIGHT = 200;
    private Rectangle workingArea;
    private DLScrollBar scrollBar;
    private ListBox list;
    private CreateButton backButton;
    private CreateButton addBtn;
    private CreateTextBox addTextBox;
    private CreateButton avoidSignalsButton;
    private CreateIndicator avoidSignalsIndicator;
    private CreateButton avoidTrainsButton;
    private CreateIndicator avoidTrainsIndicator;
    private final PrioritizedDestinationInstruction instruction;
    private final CompoundTag nbt;
    private final List<String> stationFilters = new ArrayList<String>();
    private boolean shouldAvoidSignals;
    private boolean shouldAvoidTrains;
    private final List<String> stationNames = new ArrayList<String>();
    private final MutableComponent txtAvoidSignalsTitle = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.avoid_signals");
    private final MutableComponent txtAvoidSignalsDescription = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.avoid_signals_description").m_130940_(ChatFormatting.GRAY);
    private final MutableComponent txtAvoidTrainsTitle = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.avoid_trains");
    private final MutableComponent txtAvoidTrainsDescription = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.avoid_trains_description").m_130940_(ChatFormatting.GRAY);

    public PrioritizedDestinationInstructionSettingsWindow(DLWindowManager manager, PrioritizedDestinationInstruction instruction, CompoundTag nbt) {
        super(manager);
        this.setSize(250.0, 200.0);
        this.windowSpawnPosition.set((Object)DLWindow.WindowPosition.CENTER);
        this.instruction = instruction;
        this.nbt = nbt;
        this.stationFilters.addAll(nbt.m_128437_("Filters", 8).stream().map(x -> x.m_7916_()).toList());
        this.shouldAvoidSignals = nbt.m_128441_("AvoidRedSignal") ? nbt.m_128471_("AvoidRedSignal") : true;
        this.shouldAvoidTrains = nbt.m_128441_("AvoidTrains") ? nbt.m_128471_("AvoidTrains") : true;
        this.init();
    }

    protected void init() {
        ModNetworkManager.GET_ALL_STATION_NAMES.send((NetworkDirection)NetworkDirection.toServer(), response -> {
            this.stationNames.clear();
            this.stationNames.addAll(response.getStations());
        }, () -> {});
        this.workingArea = Rectangle.withSize((double)3.0, (double)(headerSize.size() + 1), (double)244.0, (double)(200 - headerSize.size() - footerSize.size() - 2));
        this.scrollBar = new DLScrollBar((int)this.workingArea.right() - 5, (int)this.workingArea.y(), 5, (int)this.workingArea.height(), DLScrollBar.Orientation.VERTICAL);
        this.scrollBar.componentRenderer.set((Object)ModernScrollbarComponentRenderer.INSTANCE);
        this.addComponent((DLGuiComponent)this.scrollBar);
        this.addTextBox = (CreateTextBox)this.addComponent((DLGuiComponent)new CreateTextBox((int)this.workingArea.x() + 63, (int)this.workingArea.y() + 9, 118));
        this.addTextBox.autocompleteManager.set((Object)new StationsAutocomplete());
        this.addTextBox.addEventListener(DLRichTextLabel.TextChangedEvent.class, (s, e) -> {
            this.addBtn.enabled.set((Object)(this.canAddMore() && e.text().getPlainText() != null && !e.text().getPlainText().isBlank() ? 1 : 0));
            return false;
        });
        this.addTextBox.tooltip.set((Object)new DLTooltip(this.instruction.getSecondLineTooltip(0).stream().map(x -> x).toList(), 200));
        this.addBtn = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton((int)this.workingArea.x() + 185, (int)this.workingArea.y() + 9, (ScreenElement)ModGuiIcons.ADD.getAsCreateIcon()));
        this.addBtn.enabled.set((Object)false);
        this.addBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            if (!this.canAddMore()) {
                return false;
            }
            this.stationFilters.add(((RichTextComponent)this.addTextBox.text.get()).getPlainText());
            ((RichTextComponent)this.addTextBox.text.get()).set("");
            this.reloadList();
            return false;
        });
        this.addBtn.tooltip.set((Object)new DLTooltip(List.of(), 200));
        this.list = (ListBox)this.addComponent(new ListBox(this, this.scrollBar, (int)this.workingArea.x() + 33, (int)this.workingArea.y() + 40, 178, (int)this.workingArea.height() - 40));
        this.scrollBar.anchor.set2((Enum[])new EAlign[]{EAlign.TOP, EAlign.BOTTOM, EAlign.RIGHT});
        this.scrollBar.scrollerSize.set((Number)0);
        this.scrollBar.screenSize.set((Number)this.list.height());
        this.scrollBar.scrollSteps.set((Number)15);
        this.scrollBar.max.set((Number)0);
        this.scrollBar.inputConsumptionPolicy.set(type -> true);
        this.scrollBar.addEventListener(DLScrollBar.ValueChangedEvent.class, (s, e) -> {
            this.list.setScrollOffsetY(e.value());
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (arg_0, arg_1) -> ((DLScrollBar)this.scrollBar).invokeEvent(arg_0, arg_1));
        this.avoidSignalsButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(7, 176, (ScreenElement)GuiGameElement.of((ItemStack)AllBlocks.TRACK_SIGNAL.asStack())));
        this.avoidSignalsIndicator = (CreateIndicator)this.addComponent(new CreateIndicator(this.avoidSignalsButton.x(), this.avoidSignalsButton.y() - 6));
        this.avoidSignalsIndicator.state.set((Object)(this.shouldAvoidSignals ? Indicator.State.ON : Indicator.State.OFF));
        this.avoidSignalsButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.shouldAvoidSignals = !this.shouldAvoidSignals;
            this.avoidSignalsIndicator.state.set((Object)(this.shouldAvoidSignals ? Indicator.State.ON : Indicator.State.OFF));
            return false;
        });
        this.avoidSignalsButton.tooltip.set((Object)new DLTooltip(List.of(this.txtAvoidSignalsTitle, this.txtAvoidSignalsDescription), 200));
        this.avoidTrainsButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(25, 176, (ScreenElement)GuiGameElement.of((ItemStack)AllBlocks.TRAIN_CONTROLS.asStack())));
        this.avoidTrainsIndicator = (CreateIndicator)this.addComponent(new CreateIndicator(this.avoidTrainsButton.x(), this.avoidTrainsButton.y() - 6));
        this.avoidTrainsIndicator.state.set((Object)(this.shouldAvoidTrains ? Indicator.State.ON : Indicator.State.OFF));
        this.avoidTrainsButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.shouldAvoidTrains = !this.shouldAvoidTrains;
            this.avoidTrainsIndicator.state.set((Object)(this.shouldAvoidTrains ? Indicator.State.ON : Indicator.State.OFF));
            return false;
        });
        this.avoidTrainsButton.tooltip.set((Object)new DLTooltip(List.of(this.txtAvoidTrainsTitle, this.txtAvoidTrainsDescription), 200));
        this.backButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(225, 176, (ScreenElement)AllIcons.I_CONFIRM));
        this.backButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().closeWindow((DLWindow)this);
            return false;
        });
        CreateButton helpButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(197, 176, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()));
        helpButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Prioritized-Destination-Instruction");
            return false;
        });
        helpButton.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_HELP), 200));
        this.reloadList();
    }

    public void close() {
        ListTag list = new ListTag();
        Iterator i = this.stationFilters.stream().limit(20L).iterator();
        while (i.hasNext()) {
            list.add((Object)StringTag.m_129297_((String)((String)i.next())));
        }
        this.nbt.m_128365_("Filters", (Tag)list);
        this.nbt.m_128379_("AvoidRedSignal", this.shouldAvoidSignals);
        this.nbt.m_128379_("AvoidTrains", this.shouldAvoidTrains);
    }

    private void reloadList() {
        this.list.reloadList();
    }

    private boolean canAddMore() {
        return this.stationFilters.size() < 20;
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        CreateDynamicWidgets.renderWindow(graphics, 0, 0, 250, 200, CreateDynamicWidgets.ContainerColor.PURPLE, CreateDynamicWidgets.BarColor.GOLD, CreateDynamicWidgets.BarColor.GRAY, headerSize.size(), footerSize.size(), true);
        CreateDynamicWidgets.renderVerticalSeparator(graphics, 219, 200 - footerSize.size() + 2, footerSize.size() - 4, CreateDynamicWidgets.BarColor.GRAY);
        CreateDynamicWidgets.renderWidgetInner(graphics, (int)this.workingArea.x() + 31, (int)this.workingArea.y(), 182, (int)this.workingArea.height(), CreateDynamicWidgets.ColorShade.DARK);
        DefaultGuiTextures.DRAGONLIB_UI.getSprite("slot").render(graphics, (int)this.workingArea.x() + 41, (int)this.workingArea.y() + 9, 18, 18);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)((int)this.workingArea.x() + 63), (int)((int)this.workingArea.y() + 28), (String)String.format("%s / %s", this.stationFilters.size(), (byte)20), (DLColor)DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)6, (int)4, (FormattedText)TITLE, (DLColor)DragonLib.VANILLA_UI_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        GuiGameElement.of((ItemStack)AllBlocks.TRACK_STATION.asStack()).at((float)((int)this.workingArea.x() + 42), (float)((int)this.workingArea.y() + 10)).render(graphics.graphics());
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        GuiUtils.drawTexture((DLTexture)CRNGui.GUI, (DLGuiGraphics)graphics, (int)247, (int)176, (int)11, (int)18, (int)0, (int)12);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)DISPLAY_ITEM).at(261.0f, 152.0f, -200.0f)).scale(4.0).render(graphics.graphics());
    }

    private static class ListBox
    extends DLGuiComponent {
        private int index = -1;
        private Entry draggedEntry;
        private final DLScrollBar scrollBar;
        private final PrioritizedDestinationInstructionSettingsWindow win;

        public ListBox(PrioritizedDestinationInstructionSettingsWindow win, DLScrollBar scrollBar, int x, int y, int w, int h) {
            super(x, y, w, h);
            this.win = win;
            this.scrollBar = scrollBar;
            this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (arg_0, arg_1) -> ((DLScrollBar)scrollBar).invokeEvent(arg_0, arg_1));
            this.addEventListener(DLGuiStandardEvents.DragComponentOverEvent.class, (s, e) -> {
                Object patt0$temp;
                if (e.button() == 0 && !e.other().isEmpty() && (patt0$temp = e.other().get(0)) instanceof Entry) {
                    Entry entry;
                    this.draggedEntry = entry = (Entry)((Object)((Object)patt0$temp));
                    int newIndex = (int)((s.getLocalMouseY() + this.getScrollOffsetY()) / 20.0);
                    boolean b = this.index != newIndex;
                    this.index = MathUtils.clamp((int)newIndex, (int)0, (int)(win.stationFilters.size() - 1));
                    if (b) {
                        this.updateLayout(entry);
                    }
                } else {
                    this.draggedEntry = null;
                }
                return false;
            });
        }

        public void tick() {
            if (this.draggedEntry != null && this.getWindowManager().isMouseDragging()) {
                if (this.getLocalMouseY() < 10.0) {
                    this.scrollBar.value.set((Number)((Double)this.scrollBar.value.get() + (double)0.2f * (this.getLocalMouseY() - 10.0)));
                } else if (this.getLocalMouseY() > (double)(this.height() - 10)) {
                    this.scrollBar.value.set((Number)((Double)this.scrollBar.value.get() + (double)0.2f * (this.getLocalMouseY() - (double)this.height() + 10.0)));
                }
            }
        }

        public void applyReorder() {
            this.index = MathUtils.clamp((int)this.index, (int)0, (int)(this.win.stationFilters.size() - 1));
            this.win.stationFilters.remove(this.draggedEntry.stationName);
            this.win.stationFilters.add(this.index, this.draggedEntry.stationName);
            this.index = -1;
            this.win.reloadList();
        }

        public void reloadList() {
            this.clearComponents();
            for (int i = 0; i < this.win.stationFilters.size(); ++i) {
                this.addComponent(new Entry(this, i, 0, 0, this.width(), this.win.stationFilters.get(i), a -> {
                    this.win.stationFilters.remove(a.index);
                    this.reloadList();
                }));
            }
            this.updateLayout(null);
            this.scrollBar.max.set((Number)(this.win.stationFilters.size() * 20));
        }

        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            if (this.index >= 0) {
                GuiUtils.drawBox((DLGuiGraphics)graphics, (int)0, (int)((int)((double)(this.index * 20) - this.getScrollOffsetY())), (int)this.width(), (int)20, (DLColor)DLColor.TRANSPARENT, (DLColor)DLColor.WHITE);
            }
        }

        public void updateLayout(DLGuiComponent draggingComponent) {
            int y = 0;
            int i = 0;
            for (DLGuiComponent component : this.getComponents()) {
                if (component == draggingComponent) continue;
                if (i == this.index) {
                    y += 20;
                }
                component.setPosition(0.0, (double)y);
                component.setWidth((double)this.width());
                y += component.height();
                ++i;
            }
        }
    }

    private static class Entry
    extends DLGuiComponent {
        static final int HEIGHT = 20;
        private final ListBox listBox;
        private final String stationName;
        private final Component txtDragNDrop = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.drag_and_drop");
        private final Component txtPriorities = TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.priorities").m_130940_(ChatFormatting.GRAY);
        private final Function<Integer, Component> txtPriority = i -> TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.prioritized_destination_instruction.settings.priority_pos", (Object[])new Object[]{i}).m_130940_(ChatFormatting.DARK_GRAY);
        private final FlatIconButton deleteBtn;
        private final Rectangle tooltipRectangle = Rectangle.withSize((double)4.0, (double)0.0, (double)20.0, (double)20.0);
        private final int index;
        private double mouseDownX;
        private double mouseDownY;

        public Entry(ListBox listBox, int idx, int x, int y, int w, String stationName, Consumer<Entry> onDelete) {
            super(x, y, w, 20);
            this.listBox = listBox;
            this.stationName = stationName;
            this.index = idx;
            this.cursor.set((Object)CursorType.ALLRESIZE);
            this.deleteBtn = (FlatIconButton)this.addComponent((DLGuiComponent)new FlatIconButton(w - 26, 1, (ScreenElement)ModGuiIcons.DELETE.getAsCreateIcon()));
            this.deleteBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                onDelete.accept(this);
                return false;
            });
            this.addEventListener(DLGuiStandardEvents.MouseDownEvent.class, (s, e) -> {
                this.mouseDownX = e.mouseX();
                this.mouseDownY = e.mouseY();
                return false;
            });
            this.addEventListener(DLGuiStandardEvents.DragEndEvent.class, (s, e) -> {
                listBox.applyReorder();
                return false;
            });
            this.addEventListener(DLGuiStandardEvents.RenderOnScreenEvent.class, (src, e) -> false);
            this.inputConsumptionPolicy.set(c -> c != DLGuiComponent.ConsumptionType.DRAG && c != DLGuiComponent.ConsumptionType.SCROLL);
        }

        public int getIndex() {
            return this.index;
        }

        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            if (this.isDragged()) {
                return;
            }
            CreateDynamicWidgets.renderTextSlotOverlay(graphics, 30, 1, 118, 18);
            CreateDynamicWidgets.renderGrabber(graphics, 8, 2);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)35, (int)6, (String)this.stationName, (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        }

        public void renderFrontLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            if (this.isDragged()) {
                RenderSystem.enableBlend();
                graphics.poseStack().m_85836_();
                graphics.poseStack().m_85837_(mouseX - this.mouseDownX, mouseY - this.mouseDownY - this.listBox.getScrollOffsetY(), 0.0);
                CreateDynamicWidgets.renderShadow(graphics, -2, -2, this.width() + 4, this.height() + 4);
                CreateDynamicWidgets.renderSingleShadeWidget(graphics, -2, -2, this.width() + 4, this.height() + 4, CreateDynamicWidgets.ColorShade.DARK);
                CreateDynamicWidgets.renderTextSlotOverlay(graphics, 30, 1, 118, 18);
                CreateDynamicWidgets.renderGrabber(graphics, 8, 2);
                GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)35, (int)6, (String)this.stationName, (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
                graphics.poseStack().m_85849_();
            }
        }

        public void renderOnScreen(DLGuiGraphics graphics, double mouseX, double mouseY) {
            Point pos;
            if (this.isSelected() && this.tooltipRectangle.collision(mouseX - (pos = this.toScreenCoordinates()).x(), mouseY - pos.y())) {
                GuiUtils.drawTooltip((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)((int)mouseX), (int)((int)mouseY), List.of(this.txtDragNDrop, this.txtPriorities, this.txtPriority.apply(this.getIndex() + 1)), (int)200);
            }
        }
    }
}

