/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.windows;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.overlay.RouteDetailsOverlay;
import de.mrjulsen.crn.client.gui.widgets.create.CreateButton;
import de.mrjulsen.crn.client.gui.widgets.routedetails.RouteDetailsViewer;
import de.mrjulsen.crn.client.gui.windows.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.data.SavedRoutesManager;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.DLOverlayManager;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.VanillaTimeSystem;
import java.util.List;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class RouteDetailsWindow
extends AbstractNavigatorScreen {
    private final MutableComponent textDeparture = CustomLanguage.translate("gui.createrailwaysnavigator.route_details.departure");
    private final MutableComponent textArrival = CustomLanguage.translate("gui.createrailwaysnavigator.route_details.arrival");
    private final MutableComponent timeNowText = CustomLanguage.translate("gui.createrailwaysnavigator.time.now");
    private final MutableComponent tooltipSaveRoute = TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.save_route.tooltip");
    private final MutableComponent tooltipRemoveRoute = TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.remove_route.tooltip");
    private final MutableComponent tooltipShowPopup = TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.show_popup.tooltip");
    private final MutableComponent tooltipShowNotifications = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.notifications");
    private final MutableComponent tooltipShowNotificationsDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.notifications.description").m_130940_(ChatFormatting.GRAY);
    private final ClientRoute route;

    public RouteDetailsWindow(DLWindowManager manager, ClientRoute route) {
        super(manager, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.title"), CreateDynamicWidgets.ContainerColor.GOLD, CreateDynamicWidgets.BarColor.GOLD);
        this.route = route;
        int dy = CreateDynamicWidgets.FooterSize.DEFAULT.size() + 38;
        RouteDetailsViewer view = (RouteDetailsViewer)this.addComponent(new RouteDetailsViewer(3, CreateDynamicWidgets.FooterSize.DEFAULT.size() + 38, this.width() - 6, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1));
        view.anchor.set((Object)EAlign.values());
        view.displayRoute(route);
        CreateButton saveRouteBtn = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(30, 223, (ScreenElement)(SavedRoutesManager.isSaved(route) ? ModGuiIcons.BOOKMARK_FILLED.getAsCreateIcon() : ModGuiIcons.BOOKMARK.getAsCreateIcon())));
        saveRouteBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            saveRouteBtn.tooltip.set((Object)new DLTooltip(List.of(SavedRoutesManager.isSaved(route) ? this.tooltipRemoveRoute : this.tooltipSaveRoute), 200));
            if (SavedRoutesManager.isSaved(route)) {
                SavedRoutesManager.removeRoute(route);
                saveRouteBtn.icon = ModGuiIcons.BOOKMARK.getAsCreateIcon();
            } else {
                SavedRoutesManager.saveRoute(route);
                saveRouteBtn.icon = ModGuiIcons.BOOKMARK_FILLED.getAsCreateIcon();
            }
            SavedRoutesManager.push(true, null);
            boolean isSaved = SavedRoutesManager.isSaved(route);
            route.setShowNotifications(isSaved);
            return false;
        });
        saveRouteBtn.tooltip.set((Object)new DLTooltip(List.of(SavedRoutesManager.isSaved(route) ? this.tooltipRemoveRoute : this.tooltipSaveRoute), 200));
        CreateButton popupBtn = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(50, 223, (ScreenElement)ModGuiIcons.PIN.getAsCreateIcon()));
        popupBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            DLOverlayManager.addOverlay(mgr -> new RouteDetailsOverlay(mgr, ModCommonEvents.getPhysicalLevel(), route, 0, 0));
            return false;
        });
        popupBtn.tooltip.set((Object)new DLTooltip(List.of(this.tooltipShowPopup), 200));
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        super.renderMainLayer(graphics, mouseX, mouseY, renderBounds);
        int y = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        CreateDynamicWidgets.renderContainer(graphics, 1, y, 238, 38, CreateDynamicWidgets.ContainerColor.BLUE);
        CreateDynamicWidgets.renderContainer(graphics, 1, y += 37, 238, 247 - y - CreateDynamicWidgets.FooterSize.SMALL.size() + 1, CreateDynamicWidgets.ContainerColor.GOLD);
        if (!this.route.isAnyCancelled()) {
            if (this.route.getStart().isDeparted()) {
                GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)120, (int)19, (FormattedText)this.textArrival, (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.CENTER, (boolean)false);
            } else {
                GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)120, (int)19, (FormattedText)this.textDeparture, (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.CENTER, (boolean)false);
            }
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85841_(2.0f, 2.0f, 2.0f);
            long time = 0L;
            if (this.route.getStart().isDeparted()) {
                time = this.route.getEnd().getRealTimeArrivalTime() - DragonLib.getCurrentWorldTime();
                GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)60, (int)15, (FormattedText)(time < 0L ? this.timeNowText : TextUtils.text((String)DLTime.fromTicks((double)time, (ITimeSystem)VanillaTimeSystem.INSTANCE).format(Constants.DEFAULT_VERBOSE_GAME_DURATION_FORMAT, TimeContext.INGAME))), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.CENTER, (boolean)false);
            } else {
                time = this.route.getStart().getRealTimeDepartureTime() - DragonLib.getCurrentWorldTime();
                GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)60, (int)15, (FormattedText)(time < 0L ? this.timeNowText : TextUtils.text((String)DLTime.fromTicks((double)time, (ITimeSystem)VanillaTimeSystem.INSTANCE).format(Constants.DEFAULT_VERBOSE_GAME_DURATION_FORMAT, TimeContext.INGAME))), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.CENTER, (boolean)false);
            }
            graphics.poseStack().m_85849_();
        }
    }
}

