/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.windows;

import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.flyout.FlyoutDepartureInWidget;
import de.mrjulsen.crn.client.gui.flyout.FlyoutTrainCategoriesWidget;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.FlatIconButton;
import de.mrjulsen.crn.client.gui.widgets.SearchOptionButton;
import de.mrjulsen.crn.client.gui.widgets.StationDeparturesViewer;
import de.mrjulsen.crn.client.gui.widgets.autocomplete.StationTagsAutocomplete;
import de.mrjulsen.crn.client.gui.widgets.create.CreateButton;
import de.mrjulsen.crn.client.gui.widgets.create.CreateTextBox;
import de.mrjulsen.crn.client.gui.windows.AbstractNavigatorScreen;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.network.packets.pain.GetNearestStationPacketData;
import de.mrjulsen.crn.network.packets.pain.GetUserSettingsPacketData;
import de.mrjulsen.crn.network.packets.pain.StationTagRequestByTagPacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.crn.util.EDepartureBoardTrainFilter;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.TableLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.List;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ScheduleBoardWindow
extends AbstractNavigatorScreen {
    private final StationDeparturesViewer viewer;
    private UserSettings userSettings;
    private CreateTextBox stationBox;
    private String stationTagName;
    private final boolean fixedStation;
    private final MutableComponent tooltipSearch;
    private final MutableComponent tooltipLocation;
    private final MutableComponent tooltipRefresh;

    public ScheduleBoardWindow(DLWindowManager manager, StationTag.ClientStationTag tag) {
        super(manager, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.schedule_board.title"), CreateDynamicWidgets.ContainerColor.GOLD, CreateDynamicWidgets.BarColor.GOLD);
        this.userSettings = new UserSettings(Minecraft.m_91087_().f_91074_.m_20148_(), false);
        this.tooltipSearch = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.search.tooltip");
        this.tooltipLocation = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.location.tooltip");
        this.tooltipRefresh = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.refresh.tooltip");
        boolean bl = this.fixedStation = tag != null;
        if (this.fixedStation) {
            this.stationTagName = tag.tagName();
        }
        int wY = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        int wH = 247 - wY - CreateDynamicWidgets.FooterSize.SMALL.size();
        this.viewer = (StationDeparturesViewer)this.addComponent(new StationDeparturesViewer(3, wY + 52, this.width() - 6, wH - 53));
        if (!this.fixedStation) {
            this.stationBox = (CreateTextBox)this.addComponent((DLGuiComponent)new CreateTextBox(32, 20, 154));
            this.stationBox.maxCharacters.set((Number)32);
            this.stationBox.autocompleteManager.set((Object)new StationTagsAutocomplete());
            CreateButton searchButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(190, 20, (ScreenElement)AllIcons.I_MTD_SCAN));
            searchButton.tooltip.set((Object)new DLTooltip(List.of(this.tooltipSearch), 200));
            searchButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                String stationFrom = ((RichTextComponent)this.stationBox.text.get()).getPlainText();
                if (stationFrom == null || stationFrom.isBlank()) {
                    this.viewer.displayDepartures(stationFrom, this.userSettings);
                    return false;
                }
                ModNetworkManager.GET_STATION_TAG_BY_TAG.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new StationTagRequestByTagPacketData.Request(TagName.of(stationFrom)), response -> {
                    this.stationTagName = response.getTag().getTagName().get();
                    this.viewer.displayDepartures(this.stationTagName, this.userSettings);
                }, () -> {});
                return false;
            });
            CreateButton locationBtn = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(212, 20, (ScreenElement)ModGuiIcons.POSITION.getAsCreateIcon()));
            locationBtn.tooltip.set((Object)new DLTooltip(List.of(this.tooltipLocation), 200));
            locationBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                ModNetworkManager.GET_NEAREST_STATION.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new GetNearestStationPacketData.Request(Minecraft.m_91087_().f_91074_.m_20183_()), response -> {
                    if (response.getResult().tagName.isPresent()) {
                        ((RichTextComponent)this.stationBox.text.get()).set(response.getResult().tagName.get().get());
                    }
                }, () -> {});
                return false;
            });
        }
        DLPanel optionsPanel = new DLPanel(3, 30 + CreateDynamicWidgets.FooterSize.DEFAULT.size(), this.width() - 6, 18);
        TableLayout layout = new TableLayout();
        layout.addColumn("departure", 0.3333333134651184, TableLayout.ColumnSizeMode.PERCENTAGE);
        layout.addColumn("categories", 0.3333333134651184, TableLayout.ColumnSizeMode.PERCENTAGE);
        layout.addColumn("filter", 0.3333333134651184, TableLayout.ColumnSizeMode.PERCENTAGE);
        layout.addColumn("refresh", 18.0, TableLayout.ColumnSizeMode.FIXED);
        optionsPanel.layout.set((Object)layout);
        this.addComponent((DLGuiComponent)optionsPanel);
        SearchOptionButton departureInBtn = new SearchOptionButton(0, 0, 100, 18, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.departure_in"), () -> this.userSettings.searchDepartureInTicks.toString(), b -> this.getWindowManager().createModal(mgr -> new FlyoutDepartureInWidget(mgr, (DLGuiComponent)b, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, this.userSettings, () -> this.userSettings.searchDepartureInTicks)));
        departureInBtn.layoutContraint.set((Object)"departure");
        optionsPanel.addComponent((DLGuiComponent)departureInBtn);
        SearchOptionButton trainCategoriesBtn = new SearchOptionButton(0, 0, 100, 18, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_categories"), () -> this.userSettings.searchExcludedTrainCaegories.toString(), b -> this.getWindowManager().createModal(mgr -> new FlyoutTrainCategoriesWidget(mgr, (DLGuiComponent)b, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, this.userSettings, () -> this.userSettings.searchExcludedTrainCaegories)));
        trainCategoriesBtn.layoutContraint.set((Object)"categories");
        optionsPanel.addComponent((DLGuiComponent)trainCategoriesBtn);
        SearchOptionButton trainFilterBtn = new SearchOptionButton(0, 0, 100, 18, (Component)this.userSettings.searchTrainFilter.getValue().getEnumTranslation(), () -> this.userSettings.searchTrainFilter.toString(), b -> {
            this.userSettings.searchTrainFilter.setValue((EDepartureBoardTrainFilter)this.userSettings.searchTrainFilter.getValue().next());
            this.userSettings.clientSave(() -> this.reloadUserSettings(() -> this.viewer.displayDepartures(this.stationTagName, this.userSettings)));
        });
        trainFilterBtn.layoutContraint.set((Object)"filter");
        optionsPanel.addComponent((DLGuiComponent)trainFilterBtn);
        FlatIconButton refreshBtn = new FlatIconButton(0, 0, ModGuiIcons.REFRESH.getAsSprite(16, 16));
        refreshBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.reloadUserSettings(() -> this.viewer.displayDepartures(this.stationTagName, this.userSettings));
            return false;
        });
        refreshBtn.layoutContraint.set((Object)"refresh");
        refreshBtn.tooltip.set((Object)new DLTooltip(List.of(this.tooltipRefresh), 200));
        optionsPanel.addComponent((DLGuiComponent)refreshBtn);
        this.reloadUserSettings(() -> this.viewer.displayDepartures(this.stationTagName, this.userSettings));
    }

    private void reloadUserSettings(Runnable andThen) {
        ModNetworkManager.GET_USER_SETTINGS.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new GetUserSettingsPacketData.Request(Minecraft.m_91087_().f_91074_.m_20148_()), response -> {
            response.getData().ifPresent(s -> {
                this.userSettings = s;
            });
            DLUtils.doIfNotNull((Object)andThen, Runnable::run);
        }, () -> {});
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        super.renderMainLayer(graphics, mouseX, mouseY, renderBounds);
        int dy = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        CreateDynamicWidgets.renderContainer(graphics, 1, dy, this.width() - 2, 30, CreateDynamicWidgets.ContainerColor.BLUE);
        CreateDynamicWidgets.renderContainer(graphics, 1, dy += 29, this.width() - 2, 22, CreateDynamicWidgets.ContainerColor.GOLD);
        CreateDynamicWidgets.renderContainer(graphics, 1, dy += 21, this.width() - 2, this.height() - dy - CreateDynamicWidgets.FooterSize.SMALL.size() + 1, CreateDynamicWidgets.ContainerColor.PURPLE);
        if (this.fixedStation) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85841_(2.0f, 2.0f, 2.0f);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)60, (int)11, (FormattedText)TextUtils.truncateWithEllipsis((Font)graphics.defaultFont(), (Component)TextUtils.text((String)this.stationTagName), (int)100), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.CENTER, (boolean)false);
            graphics.poseStack().m_85849_();
        } else {
            ModGuiIcons.POSITION.render(graphics, 8, CreateDynamicWidgets.FooterSize.DEFAULT.size() + 6);
            CreateDynamicWidgets.renderTextBox(graphics, 32, 20, 154);
        }
    }
}

