/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.windows;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.flyout.FlyoutConfirmDialog;
import de.mrjulsen.crn.client.gui.flyout.FlyoutTrustedPlayersWidget;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.FlatIconButton;
import de.mrjulsen.crn.client.gui.widgets.SearchBox;
import de.mrjulsen.crn.client.gui.widgets.autocomplete.StationsAutocomplete;
import de.mrjulsen.crn.client.gui.widgets.create.CreateButton;
import de.mrjulsen.crn.client.gui.widgets.create.CreateTextBox;
import de.mrjulsen.crn.client.gui.widgets.options.NewEntryComponent;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntry;
import de.mrjulsen.crn.client.gui.widgets.options.OptionsDataView;
import de.mrjulsen.crn.client.gui.widgets.options.OptionsView;
import de.mrjulsen.crn.client.gui.widgets.options.TextOptionLabel;
import de.mrjulsen.crn.client.gui.windows.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.windows.TransferOwnershipWindow;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.storage.GlobalSettingsClient;
import de.mrjulsen.crn.network.packets.pain.AddStationTagEntryPacketData;
import de.mrjulsen.crn.network.packets.pain.CreateStationTagPacketData;
import de.mrjulsen.crn.network.packets.pain.RemoveStationTagEntryPacketData;
import de.mrjulsen.crn.network.packets.pain.StationTagRequestByTagPacketData;
import de.mrjulsen.crn.network.packets.pain.StationTagUpdatePermissionsPacketData;
import de.mrjulsen.crn.network.packets.pain.UpdateStationTagEntryPacketData;
import de.mrjulsen.crn.network.packets.pain.UpdateStationTagNamePacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLAbstractDataView;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLEditableLabel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.TableLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.DLAbstractRichTextInputField;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.events.IEventListener;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class StationTagSettingsWindow
extends AbstractNavigatorScreen {
    private final MutableComponent tooltipDeleteTag = TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.delete_tag");
    private final MutableComponent textStationName = TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.hint.station_name");
    private final MutableComponent textPlatformName = TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.hint.platform");
    private final OptionsView optionsView;
    private final SearchBox searchBox;

    public StationTagSettingsWindow(DLWindowManager manager) {
        super(manager, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.title").m_7220_((Component)(GlobalSettingsClient.modificationsAllowed() ? TextUtils.empty() : TextUtils.text((String)" ").m_7220_(Constants.TEXT_READ_ONLY).m_130940_(ChatFormatting.DARK_RED))), CreateDynamicWidgets.ContainerColor.PURPLE, CreateDynamicWidgets.BarColor.GRAY);
        manager.setPauseScreen(false);
        CreateButton helpButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(this.width() - 18 - 8, this.height() - 18 - 6, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()));
        helpButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Station-Tags");
            return false;
        });
        helpButton.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_HELP), 200));
        this.searchBox = (SearchBox)this.addComponent((DLGuiComponent)new SearchBox(10, CreateDynamicWidgets.FooterSize.DEFAULT.size() + 5, this.width() - 20));
        this.searchBox.acceptAndCancelKeysEnabled.set((Object)true);
        this.searchBox.componentRenderer.set((Object)new SearchBox.SearchBoxRenderer(true));
        this.searchBox.addEventListener(DLAbstractRichTextInputField.TextAcceptKeyPressedEvent.class, (s, e) -> {
            this.reloadTags();
            return false;
        });
        this.searchBox.placeholderText.set((Object)Constants.TEXT_SEARCH);
        this.optionsView = (OptionsView)this.addComponent(new OptionsView(3, CreateDynamicWidgets.FooterSize.DEFAULT.size() + 19, 234, 247 - (CreateDynamicWidgets.FooterSize.DEFAULT.size() + 1) - CreateDynamicWidgets.FooterSize.SMALL.size() - 19));
        this.reloadTags();
    }

    private void reloadTags() {
        this.optionsView.clearEntries();
        ModNetworkManager.GET_ALL_STATION_TAGS.send((NetworkDirection)NetworkDirection.toServer(), response -> {
            this.optionsView.addEntry(new NewEntryComponent(0, 0, 100, txt -> {
                if (txt.isBlank()) {
                    return;
                }
                ModNetworkManager.CREATE_STATION_TAG.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new CreateStationTagPacketData.Request((String)txt, Optional.of(new Owner((Player)Minecraft.m_91087_().f_91074_))), res -> this.reloadTags(), () -> {});
            }));
            for (StationTag tag : response.getTags()) {
                if (!tag.getTagName().get().toLowerCase().contains(((RichTextComponent)this.searchBox.text.get()).getPlainText().toLowerCase())) continue;
                this.createStationTagOption(tag);
            }
        }, () -> {});
    }

    private void reloadTag(StationTag tag, OptionsDataView<Pair<String, StationTag.StationInfo>> dataView) {
        ModNetworkManager.GET_STATION_TAG_BY_TAG.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new StationTagRequestByTagPacketData.Request(tag.getTagName()), response -> dataView.items.setAll(response.getTag().getAllStations().entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareToIgnoreCase((String)b.getKey())).map(x -> new Pair((Object)((String)x.getKey()), (Object)((StationTag.StationInfo)x.getValue()))).toList()), () -> {});
    }

    private void createStationTagOption(StationTag tag) {
        DLEditableLabel tagRenameBox = new DLEditableLabel(2, 2, 50, 16);
        tagRenameBox.text.set((Object)tag.getTagName().get());
        tagRenameBox.editable.set((Object)tag.getOwner().isAllowed());
        tagRenameBox.visible.set((Object)false);
        tagRenameBox.layoutContraint.set((Object)"name");
        OptionEntry trainLinesEntry = this.optionsView.addEntry(new OptionEntry((Component)TextUtils.text((String)tag.getTagName().get()), List.of(TextUtils.text((String)tag.getTagName().get()), TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.summary", (Object[])new Object[]{TextUtils.text((String)String.valueOf(tag.getAllStationNames().size())).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.GRAY), TextUtils.translate((String)"gui.createrailwaysnavigator.common.last_edited", (Object[])new Object[]{tag.getLastEditor().map(x -> x.name().isBlank() ? TextUtils.translate((String)"gui.createrailwaysnavigator.common.unknown").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC) : TextUtils.text((String)x.name()).m_130940_(ChatFormatting.GREEN)).orElse(TextUtils.text((String)"Server").m_130940_(ChatFormatting.GREEN)), TextUtils.text((String)tag.getLastEditedTimeFormatted()).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.GRAY)), (IEventListener<DLGuiComponent, DLGuiStandardEvents.MousePressedEvent>)((IEventListener)(s, e) -> {
            OptionEntry c = (OptionEntry)s;
            c.expanded.toggle();
            if (((Boolean)c.expanded.get()).booleanValue()) {
                this.reloadTag(tag, c.dataView);
            }
            tagRenameBox.visible.set((Object)((Boolean)c.expanded.get()));
            return false;
        })));
        tagRenameBox.addEventListener(DLEditableLabel.TextEditedEvent.class, (s, e) -> {
            if (!tag.getOwner().isAllowed()) {
                return false;
            }
            if (((String)tagRenameBox.text.get()).isBlank()) {
                return false;
            }
            ModNetworkManager.UPDATE_STATION_TAG_NAME.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new UpdateStationTagNamePacketData(tag.getId(), (String)tagRenameBox.text.get()), response -> this.reloadTags(), () -> {});
            return false;
        });
        TableLayout layout = new TableLayout();
        layout.addColumn("gap0", 5.0, TableLayout.ColumnSizeMode.FIXED);
        layout.addColumn("name", 1.0, TableLayout.ColumnSizeMode.PERCENTAGE);
        layout.addColumn("gap1", 5.0, TableLayout.ColumnSizeMode.FIXED);
        layout.addColumn("permissions", 0.0, TableLayout.ColumnSizeMode.AUTO);
        layout.addColumn("delete", 0.0, TableLayout.ColumnSizeMode.AUTO);
        layout.addColumn("dropdown", 20.0, TableLayout.ColumnSizeMode.FIXED);
        trainLinesEntry.getHeader().layout.set((Object)layout);
        trainLinesEntry.dataView.createNewItemBuilder.set(!GlobalSettingsClient.modificationsAllowed() || !tag.getOwner().isAllowed() ? null : view -> {
            OptionsDataView.CreateEntryItem item = new OptionsDataView.CreateEntryItem(view);
            CreateTextBox nameBox = new CreateTextBox(0, 0, 0);
            nameBox.tooltip.set((Object)new DLTooltip(List.of(this.textStationName), 200));
            nameBox.autocompleteManager.set((Object)new StationsAutocomplete());
            CreateTextBox platformBox = new CreateTextBox(0, 0, 0);
            platformBox.tooltip.set((Object)new DLTooltip(List.of(this.textPlatformName), 200));
            FlatIconButton addBtn = new FlatIconButton(0, 0, ModGuiIcons.ADD.getAsSprite(16, 16));
            addBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                if (((RichTextComponent)nameBox.text.get()).getPlainText().isBlank() || ((RichTextComponent)platformBox.text.get()).getPlainText().isBlank()) {
                    return false;
                }
                ModNetworkManager.ADD_STATION_TAG_ENTRY.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new AddStationTagEntryPacketData.Request(tag.getId(), ((RichTextComponent)nameBox.text.get()).getPlainText(), new StationTag.StationInfo(((RichTextComponent)platformBox.text.get()).getPlainText())), response -> this.reloadTag(tag, (OptionsDataView<Pair<String, StationTag.StationInfo>>)((Object)view)), () -> {});
                ((RichTextComponent)nameBox.text.get()).clear();
                return false;
            });
            addBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_ADD), 200));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("name", (DLGuiComponent)nameBox));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("platform", (DLGuiComponent)platformBox));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("action", (DLGuiComponent)addBtn));
            return item;
        });
        trainLinesEntry.dataView.searchFilter.set((item, searchTerm) -> ((String)item.getFirst()).toLowerCase().contains(searchTerm.toLowerCase()));
        trainLinesEntry.dataView.itemBuilder.set(in -> {
            boolean allowed = tag.getOwner().isAllowed() && GlobalSettingsClient.modificationsAllowed();
            OptionsDataView.DLBasicItem<Pair> item = new OptionsDataView.DLBasicItem<Pair>(trainLinesEntry.dataView, (Pair)in);
            TextOptionLabel nameLabel = new TextOptionLabel();
            nameLabel.text.set((Object)((String)in.getFirst()));
            TextOptionLabel platformLbl = new TextOptionLabel();
            platformLbl.addEventListener(DLEditableLabel.TextEditedEvent.class, (s, e) -> {
                if (((String)platformLbl.text.get()).isBlank()) {
                    return false;
                }
                ModNetworkManager.UPDATE_STATION_TAG_ENTRY.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new UpdateStationTagEntryPacketData.Request(tag.getId(), (String)in.getFirst(), new StationTag.StationInfo((String)platformLbl.text.get())), response -> this.reloadTag(tag, trainLinesEntry.dataView), () -> {});
                return false;
            });
            platformLbl.text.set((Object)((StationTag.StationInfo)in.getSecond()).platform());
            platformLbl.editable.set((Object)allowed);
            FlatIconButton deleteBtn = new FlatIconButton(0, 0, ModGuiIcons.DELETE.getAsSprite(16, 16));
            deleteBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                this.getWindowManager().createModal(mgr -> new FlyoutConfirmDialog(mgr, (DLGuiComponent)s, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, () -> ModNetworkManager.REMOVE_STATION_TAG_ENTRY.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new RemoveStationTagEntryPacketData.Request(tag.getId(), (String)in.getFirst()), response -> this.reloadTag(tag, trainLinesEntry.dataView), () -> {})));
                return false;
            });
            deleteBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_DELETE), 200));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("name", (DLGuiComponent)nameLabel));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("platform", (DLGuiComponent)platformLbl));
            if (allowed) {
                item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("action", (DLGuiComponent)deleteBtn));
            }
            return item;
        });
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("name", (Component)TextUtils.text((String)"Name"), 100.0, DLAbstractDataView.SizeMode.PERCENTAGE));
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("platform", (Component)TextUtils.text((String)"Platform"), 50.0, DLAbstractDataView.SizeMode.FIXED));
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("action", (Component)TextUtils.text((String)"Action"), 18.0, DLAbstractDataView.SizeMode.FIXED));
        FlatIconButton btnDelete = new FlatIconButton(0, 0, ModGuiIcons.DELETE.getAsSprite(16, 16));
        btnDelete.tooltip.set((Object)new DLTooltip(List.of(this.tooltipDeleteTag), 200));
        btnDelete.layoutContraint.set((Object)"delete");
        btnDelete.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            if (!tag.getOwner().isAllowed()) {
                return false;
            }
            this.getWindowManager().createModal(mgr -> new FlyoutConfirmDialog(mgr, (DLGuiComponent)s, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, () -> GlobalSettingsClient.deleteStationTag(tag.getId(), () -> this.reloadTags())));
            return false;
        });
        if (tag.getOwner().isAllowed()) {
            trainLinesEntry.getHeader().addComponent((DLGuiComponent)btnDelete);
        }
        FlatIconButton btnPermissions = (FlatIconButton)trainLinesEntry.getHeader().addComponent((DLGuiComponent)new FlatIconButton(0, 0, tag.getOwner().get().getIcon()));
        btnPermissions.layoutContraint.set((Object)"permissions");
        DLContextMenu permissionsMenu = new DLContextMenu((pX, pY) -> {
            ArrayList<DLContextMenu.ItemEntry> entries = new ArrayList<DLContextMenu.ItemEntry>();
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.trusted_players"), DLSprite.empty(), true, () -> this.getWindowManager().createModal(mgr -> new FlyoutTrustedPlayersWidget(mgr, (DLGuiComponent)btnPermissions, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, tag.getOwner().getTrusted(), players -> GlobalSettingsClient.updateStationTagPermissions(new StationTagUpdatePermissionsPacketData.Request(tag.getId(), null, null, (Set<Owner>)players), a -> this.reloadTags()))), null));
            entries.add(DLContextMenu.ItemEntry.SEPARATOR);
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.transfer_ownership"), DLSprite.empty(), true, () -> this.getWindowManager().createModal(mgr -> new TransferOwnershipWindow(mgr, tag.getOwner().getOwner().orElse(null), newOwner -> GlobalSettingsClient.updateStationTagPermissions(new StationTagUpdatePermissionsPacketData.Request(tag.getId(), (Owner)newOwner, null, null), $ -> GlobalSettingsClient.getStationTags(res -> this.reloadTags())))), null));
            return entries;
        });
        btnPermissions.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            if (!tag.getOwner().isAllowed()) {
                return false;
            }
            GlobalSettingsClient.updateStationTagPermissions(new StationTagUpdatePermissionsPacketData.Request(tag.getId(), null, (Lock.LockState)tag.getOwner().get().next(), null), a -> a.ifPresent(x -> {
                tag.getOwner().set(x.getOwner().get());
                tag.getOwner().updateTrusted(x.getOwner().getTrusted());
                btnPermissions.sprite.set((Object)x.getOwner().get().getIcon());
                btnPermissions.tooltip.set((Object)new DLTooltip(tag.getOwner().asText(new Owner((Player)Minecraft.m_91087_().f_91074_)), 200));
            }));
            return false;
        });
        btnPermissions.addEventListener(DLGuiStandardEvents.RightClickEvent.class, (src, event) -> {
            if (!tag.getOwner().isAdmin()) {
                return false;
            }
            permissionsMenu.open(this.getWindowManager(), (int)this.getWindowManager().mouseXOnScreen(), (int)this.getWindowManager().mouseYOnScreen());
            return false;
        });
        btnPermissions.tooltip.set((Object)new DLTooltip(tag.getOwner().asText(new Owner((Player)Minecraft.m_91087_().f_91074_)), 200));
        trainLinesEntry.getHeader().addComponent((DLGuiComponent)tagRenameBox);
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        super.renderMainLayer(graphics, mouseX, mouseY, renderBounds);
    }
}

