/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.windows;

import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.IconSlotWidget;
import de.mrjulsen.crn.client.gui.widgets.ModularWidgetContainer;
import de.mrjulsen.crn.client.gui.widgets.create.CreateButton;
import de.mrjulsen.crn.client.gui.widgets.create.CreateItemPicker;
import de.mrjulsen.crn.client.gui.windows.GlobalSettingsWindow;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.storage.GlobalSettingsClient;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLCheckBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLToggleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TrainSectionSettingsWindow
extends DLWindow {
    private static final ItemStack DISPLAY_ITEM = new ItemStack((ItemLike)AllItems.SCHEDULE.get());
    private static final int GUI_WIDTH = 212;
    private static final CreateDynamicWidgets.FooterSize headerSize = CreateDynamicWidgets.FooterSize.DEFAULT;
    private static final CreateDynamicWidgets.FooterSize footerSize = CreateDynamicWidgets.FooterSize.SMALL;
    private final CompoundTag nbt;
    private boolean includePreviousStation = false;
    private boolean usable = true;
    private UUID trainCategoryId;
    private UUID trainLineId;
    private Map<UUID, TrainCategory> categoriesById;
    private Map<UUID, TrainLine> linesById;
    private ModularWidgetContainer commonSettingsContainer;
    private final MutableComponent title = TextUtils.translate((String)"gui.createrailwaysnavigator.section_settings.title");
    private final MutableComponent tooltipGlobalSettings = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.global_settings.tooltip");
    private final MutableComponent tooltipTrainCatrgory = TextUtils.translate((String)"gui.createrailwaysnavigator.section_settings.train_categories");
    private final MutableComponent tooltipTrainLine = TextUtils.translate((String)"gui.createrailwaysnavigator.section_settings.train_lines");
    private final MutableComponent textIncludePreviousStation = TextUtils.translate((String)"gui.createrailwaysnavigator.section_settings.include_previous_station");
    private final MutableComponent textUsable = TextUtils.translate((String)"gui.createrailwaysnavigator.section_settings.usable");
    private final MutableComponent textNone = TextUtils.translate((String)"gui.createrailwaysnavigator.section_settings.none");

    public TrainSectionSettingsWindow(DLWindowManager manager, CompoundTag nbt) {
        super(manager);
        this.nbt = nbt;
        this.setWidth(212.0);
        this.windowSpawnPosition.set((Object)DLWindow.WindowPosition.PARENT_CENTER);
        this.includePreviousStation = nbt.m_128441_("IncludePreviousStation") ? nbt.m_128471_("IncludePreviousStation") : false;
        boolean bl = this.usable = nbt.m_128441_("Usable") ? nbt.m_128471_("Usable") : true;
        if (nbt.m_128441_("TrainGroup")) {
            this.trainCategoryId = nbt.m_128435_("TrainGroup") == 8 ? TrainCategory.genMD5Uuid(nbt.m_128461_("TrainGroup")) : nbt.m_128342_("TrainGroup");
        } else if (nbt.m_128441_("TrainCategory")) {
            UUID uUID = this.trainCategoryId = nbt.m_128435_("TrainCategory") == 8 ? TrainCategory.genMD5Uuid(nbt.m_128461_("TrainCategory")) : nbt.m_128342_("TrainCategory");
        }
        if (nbt.m_128441_("TrainLine")) {
            this.trainLineId = nbt.m_128435_("TrainLine") == 8 ? TrainLine.genMD5Uuid(nbt.m_128461_("TrainLine")) : nbt.m_128342_("TrainLine");
        }
        CreateButton backButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(this.width() - 7 - 18, this.height() - 6 - 18, (ScreenElement)AllIcons.I_CONFIRM));
        backButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().closeWindow((DLWindow)this);
            return false;
        });
        CreateButton helpButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(this.width() - 17 - 36, this.height() - 6 - 18, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()));
        helpButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Schedule-Sections");
            return false;
        });
        helpButton.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_HELP), 200));
        CreateButton globalSettingsButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(7, 119, (ScreenElement)ModGuiIcons.SETTINGS.getAsCreateIcon()));
        globalSettingsButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new GlobalSettingsWindow(mgr));
            return false;
        });
        globalSettingsButton.tooltip.set((Object)new DLTooltip(List.of(this.tooltipGlobalSettings), 200));
        this.commonSettingsContainer = (ModularWidgetContainer)this.addComponent(new ModularWidgetContainer(3, headerSize.size() + 1, this.width() - 6, 100));
        int minHeight = headerSize.size() + footerSize.size() + 2;
        this.initGui();
        this.setHeight(minHeight);
        this.commonSettingsContainer.addEventListener(ModularWidgetContainer.ContentLayoutUpdatedEvent.class, (s, e) -> {
            this.commonSettingsContainer.setHeight(e.layoutResult().contentHeight());
            this.setHeight(minHeight + e.layoutResult().contentHeight());
            backButton.setPosition(this.width() - 7 - 18, this.height() - 6 - 18);
            backButton.setPosition(this.width() - 7 - 18, this.height() - 6 - 18);
            globalSettingsButton.setPosition(7.0, this.height() - 6 - 18);
            this.setY(this.getWindowManager().getScreenHeight() / 2.0 - (double)(this.height() / 2));
            return false;
        });
    }

    public void close() {
        if (this.trainCategoryId != null) {
            this.nbt.m_128362_("TrainCategory", this.trainCategoryId);
        } else {
            this.nbt.m_128473_("TrainCategory");
        }
        if (this.trainLineId != null) {
            this.nbt.m_128362_("TrainLine", this.trainLineId);
        } else {
            this.nbt.m_128473_("TrainLine");
        }
        this.nbt.m_128379_("IncludePreviousStation", this.includePreviousStation);
        this.nbt.m_128379_("Usable", this.usable);
    }

    protected void initGui() {
        this.commonSettingsContainer.clearLines();
        GlobalSettingsClient.getTrainCategories(trainCategories -> {
            List orderedCategories = trainCategories.stream().sorted((a, b) -> a.getCategoryName().compareToIgnoreCase(b.getCategoryName())).toList();
            this.categoriesById = orderedCategories.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
            GlobalSettingsClient.getTrainLines(trainLines -> {
                List orderedLines = trainLines.stream().sorted((a, b) -> a.getLineName().compareToIgnoreCase(b.getLineName())).toList();
                this.linesById = orderedLines.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
                DLPanel lineTrainCategory = this.commonSettingsContainer.addLine("category");
                IconSlotWidget trainCategoryIcon = (IconSlotWidget)lineTrainCategory.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
                trainCategoryIcon.icon.set((Object)ModGuiIcons.TRAIN.getAsSprite(16, 16));
                CreateItemPicker trainCategoryPicker = (CreateItemPicker)lineTrainCategory.addComponent(new CreateItemPicker(0, 0, 150));
                trainCategoryPicker.title.set((Object)this.tooltipTrainCatrgory);
                trainCategoryPicker.formatter.set(item -> item == null ? this.textNone : TextUtils.text((String)item));
                trainCategoryPicker.items.add((Object)this.textNone.getString());
                trainCategoryPicker.items.addAll(orderedCategories.stream().map(x -> x.getCategoryName()).toList());
                trainCategoryPicker.selectedIndex.set((Number)(this.trainCategoryId != null && this.categoriesById.containsKey(this.trainCategoryId) ? orderedCategories.indexOf(this.categoriesById.get(this.trainCategoryId)) + 1 : 0));
                trainCategoryPicker.addEventListener(DLCycleButton.SelectedItemChanged.class, (s, e) -> {
                    int idx = (Integer)trainCategoryPicker.selectedIndex.get() - 1;
                    this.trainCategoryId = idx >= 0 ? ((TrainCategory)orderedCategories.get(idx)).getId() : null;
                    return false;
                });
                DLPanel lineTrainLine = this.commonSettingsContainer.addLine("line");
                IconSlotWidget trainLineIcon = (IconSlotWidget)lineTrainLine.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
                trainLineIcon.icon.set((Object)ModGuiIcons.MAP_PATH.getAsSprite(16, 16));
                CreateItemPicker trainLinePicker = (CreateItemPicker)lineTrainLine.addComponent(new CreateItemPicker(0, 0, 150));
                trainLinePicker.title.set((Object)this.tooltipTrainLine);
                trainLinePicker.formatter.set(item -> item == null ? this.textNone : TextUtils.text((String)item));
                trainLinePicker.items.add((Object)this.textNone.getString());
                trainLinePicker.items.addAll(orderedLines.stream().map(x -> x.getLineName()).toList());
                trainLinePicker.selectedIndex.set((Number)(this.trainLineId != null && this.linesById.containsKey(this.trainLineId) ? orderedLines.indexOf(this.linesById.get(this.trainLineId)) + 1 : 0));
                trainLinePicker.addEventListener(DLCycleButton.SelectedItemChanged.class, (s, e) -> {
                    int idx = (Integer)trainLinePicker.selectedIndex.get() - 1;
                    this.trainLineId = idx >= 0 ? ((TrainLine)orderedLines.get(idx)).getId() : null;
                    return false;
                });
                DLPanel lineInclude = this.commonSettingsContainer.addLine("include");
                DLCheckBox includePreviousStationBox = (DLCheckBox)lineInclude.addComponent((DLGuiComponent)new DLCheckBox(0, 0, 165, 18));
                includePreviousStationBox.text.set((Object)this.textIncludePreviousStation);
                includePreviousStationBox.checked.set((Object)this.includePreviousStation);
                includePreviousStationBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
                    this.includePreviousStation = e.checked();
                    return false;
                });
                DLPanel lineUsable = this.commonSettingsContainer.addLine("usable");
                DLCheckBox usableBox = (DLCheckBox)lineUsable.addComponent((DLGuiComponent)new DLCheckBox(0, 0, 165, 18));
                usableBox.text.set((Object)this.textUsable);
                usableBox.checked.set((Object)this.usable);
                usableBox.addEventListener(DLToggleButton.CheckedChangedEvent.class, (s, e) -> {
                    this.usable = e.checked();
                    return false;
                });
            });
        });
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        CreateDynamicWidgets.renderWindow(graphics, 0, 0, this.width(), this.height(), CreateDynamicWidgets.ContainerColor.PURPLE, CreateDynamicWidgets.BarColor.GOLD, CreateDynamicWidgets.BarColor.GRAY, headerSize.size(), footerSize.size(), true);
        CreateDynamicWidgets.renderVerticalSeparator(graphics, this.width() - 31, this.height() - footerSize.size() + 2, footerSize.size() - 4, CreateDynamicWidgets.BarColor.GRAY);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)6, (int)4, (FormattedText)this.title, (DLColor)DragonLib.VANILLA_UI_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)DISPLAY_ITEM).at((float)this.width(), (float)(this.height() - 48), -200.0f)).scale(4.0).render(graphics.graphics());
    }
}

