/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.api.IPredictableWaitCondition;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.ETimeSource;
import de.mrjulsen.crn.data.schedule.INavigationExtension;
import de.mrjulsen.crn.data.schedule.condition.IDelayedWaitCondition;
import de.mrjulsen.crn.data.schedule.instruction.PrioritizedDestinationInstruction;
import de.mrjulsen.crn.data.train.DepartureHistory;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import dev.architectury.utils.GameInstance;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TrainSeparationCondition
extends ScheduledDelay
implements IDelayedWaitCondition,
IPredictableWaitCondition {
    @Deprecated
    public static final String NBT_TIME = "Value";
    @Deprecated
    public static final String NBT_TIME_UNIT = "TimeUnit";
    public static final String NBT_TICKS = "Ticks";
    public static final String NBT_TRAIN_FILTER = "TrainFilter";
    public static final String NBT_TIME_SOURCE = "TimeSource";

    public TrainSeparationCondition() {
        this.data.m_128344_(NBT_TRAIN_FILTER, DepartureHistory.ETrainFilter.ANY.getIndex());
        this.data.m_128405_(NBT_TICKS, 100);
        this.data.m_128344_(NBT_TIME_SOURCE, ETimeSource.REAL_LIFE.getIndex());
    }

    public net.createmod.catnip.data.Pair<ItemStack, Component> getSummary() {
        return net.createmod.catnip.data.Pair.of((Object)ItemStack.f_41583_, (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule.condition." + this.getId().m_135815_() + ".title"), (Object[])new Object[]{this.formatTime(true)}));
    }

    public ItemStack getSecondLineIcon() {
        return new ItemStack((ItemLike)Items.f_42264_);
    }

    public int totalWaitTicks() {
        return 0;
    }

    private int getSeparationTime() {
        if (this.data.m_128441_(NBT_TICKS)) {
            return this.data.m_128451_(NBT_TICKS);
        }
        return 0;
    }

    protected Component formatTime(boolean compact) {
        int remainingTicks = this.getSeparationTime();
        switch (this.getTimeSource()) {
            case IN_GAME: {
                return TextUtils.text((String)TrainSeparationCondition.toTime(remainingTicks).format(Constants.DEFAULT_GAME_DURATION_FORMAT, TimeContext.INGAME));
            }
        }
        return TextUtils.text((String)TrainSeparationCondition.toTime(remainingTicks).format(Constants.DEFAULT_REAL_DURATION_FORMAT, TimeContext.REAL));
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_())), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".description"), (Object[])new Object[]{this.formatTime(false), this.getTimeSource().getValueTranslation().getString()}).m_130940_(ChatFormatting.DARK_AQUA), (Object)this.getTrainFilter().getValueTranslation().m_130940_(ChatFormatting.AQUA));
    }

    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        ScheduleEntry entry = (ScheduleEntry)train.runtime.getSchedule().entries.get(train.runtime.currentEntry);
        ((INavigationExtension)train.navigation).addDelayedWaitCondition((Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext>)Pair.of((Object)this, (Object)new IDelayedWaitCondition.DelayedWaitConditionContext(level, train, context, train.getCurrentStation(), entry)));
        return true;
    }

    @Override
    public boolean runDelayed(IDelayedWaitCondition.DelayedWaitConditionContext context) {
        int delayValue = this.getSeparationTime();
        long lastDepartureTimestamp = Long.MIN_VALUE;
        ScheduleEntry entry = context.scheduleEntry();
        ScheduleInstruction scheduleInstruction = entry.instruction;
        if (scheduleInstruction instanceof PrioritizedDestinationInstruction) {
            PrioritizedDestinationInstruction instruction = (PrioritizedDestinationInstruction)scheduleInstruction;
            stationName = instruction.getFilters();
            lastDepartureTimestamp = stationName.stream().mapToLong(x -> DepartureHistory.getLatestDepartureFor(this.getTrainFilter(), context.train(), x)).max().orElse(0L);
        } else {
            stationName = entry.instruction;
            if (stationName instanceof DestinationInstruction) {
                DestinationInstruction instruction = (DestinationInstruction)stationName;
                stationName = instruction.getFilter();
                lastDepartureTimestamp = DepartureHistory.getLatestDepartureFor(this.getTrainFilter(), context.train(), (String)stationName);
            }
        }
        if (GameInstance.getServer() != null && lastDepartureTimestamp + (long)delayValue < GameInstance.getServer().m_129783_().m_46467_()) {
            DepartureHistory.updateDepartures(context.station().name, context.train());
            return true;
        }
        return false;
    }

    public ResourceLocation getId() {
        return new ResourceLocation("createrailwaysnavigator", "train_separation");
    }

    public DepartureHistory.ETrainFilter getTrainFilter() {
        return DepartureHistory.ETrainFilter.getByIndex(this.data.m_128445_(NBT_TRAIN_FILTER));
    }

    public ETimeSource getTimeSource() {
        return ETimeSource.getByIndex(this.data.m_128445_(NBT_TIME_SOURCE));
    }

    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initTimingAdjustmentGui(this, builder);
    }

    @Override
    public long waitUntil(long worldTime) {
        return worldTime + (long)this.totalWaitTicks();
    }

    public static DLTime toTime(long ticks) {
        return DLTime.fromTicks((double)ticks, (ITimeSystem)new ConfiguredTimeSystem());
    }
}

