/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.data.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.util.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;

public final class DepartureHistory {
    private static final String NBT_DATA = "DepartureHistory";
    private static final Map<String, Data> departuresByStation = new ConcurrentHashMap<String, Data>();

    private DepartureHistory() {
    }

    public static void clear() {
        departuresByStation.clear();
    }

    public static void updateDepartures(String stationName, Train train) {
        departuresByStation.computeIfAbsent(stationName, x -> new Data()).setDeparture(train);
    }

    public static Map<String, Data> getDeparturesAtStation(String stationFilter) {
        return departuresByStation.entrySet().stream().filter(entry -> TrainUtils.stationMatches((String)entry.getKey(), stationFilter)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static long getLatestDepartureFor(ETrainFilter trainFilter, Train train, String stationName) {
        long latestDepartureTime = Long.MIN_VALUE;
        Map<String, Data> dataSrc = DepartureHistory.getDeparturesAtStation(stationName);
        Optional<TrainData> data = TrainListener.getTrainData(train);
        if (!data.isPresent()) {
            return latestDepartureTime;
        }
        Optional<TrainCategory> category = data.get().getCurrentSection().getTrainCategory();
        Optional<TrainLine> line = data.get().getCurrentSection().getTrainLine();
        block5: for (Map.Entry<String, Data> e : dataSrc.entrySet()) {
            switch (trainFilter.ordinal()) {
                case 2: {
                    latestDepartureTime = Math.max(latestDepartureTime, category.map(x -> ((Data)e.getValue()).getDepartureByCategory((TrainCategory)x).orElse(Long.MIN_VALUE)).orElse(Long.MIN_VALUE));
                    continue block5;
                }
                case 1: {
                    latestDepartureTime = Math.max(latestDepartureTime, line.map(x -> ((Data)e.getValue()).getDepartureByLine((TrainLine)x).orElse(Long.MIN_VALUE)).orElse(Long.MIN_VALUE));
                    continue block5;
                }
                case 3: {
                    latestDepartureTime = Math.max(latestDepartureTime, Optional.ofNullable(train.name).map(x -> ((Data)e.getValue()).getDepartureByName(x.getString()).orElse(Long.MIN_VALUE)).orElse(Long.MIN_VALUE));
                    continue block5;
                }
            }
            latestDepartureTime = Math.max(latestDepartureTime, e.getValue().getLastDepartureTime());
        }
        return latestDepartureTime;
    }

    public static void validate() {
        departuresByStation.keySet().retainAll(TrainUtils.getAllStations().stream().map(x -> x.name).toList());
    }

    public static int debug_dataCount() {
        return departuresByStation.size();
    }

    public static CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        CompoundTag data = new CompoundTag();
        for (Map.Entry<String, Data> e : departuresByStation.entrySet()) {
            data.m_128365_(e.getKey(), (Tag)e.getValue().toNbt());
        }
        nbt.m_128365_(NBT_DATA, (Tag)data);
        return nbt;
    }

    public static void fromNbt(CompoundTag nbt) {
        departuresByStation.clear();
        CompoundTag data = nbt.m_128469_(NBT_DATA);
        for (String key : data.m_128431_()) {
            departuresByStation.put(key, Data.fromNbt(data.m_128469_(key)));
        }
    }

    public static class Data {
        private static final String NBT_LAST_DEPARTURE = "LastDeparture";
        private static final String NBT_LINES = "Lines";
        private static final String NBT_CATEGORIES = "Categories";
        private static final String NBT_NAMES = "Names";
        private long lastDepartureTime = Long.MIN_VALUE;
        private Map<TrainLine, Long> lastDepartureByLine = new ConcurrentHashMap<TrainLine, Long>();
        private Map<TrainCategory, Long> lastDepartureByCategory = new ConcurrentHashMap<TrainCategory, Long>();
        private Map<String, Long> lastDepartureByTrainName = new ConcurrentHashMap<String, Long>();

        public void setDeparture(Train train) {
            this.lastDepartureTime = ((MinecraftServer)DragonLib.getCurrentServer().get()).m_129783_().m_46467_();
            this.lastDepartureByTrainName.put(train.name.getString(), this.lastDepartureTime);
            TrainListener.getTrainData(train.id).ifPresent(data -> {
                ScheduleSection section = data.getCurrentSection();
                section.getTrainLine().ifPresent(x -> this.lastDepartureByLine.put((TrainLine)x, this.lastDepartureTime));
                section.getTrainCategory().ifPresent(x -> this.lastDepartureByCategory.put((TrainCategory)x, this.lastDepartureTime));
            });
        }

        public long getLastDepartureTime(ETrainFilter filter, String trainName, ScheduleSection section) {
            return switch (filter.ordinal()) {
                case 2 -> {
                    if (section != null) {
                        yield section.getTrainCategory().map(x -> this.lastDepartureByCategory.getOrDefault(x, Long.MIN_VALUE)).orElse(Long.MIN_VALUE);
                    }
                    yield Long.MIN_VALUE;
                }
                case 1 -> {
                    if (section != null) {
                        yield section.getTrainLine().map(x -> this.lastDepartureByLine.getOrDefault(x, Long.MIN_VALUE)).orElse(Long.MIN_VALUE);
                    }
                    yield Long.MIN_VALUE;
                }
                case 3 -> {
                    if (trainName != null) {
                        yield this.lastDepartureByTrainName.getOrDefault(trainName, Long.MIN_VALUE);
                    }
                    yield Long.MIN_VALUE;
                }
                default -> this.lastDepartureTime;
            };
        }

        public long getLastDepartureTime() {
            return this.lastDepartureTime;
        }

        public Map<TrainLine, Long> getLastDeparturesByLine() {
            return this.lastDepartureByLine;
        }

        public Map<TrainCategory, Long> getLastDeparturesByCategory() {
            return this.lastDepartureByCategory;
        }

        public Map<String, Long> getLastDeparturesByTrainName() {
            return this.lastDepartureByTrainName;
        }

        public Optional<Long> getDepartureByCategory(TrainCategory category) {
            return Optional.ofNullable(this.lastDepartureByCategory.containsKey(category) ? this.lastDepartureByCategory.get(category) : null);
        }

        public Optional<Long> getDepartureByLine(TrainLine line) {
            return Optional.ofNullable(this.lastDepartureByLine.containsKey(line) ? this.lastDepartureByLine.get(line) : null);
        }

        public Optional<Long> getDepartureByName(String name) {
            return Optional.ofNullable(this.lastDepartureByTrainName.containsKey(name) ? this.lastDepartureByTrainName.get(name) : null);
        }

        public long debug_cachedDataCount() {
            return 1 + this.lastDepartureByLine.size() + this.lastDepartureByCategory.size();
        }

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_(NBT_LAST_DEPARTURE, this.lastDepartureTime);
            CompoundTag linesList = new CompoundTag();
            for (Map.Entry<TrainLine, Long> entry : this.lastDepartureByLine.entrySet()) {
                linesList.m_128356_(entry.getKey().getId().toString(), entry.getValue().longValue());
            }
            nbt.m_128365_(NBT_LINES, (Tag)linesList);
            CompoundTag categoriesList = new CompoundTag();
            for (Map.Entry<TrainCategory, Long> entry : this.lastDepartureByCategory.entrySet()) {
                categoriesList.m_128356_(entry.getKey().getId().toString(), entry.getValue().longValue());
            }
            nbt.m_128365_(NBT_CATEGORIES, (Tag)categoriesList);
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<String, Long> e : this.lastDepartureByTrainName.entrySet()) {
                compoundTag.m_128356_(e.getKey(), e.getValue().longValue());
            }
            nbt.m_128365_(NBT_NAMES, (Tag)compoundTag);
            return nbt;
        }

        public static Data fromNbt(CompoundTag nbt) {
            Data data = new Data();
            data.lastDepartureTime = nbt.m_128454_(NBT_LAST_DEPARTURE);
            CompoundTag linesList = nbt.m_128469_(NBT_LINES);
            for (Object key : linesList.m_128431_()) {
                GlobalSettings.getInstance().getTrainLine(UUID.fromString((String)key)).ifPresent(arg_0 -> Data.lambda$fromNbt$5(data, linesList, (String)key, arg_0));
            }
            CompoundTag categoriesList = nbt.m_128469_(NBT_CATEGORIES);
            for (String key : categoriesList.m_128431_()) {
                GlobalSettings.getInstance().getTrainCategory(UUID.fromString(key)).ifPresent(x -> data.lastDepartureByCategory.put((TrainCategory)x, categoriesList.m_128454_(key)));
            }
            CompoundTag namesList = nbt.m_128469_(NBT_NAMES);
            for (String key : namesList.m_128431_()) {
                data.lastDepartureByTrainName.put(key, namesList.m_128454_(key));
            }
            return data;
        }

        private static /* synthetic */ void lambda$fromNbt$5(Data data, CompoundTag linesList, String key, TrainLine x) {
            data.lastDepartureByLine.put(x, linesList.m_128454_(key));
        }
    }

    public static enum ETrainFilter implements ITranslatableEnum
    {
        ANY(0, "any"),
        SAME_LINE(1, "same_line"),
        SAME_CATEGORY(2, "same_category"),
        SAME_NAME(3, "same_name");

        private final byte index;
        private final String name;

        private ETrainFilter(byte index, String name) {
            this.index = index;
            this.name = name;
        }

        public byte getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static ETrainFilter getByIndex(byte i) {
            return Arrays.stream(ETrainFilter.values()).filter(x -> x.getIndex() == i).findFirst().orElse(ANY);
        }

        public ITranslatableEnum.Data getTranslationData() {
            return new ITranslatableEnum.Data("createrailwaysnavigator", "train_filter", this.name);
        }
    }

    public static class Stats {
        private static final String NBT_LAST_DEPARTURE = "LastDeparture";
        private static final String NBT_LINE = "Line";
        private static final String NBT_CATEGORY = "Category";
        private static final String NBT_NAME = "Name";
        private final long lastDeparture;
        private final Map<String, Long> departuresByCategory;
        private final Map<String, Long> departuresByLine;
        private final Map<String, Long> departuresByName;
        private final Optional<Pair<String, Long>> latestCategoryDeparture;
        private final Optional<Pair<String, Long>> latestLineDeparture;
        private final Optional<Pair<String, Long>> latestNameDeparture;

        public Stats(long lastDeparture, Map<String, Long> departuresByCategory, Map<String, Long> departuresByLine, Map<String, Long> departuresByName) {
            this.lastDeparture = lastDeparture;
            this.departuresByCategory = departuresByCategory;
            this.departuresByLine = departuresByLine;
            this.departuresByName = departuresByName;
            this.latestCategoryDeparture = departuresByCategory.entrySet().stream().max((a, b) -> Long.compare((Long)a.getValue(), (Long)b.getValue())).map(p -> new Pair((Object)((String)p.getKey()), (Object)((Long)p.getValue())));
            this.latestLineDeparture = departuresByLine.entrySet().stream().max((a, b) -> Long.compare((Long)a.getValue(), (Long)b.getValue())).map(p -> new Pair((Object)((String)p.getKey()), (Object)((Long)p.getValue())));
            this.latestNameDeparture = departuresByName.entrySet().stream().max((a, b) -> Long.compare((Long)a.getValue(), (Long)b.getValue())).map(p -> new Pair((Object)((String)p.getKey()), (Object)((Long)p.getValue())));
        }

        public static Stats of(Data data) {
            Map<String, Long> categories = data.getLastDeparturesByCategory().entrySet().stream().collect(Collectors.toMap(p -> ((TrainCategory)p.getKey()).getCategoryName(), p -> (Long)p.getValue()));
            Map<String, Long> lines = data.getLastDeparturesByLine().entrySet().stream().collect(Collectors.toMap(p -> ((TrainLine)p.getKey()).getLineName(), p -> (Long)p.getValue()));
            Map<String, Long> names = data.getLastDeparturesByTrainName().entrySet().stream().collect(Collectors.toMap(p -> (String)p.getKey(), p -> (Long)p.getValue()));
            return new Stats(data.getLastDepartureTime(), categories, lines, names);
        }

        public static Stats ofStation(String stationName) {
            return DepartureHistory.getDeparturesAtStation(stationName).values().stream().map(Stats::of).findFirst().orElse(Stats.empty());
        }

        public static Stats empty() {
            return new Stats(-1L, Map.of(), Map.of(), Map.of());
        }

        public boolean isEmpty() {
            return this.getLastDeparture() < 0L && this.getDeparturesByCategory().isEmpty() && this.getDeparturesByLine().isEmpty() && this.getDeparturesByName().isEmpty();
        }

        public long getLastDeparture() {
            return this.lastDeparture;
        }

        public Map<String, Long> getDeparturesByCategory() {
            return this.departuresByCategory;
        }

        public Map<String, Long> getDeparturesByLine() {
            return this.departuresByLine;
        }

        public Map<String, Long> getDeparturesByName() {
            return this.departuresByName;
        }

        public Optional<Pair<String, Long>> getLatestCategoryDeparture() {
            return this.latestCategoryDeparture;
        }

        public Optional<Pair<String, Long>> getLatestLineDeparture() {
            return this.latestLineDeparture;
        }

        public Optional<Pair<String, Long>> getLatestNameDeparture() {
            return this.latestNameDeparture;
        }

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            CompoundTag categoriesTag = new CompoundTag();
            for (Map.Entry<String, Long> entry : this.departuresByCategory.entrySet()) {
                categoriesTag.m_128356_(entry.getKey(), entry.getValue().longValue());
            }
            CompoundTag linesTag = new CompoundTag();
            for (Map.Entry<String, Long> entry : this.departuresByLine.entrySet()) {
                linesTag.m_128356_(entry.getKey(), entry.getValue().longValue());
            }
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<String, Long> e : this.departuresByName.entrySet()) {
                compoundTag.m_128356_(e.getKey(), e.getValue().longValue());
            }
            nbt.m_128356_(NBT_LAST_DEPARTURE, this.lastDeparture);
            nbt.m_128365_(NBT_CATEGORY, (Tag)categoriesTag);
            nbt.m_128365_(NBT_LINE, (Tag)linesTag);
            nbt.m_128365_(NBT_NAME, (Tag)compoundTag);
            return nbt;
        }

        public static Stats fromNbt(CompoundTag nbt) {
            HashMap<String, Long> categories = new HashMap<String, Long>();
            CompoundTag categoriesTag = nbt.m_128469_(NBT_CATEGORY);
            for (String key : categoriesTag.m_128431_()) {
                categories.put(key, categoriesTag.m_128454_(key));
            }
            HashMap<String, Long> lines = new HashMap<String, Long>();
            CompoundTag linesTag = nbt.m_128469_(NBT_LINE);
            for (String key : linesTag.m_128431_()) {
                lines.put(key, linesTag.m_128454_(key));
            }
            HashMap<String, Long> names = new HashMap<String, Long>();
            CompoundTag namesTag = nbt.m_128469_(NBT_NAME);
            for (String key : namesTag.m_128431_()) {
                names.put(key, namesTag.m_128454_(key));
            }
            return new Stats(nbt.m_128454_(NBT_LAST_DEPARTURE), categories, lines, names);
        }
    }
}

