/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import de.mrjulsen.crn.data.train.TrainPrediction;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;

public class PredictionTimes {
    private static final String NBT_REFRESHED = "Refreshed";
    private static final String NBT_ARRIVAL = "Arrival";
    private static final String NBT_DEPARTURE = "Departure";
    private static final String NBT_MIN_DEPARTURE = "MinDeparture";
    private final TrainPrediction prediction;
    private long refreshTime;
    private long arrivalTime;
    private long departureTime;
    private long minDepartureTime;

    public PredictionTimes(TrainPrediction prediction, long refreshTime, long arrivalTime, long departureTime, long minDepartureTime) {
        this.prediction = prediction;
        this.set(refreshTime, arrivalTime, departureTime, minDepartureTime);
    }

    void set(long refreshTime, long arrivalTime, long departureTime, long minDepartureTime) {
        this.refreshTime = refreshTime;
        this.arrivalTime = Math.max(this.refreshTime, arrivalTime);
        this.departureTime = Math.max(this.arrivalTime, departureTime);
        this.minDepartureTime = Math.max(this.arrivalTime, minDepartureTime);
    }

    void shift(long amount, boolean updateRefreshTime) {
        if (updateRefreshTime) {
            this.refreshTime += amount;
        }
        this.arrivalTime += amount;
        DepartureTime dt = TrainPrediction.estimateDepartures(this.prediction.getData().getTrain(), this.prediction.getEntryIndex(), this.arrivalTime);
        this.departureTime = dt.defaultDepartureTime();
        this.minDepartureTime = dt.minDepartureTime();
    }

    public long refreshTime() {
        return this.refreshTime;
    }

    public long arrivalTime() {
        return this.arrivalTime;
    }

    public long defaultDepartureTime() {
        return this.departureTime;
    }

    public long departureTime() {
        if (this.minStayDuration() < this.stayDuration() && this.prediction.scheduled() != null && this.prediction.scheduled() != this && this.prediction.getData().isInitialized()) {
            return Math.max(this.minDepartureTime(), this.prediction.scheduled().defaultDepartureTime());
        }
        return this.defaultDepartureTime();
    }

    public long minDepartureTime() {
        return this.minDepartureTime;
    }

    public long arrivalIn() {
        return this.arrivalTime() - this.refreshTime();
    }

    public long departureIn() {
        return this.departureTime() - this.refreshTime();
    }

    public long minDepartureIn() {
        return this.minDepartureTime() - this.refreshTime();
    }

    public long stayDuration() {
        return Math.max(0L, this.defaultDepartureTime() - this.arrivalTime());
    }

    public long minStayDuration() {
        return Math.max(0L, this.minDepartureTime() - this.arrivalTime());
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128356_(NBT_REFRESHED, this.refreshTime);
        nbt.m_128356_(NBT_ARRIVAL, this.arrivalTime);
        nbt.m_128356_(NBT_DEPARTURE, this.departureTime);
        nbt.m_128356_(NBT_MIN_DEPARTURE, this.minDepartureTime);
        return nbt;
    }

    public static PredictionTimes fromNbt(TrainPrediction prediction, CompoundTag nbt) {
        long refreshTime = nbt.m_128454_(NBT_REFRESHED);
        long arrivalTime = nbt.m_128454_(NBT_ARRIVAL);
        long departureTime = nbt.m_128454_(NBT_DEPARTURE);
        long minDepartureTime = nbt.m_128454_(NBT_MIN_DEPARTURE);
        PredictionTimes t = new PredictionTimes(prediction, refreshTime, arrivalTime, departureTime, minDepartureTime);
        return t;
    }

    public final boolean equals(Object other) {
        if (other instanceof PredictionTimes) {
            PredictionTimes o = (PredictionTimes)other;
            return this.refreshTime() == o.refreshTime() && this.arrivalTime() == o.arrivalTime();
        }
        return false;
    }

    public final int hashCode() {
        return 31 * Objects.hash(this.refreshTime(), this.arrivalTime());
    }

    public final String toString() {
        return String.format("PredictionTimes[R: %s, A: %s, D: %s, At: %s, Dt: %s, d: %s]", this.refreshTime(), this.arrivalTime(), this.departureTime(), this.arrivalIn(), this.departureIn(), this.stayDuration());
    }

    public record DepartureTime(long defaultDepartureTime, long minDepartureTime) {
    }
}

