/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class CreateStationTagPacketData {
    private static final String NBT_DATA = "Data";
    private static final String NBT_NAME = "Name";
    private static final String NBT_OWNER = "Owner";

    public static Response handle(Request packet, NetworkPacketContext context) {
        if (!GlobalSettings.modificationsAllowed(context.getPlayer())) {
            return new Response(Optional.empty());
        }
        return new Response(Optional.ofNullable(GlobalSettings.getInstance().createOrGetStationTag(TagName.of(packet.name), packet.owner.orElse(null))));
    }

    public static class Response
    extends NetworkPacketData {
        private Optional<StationTag> tag;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Optional<StationTag> tag) {
            super(DLStatus.OK);
            this.tag = tag;
        }

        protected void write(CompoundTag nbt) {
            this.tag.ifPresent(x -> nbt.m_128365_(CreateStationTagPacketData.NBT_DATA, (Tag)x.toNbt()));
        }

        protected void read(CompoundTag nbt) {
            this.tag = nbt.m_128441_(CreateStationTagPacketData.NBT_DATA) ? Optional.ofNullable(StationTag.fromNbt(nbt.m_128469_(CreateStationTagPacketData.NBT_DATA), null)) : Optional.empty();
        }

        public Optional<StationTag> getTag() {
            return this.tag;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private String name;
        private Optional<Owner> owner;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(String name, Optional<Owner> owner) {
            super(DLStatus.OK);
            this.name = name;
            this.owner = owner;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128359_(CreateStationTagPacketData.NBT_NAME, this.name);
            this.owner.ifPresent(x -> nbt.m_128365_(CreateStationTagPacketData.NBT_OWNER, (Tag)x.toNbt()));
        }

        protected void read(CompoundTag nbt) {
            this.name = nbt.m_128461_(CreateStationTagPacketData.NBT_NAME);
            this.owner = Optional.ofNullable(nbt.m_128441_(CreateStationTagPacketData.NBT_OWNER) ? Owner.fromNbt(nbt.m_128469_(CreateStationTagPacketData.NBT_OWNER)) : null);
        }
    }
}

