/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class GetAllStationsAsTagsPacketData {
    private static final String NBT_DATA = "Data";
    private static final String NBT_EXCLUDE_BLACKLISTED = "ExcludeBlacklisted";

    public static Response handle(Request packet, NetworkPacketContext context) {
        return new Response(TrainUtils.getAllStations().stream().filter(x -> !packet.excludeBlacklisted || !GlobalSettings.getInstance().isStationBlacklisted((GlobalStation)x)).map(x -> GlobalSettings.getInstance().getOrCreateStationTagFor((GlobalStation)x)).distinct().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList());
    }

    public static class Response
    extends NetworkPacketData {
        private Collection<StationTag> tags;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Collection<StationTag> tags) {
            super(DLStatus.OK);
            this.tags = tags;
        }

        protected void write(CompoundTag nbt) {
            ListTag list = new ListTag();
            for (StationTag tag : this.tags) {
                list.add((Object)tag.toNbt());
            }
            nbt.m_128365_(GetAllStationsAsTagsPacketData.NBT_DATA, (Tag)list);
        }

        protected void read(CompoundTag nbt) {
            this.tags = nbt.m_128437_(GetAllStationsAsTagsPacketData.NBT_DATA, 10).stream().map(x -> StationTag.fromNbt((CompoundTag)x, null)).toList();
        }

        public Collection<StationTag> getTags() {
            return this.tags;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private boolean excludeBlacklisted;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(boolean excludeBlacklisted) {
            super(DLStatus.OK);
            this.excludeBlacklisted = excludeBlacklisted;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128379_(GetAllStationsAsTagsPacketData.NBT_EXCLUDE_BLACKLISTED, this.excludeBlacklisted);
        }

        protected void read(CompoundTag nbt) {
            this.excludeBlacklisted = nbt.m_128471_(GetAllStationsAsTagsPacketData.NBT_EXCLUDE_BLACKLISTED);
        }
    }
}

