/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.CRNPlatformSpecific;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class GetOnlinePlayersPacketData
extends NetworkPacketData {
    private static final String NBT_DATA = "Data";
    private List<Owner> players;

    public GetOnlinePlayersPacketData(DLStatus status) {
        super(status);
    }

    public GetOnlinePlayersPacketData(List<Owner> players) {
        super(DLStatus.OK);
        this.players = players;
    }

    protected void write(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (Owner player : this.players) {
            list.add((Object)player.toNbt());
        }
        nbt.m_128365_(NBT_DATA, (Tag)list);
    }

    protected void read(CompoundTag nbt) {
        this.players = nbt.m_128437_(NBT_DATA, 10).stream().map(x -> Owner.fromNbt((CompoundTag)x)).sorted((a, b) -> a.name().compareToIgnoreCase(b.name())).toList();
    }

    public List<Owner> getPlayers() {
        return this.players;
    }

    public static GetOnlinePlayersPacketData handle(NetworkPacketContext context) {
        return new GetOnlinePlayersPacketData(CRNPlatformSpecific.getAllKnownPlayers().entrySet().stream().map(e -> new Owner((UUID)e.getKey())).toList());
    }
}

