/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.TrainDisplayData;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class GetTrainDisplayDataPacketData {
    private static final String NBT_DATA = "Data";

    public static Response handle(Request packet, NetworkPacketContext context) {
        Optional<Train> trainOpt = TrainUtils.getTrain(packet.id);
        if (!trainOpt.isPresent() || !TrainUtils.isTrainUsable(trainOpt.get()) || GlobalSettings.getInstance().isTrainBlacklisted(trainOpt.get())) {
            return new Response(TrainDisplayData.empty());
        }
        Response r = new Response(TrainDisplayData.of(trainOpt.get()));
        return r;
    }

    public static class Request
    extends NetworkPacketData {
        private UUID id;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(UUID id) {
            super(DLStatus.OK);
            this.id = id;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128362_(GetTrainDisplayDataPacketData.NBT_DATA, this.id);
        }

        protected void read(CompoundTag nbt) {
            this.id = nbt.m_128342_(GetTrainDisplayDataPacketData.NBT_DATA);
        }
    }

    public static class Response
    extends NetworkPacketData {
        private TrainDisplayData data;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(TrainDisplayData data) {
            super(DLStatus.OK);
            this.data = data;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128365_(GetTrainDisplayDataPacketData.NBT_DATA, (Tag)this.data.toNbt());
        }

        protected void read(CompoundTag nbt) {
            this.data = TrainDisplayData.fromNbt(nbt.m_128469_(GetTrainDisplayDataPacketData.NBT_DATA));
        }

        public TrainDisplayData getData() {
            return this.data;
        }
    }
}

