/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class GetUserSettingsPacketData {
    private static final String NBT_DATA = "Data";
    private static final String NBT_ID = "Id";

    public static Response handle(Request packet, NetworkPacketContext context) {
        return new Response(Optional.ofNullable(UserSettings.getSettingsFor(packet.id, false)));
    }

    public static class Response
    extends NetworkPacketData {
        private Optional<UserSettings> data;
        private UUID playerId;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Optional<UserSettings> data) {
            super(DLStatus.OK);
            this.data = data;
            this.playerId = data.map(x -> x.getOwnerId()).orElse(new UUID(0L, 0L));
        }

        protected void write(CompoundTag nbt) {
            this.data.ifPresent(x -> nbt.m_128365_(GetUserSettingsPacketData.NBT_DATA, (Tag)x.toNbt()));
            nbt.m_128362_(GetUserSettingsPacketData.NBT_ID, this.playerId);
        }

        protected void read(CompoundTag nbt) {
            this.data = Optional.ofNullable(nbt.m_128441_(GetUserSettingsPacketData.NBT_DATA) ? UserSettings.fromNbt(nbt.m_128469_(GetUserSettingsPacketData.NBT_DATA), nbt.m_128342_(GetUserSettingsPacketData.NBT_ID), false) : null);
            this.playerId = nbt.m_128342_(GetUserSettingsPacketData.NBT_ID);
        }

        public Optional<UserSettings> getData() {
            return this.data;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private UUID id;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(UUID id) {
            super(DLStatus.OK);
            this.id = id;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128362_(GetUserSettingsPacketData.NBT_ID, this.id);
        }

        protected void read(CompoundTag nbt) {
            this.id = nbt.m_128342_(GetUserSettingsPacketData.NBT_ID);
        }
    }
}

