/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.network.packets.pain.EmptyNetworkPacketData;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public class UpdateStationTagNamePacketData
extends NetworkPacketData {
    private static final String NBT_ID = "Id";
    private static final String NBT_NAME = "Name";
    private UUID id;
    private String name;

    public UpdateStationTagNamePacketData(DLStatus status) {
        super(status);
    }

    public UpdateStationTagNamePacketData(UUID tagId, String name) {
        super(DLStatus.OK);
        this.id = tagId;
        this.name = name;
    }

    protected void write(CompoundTag nbt) {
        nbt.m_128362_(NBT_ID, this.id);
        nbt.m_128359_(NBT_NAME, this.name);
    }

    protected void read(CompoundTag nbt) {
        this.id = nbt.m_128342_(NBT_ID);
        this.name = nbt.m_128461_(NBT_NAME);
    }

    public static EmptyNetworkPacketData handle(UpdateStationTagNamePacketData packet, NetworkPacketContext context) {
        GlobalSettings.getInstance().getStationTag(packet.id).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(context.getPlayer())) || !GlobalSettings.modificationsAllowed(context.getPlayer())) {
                return;
            }
            x.updateLastEdited(context.getPlayer());
            x.setName(TagName.of(packet.name));
        });
        return new EmptyNetworkPacketData();
    }
}

