/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.INumberFormatAdapter;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;
import de.mrjulsen.mcdragonlib.util.time.format.TimeFormaturVerboseDuration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IngameTimeNumberFormatter
implements INumberFormatAdapter {
    public static final IngameTimeNumberFormatter INSTANCE = new IngameTimeNumberFormatter();

    public String format(double value) {
        return DLTime.fromTicks((double)value, (ITimeSystem)new ConfiguredTimeSystem()).format((ITimeFormatter)new TimeFormaturVerboseDuration(Constants.NULL_TIME, false, false, true, true, true), TimeContext.INGAME);
    }

    public double parse(String input) throws NumberFormatException {
        double ticksPerDay = 24000.0;
        double ticksPerHour = 1000.0;
        double ticksPerMinute = 16.666666666666668;
        Pattern pattern = Pattern.compile("(\\d+)d|(\\d+)h|(\\d+)m");
        Matcher matcher = pattern.matcher(input.replaceAll("\\s+", ""));
        double totalTicks = 0.0;
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                int days = Integer.parseInt(matcher.group(1));
                totalTicks += (double)days * 24000.0;
                continue;
            }
            if (matcher.group(2) != null) {
                int hours = Integer.parseInt(matcher.group(2));
                totalTicks += (double)hours * 1000.0;
                continue;
            }
            if (matcher.group(3) == null) continue;
            int minutes = Integer.parseInt(matcher.group(3));
            totalTicks += (double)minutes * 16.666666666666668;
        }
        return totalTicks;
    }
}

