/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.mixins.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.PaintingRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.features.texture_handlers.ETFSprite;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

@Mixin(value={PaintingRenderer.class})
public abstract class MixinPaintingEntityRenderer
extends EntityRenderer<Painting> {
    @Unique
    private static final ResourceLocation etf$BACK_SPRITE_ID = ETFUtils2.res("textures/painting/back.png");

    @Unique
    private void uVertex(PoseStack.Pose matrix, VertexConsumer vertexConsumer, float x, float y, float u, float v, float z, int normalX, int normalY, int normalZ, int light) {
        this.m_253084_(matrix.m_252922_(), matrix.m_252943_(), vertexConsumer, x, y, u, v, z, normalX, normalY, normalZ, light);
    }

    @Shadow
    protected abstract void m_253084_(Matrix4f var1, Matrix3f var2, VertexConsumer var3, float var4, float var5, float var6, float var7, float var8, int var9, int var10, int var11, int var12);

    protected MixinPaintingEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(method={"m_7392_(Lnet/minecraft/world/entity/decoration/Painting;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void etf$getSprites(Painting paintingEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo ci) {
        ETFEntityRenderState etfEntity = ETFEntityRenderState.forEntity((ETFEntity)paintingEntity);
        try {
            TextureAtlasSprite paintingSprite = Minecraft.m_91087_().m_91305_().m_235033_((PaintingVariant)paintingEntity.m_28554_().m_203334_());
            TextureAtlasSprite backSprite = Minecraft.m_91087_().m_91305_().m_118806_();
            ResourceLocation paintingId = paintingSprite.m_245424_().m_246162_();
            String paintingFileName = paintingId.m_135815_();
            ResourceLocation paintingTexture = ETFUtils2.res(paintingId.m_135827_(), "textures/painting/" + paintingFileName + ".png");
            boolean aztec = "aztec".equals(paintingFileName);
            if (aztec) {
                ETFRenderContext.allowOnlyPropertiesRandom();
            }
            ETFTexture frontTexture = ETFManager.getInstance().getETFTextureVariant(paintingTexture, etfEntity);
            ETFSprite etf$Sprite = frontTexture.getPaintingSprite(paintingSprite, paintingTexture);
            if (aztec) {
                ETFRenderContext.allowAllRandom();
            }
            ETFTexture backTexture = ETFManager.getInstance().getETFTextureVariant(etf$BACK_SPRITE_ID, etfEntity);
            ETFSprite etf$BackSprite = backTexture.getPaintingSprite(backSprite, etf$BACK_SPRITE_ID);
            if (etf$Sprite.isETFAltered || etf$Sprite.isEmissive() || etf$BackSprite.isETFAltered || etf$BackSprite.isEmissive()) {
                matrixStack.m_85836_();
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - f));
                PaintingVariant paintingVariant = (PaintingVariant)paintingEntity.m_28554_().m_203334_();
                matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
                int width = paintingVariant.m_218908_();
                int height = paintingVariant.m_218909_();
                this.etf$renderETFPainting(matrixStack.m_85850_(), vertexConsumerProvider, paintingEntity, width, height, etf$Sprite, etf$BackSprite);
                matrixStack.m_85849_();
                super.m_7392_((Entity)paintingEntity, f, g, matrixStack, vertexConsumerProvider, i);
                ci.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private void etf$renderETFPainting(PoseStack.Pose entry, MultiBufferSource vertexConsumerProvider, Painting entity, int width, int height, ETFSprite ETFPaintingSprite, ETFSprite ETFBackSprite) {
        ETFRenderContext.preventRenderLayerTextureModify();
        VertexConsumer vertexConsumerFront = vertexConsumerProvider.m_6299_(RenderType.m_110446_((ResourceLocation)ETFPaintingSprite.getSpriteVariant().m_247685_()));
        this.etf$renderETFPaintingFront(entry, vertexConsumerFront, entity, width, height, ETFPaintingSprite.getSpriteVariant(), false);
        VertexConsumer vertexConsumerBack = vertexConsumerProvider.m_6299_(RenderType.m_110446_((ResourceLocation)ETFBackSprite.getSpriteVariant().m_247685_()));
        this.etf$renderETFPaintingBack(entry, vertexConsumerBack, entity, width, height, ETFBackSprite.getSpriteVariant(), false);
        if (ETFPaintingSprite.isEmissive()) {
            vertexConsumerFront = vertexConsumerProvider.m_6299_(RenderType.m_110473_((ResourceLocation)ETFPaintingSprite.getEmissive().m_247685_()));
            this.etf$renderETFPaintingFront(entry, vertexConsumerFront, entity, width, height, ETFPaintingSprite.getEmissive(), true);
        }
        if (ETFBackSprite.isEmissive()) {
            vertexConsumerFront = vertexConsumerProvider.m_6299_(RenderType.m_110473_((ResourceLocation)ETFBackSprite.getEmissive().m_247685_()));
            this.etf$renderETFPaintingBack(entry, vertexConsumerFront, entity, width, height, ETFBackSprite.getEmissive(), true);
        }
        ETFRenderContext.allowRenderLayerTextureModify();
    }

    @Unique
    private void etf$renderETFPaintingFront(PoseStack.Pose entry, VertexConsumer vertexConsumerFront, Painting entity, int width, int height, TextureAtlasSprite paintingSprite, boolean emissive) {
        float f = (float)(-width) / 2.0f;
        float g = (float)(-height) / 2.0f;
        int u = width / 16;
        int v = height / 16;
        double d = 1.0 / (double)u;
        double e = 1.0 / (double)v;
        for (int w = 0; w < u; ++w) {
            for (int x = 0; x < v; ++x) {
                int light;
                float y = f + (float)((w + 1) * 16);
                float z = f + (float)(w * 16);
                float aa = g + (float)((x + 1) * 16);
                float ab = g + (float)(x * 16);
                if (emissive) {
                    light = 0xF000F2;
                } else {
                    float divider = 16.0f;
                    int ac = entity.m_146903_();
                    int ad = Mth.m_14107_((double)(entity.m_20186_() + (double)((aa + ab) / 2.0f / divider)));
                    int ae = entity.m_146907_();
                    Direction direction = entity.m_6350_();
                    if (direction == Direction.NORTH) {
                        ac = Mth.m_14107_((double)(entity.m_20185_() + (double)((y + z) / 2.0f / divider)));
                    }
                    if (direction == Direction.WEST) {
                        ae = Mth.m_14107_((double)(entity.m_20189_() - (double)((y + z) / 2.0f / divider)));
                    }
                    if (direction == Direction.SOUTH) {
                        ac = Mth.m_14107_((double)(entity.m_20185_() - (double)((y + z) / 2.0f / divider)));
                    }
                    if (direction == Direction.EAST) {
                        ae = Mth.m_14107_((double)(entity.m_20189_() + (double)((y + z) / 2.0f / divider)));
                    }
                    light = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)new BlockPos(ac, ad, ae));
                }
                float zConst = 0.5f;
                float ag = paintingSprite.m_118367_((double)((float)(d * (double)(u - w))));
                float ah = paintingSprite.m_118367_((double)((float)(d * (double)(u - (w + 1)))));
                float ai = paintingSprite.m_118393_((double)((float)(e * (double)(v - x))));
                float aj = paintingSprite.m_118393_((double)((float)(e * (double)(v - (x + 1)))));
                this.uVertex(entry, vertexConsumerFront, y, ab, ah, ai, -zConst, 0, 0, -1, light);
                this.uVertex(entry, vertexConsumerFront, z, ab, ag, ai, -zConst, 0, 0, -1, light);
                this.uVertex(entry, vertexConsumerFront, z, aa, ag, aj, -zConst, 0, 0, -1, light);
                this.uVertex(entry, vertexConsumerFront, y, aa, ah, aj, -zConst, 0, 0, -1, light);
            }
        }
    }

    @Unique
    private void etf$renderETFPaintingBack(PoseStack.Pose entry, VertexConsumer vertexConsumerBack, Painting entity, int width, int height, TextureAtlasSprite backSprite, boolean emissive) {
        float f = (float)(-width) / 2.0f;
        float g = (float)(-height) / 2.0f;
        float i = backSprite.m_118409_();
        float j = backSprite.m_118410_();
        float k = backSprite.m_118411_();
        float l = backSprite.m_118412_();
        float m = backSprite.m_118409_();
        float n = backSprite.m_118410_();
        float o = backSprite.m_118411_();
        float p = backSprite.m_118393_(0.0625);
        float q = backSprite.m_118409_();
        float r = backSprite.m_118367_(0.0625);
        float s = backSprite.m_118411_();
        float t = backSprite.m_118412_();
        int u = width / 16;
        int v = height / 16;
        for (int w = 0; w < u; ++w) {
            for (int x = 0; x < v; ++x) {
                int light;
                float y = f + (float)((w + 1) * 16);
                float z = f + (float)(w * 16);
                float aa = g + (float)((x + 1) * 16);
                float ab = g + (float)(x * 16);
                if (emissive) {
                    light = 0xF000F2;
                } else {
                    float divider = 16.0f;
                    int ac = entity.m_146903_();
                    int ad = Mth.m_14107_((double)(entity.m_20186_() + (double)((aa + ab) / 2.0f / divider)));
                    int ae = entity.m_146907_();
                    Direction direction = entity.m_6350_();
                    if (direction == Direction.NORTH) {
                        ac = Mth.m_14107_((double)(entity.m_20185_() + (double)((y + z) / 2.0f / divider)));
                    }
                    if (direction == Direction.WEST) {
                        ae = Mth.m_14107_((double)(entity.m_20189_() - (double)((y + z) / 2.0f / divider)));
                    }
                    if (direction == Direction.SOUTH) {
                        ac = Mth.m_14107_((double)(entity.m_20185_() - (double)((y + z) / 2.0f / divider)));
                    }
                    if (direction == Direction.EAST) {
                        ae = Mth.m_14107_((double)(entity.m_20189_() + (double)((y + z) / 2.0f / divider)));
                    }
                    light = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)new BlockPos(ac, ad, ae));
                }
                float zConst = 0.5f;
                this.uVertex(entry, vertexConsumerBack, y, aa, j, k, zConst, 0, 0, 1, light);
                this.uVertex(entry, vertexConsumerBack, z, aa, i, k, zConst, 0, 0, 1, light);
                this.uVertex(entry, vertexConsumerBack, z, ab, i, l, zConst, 0, 0, 1, light);
                this.uVertex(entry, vertexConsumerBack, y, ab, j, l, zConst, 0, 0, 1, light);
                this.uVertex(entry, vertexConsumerBack, y, aa, m, o, -zConst, 0, 1, 0, light);
                this.uVertex(entry, vertexConsumerBack, z, aa, n, o, -zConst, 0, 1, 0, light);
                this.uVertex(entry, vertexConsumerBack, z, aa, n, p, zConst, 0, 1, 0, light);
                this.uVertex(entry, vertexConsumerBack, y, aa, m, p, zConst, 0, 1, 0, light);
                this.uVertex(entry, vertexConsumerBack, y, ab, m, o, zConst, 0, -1, 0, light);
                this.uVertex(entry, vertexConsumerBack, z, ab, n, o, zConst, 0, -1, 0, light);
                this.uVertex(entry, vertexConsumerBack, z, ab, n, p, -zConst, 0, -1, 0, light);
                this.uVertex(entry, vertexConsumerBack, y, ab, m, p, -zConst, 0, -1, 0, light);
                this.uVertex(entry, vertexConsumerBack, y, aa, r, s, zConst, -1, 0, 0, light);
                this.uVertex(entry, vertexConsumerBack, y, ab, r, t, zConst, -1, 0, 0, light);
                this.uVertex(entry, vertexConsumerBack, y, ab, q, t, -zConst, -1, 0, 0, light);
                this.uVertex(entry, vertexConsumerBack, y, aa, q, s, -zConst, -1, 0, 0, light);
                this.uVertex(entry, vertexConsumerBack, z, aa, r, s, -zConst, 1, 0, 0, light);
                this.uVertex(entry, vertexConsumerBack, z, ab, r, t, -zConst, 1, 0, 0, light);
                this.uVertex(entry, vertexConsumerBack, z, ab, q, t, zConst, 1, 0, 0, light);
                this.uVertex(entry, vertexConsumerBack, z, aa, q, s, zConst, 1, 0, 0, light);
            }
        }
    }
}

