/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ResourceSink {
    private final String modId;
    private final String packId;
    final Map<ResourceLocation, byte[]> resources = new HashMap<ResourceLocation, byte[]>();
    final Set<ResourceLocation> notClearable = new HashSet<ResourceLocation>();
    final Map<TagKey<?>, SimpleTagBuilder> tags = new HashMap();

    public ResourceSink(String modId, String packId) {
        this.modId = modId;
        this.packId = packId;
    }

    protected void addBytes(ResourceLocation id, byte[] bytes) {
        this.resources.put(id, (byte[])Preconditions.checkNotNull((Object)bytes));
    }

    public void addResource(StaticResource resource) {
        this.addBytes(resource.location, resource.data);
    }

    private void addJson(ResourceLocation path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            Moonlight.LOGGER.error("Failed to write JSON {} to resource pack.", (Object)path, (Object)e);
        }
    }

    public void addJson(ResourceLocation location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    public void addBytes(ResourceLocation location, byte[] bytes, ResType resType) {
        this.addBytes(resType.getPath(location), bytes);
    }

    @Deprecated(forRemoval=true)
    public void addAndCloseTexture(ResourceLocation path, TextureImage image) {
        this.addAndCloseTexture(path, image, true);
    }

    @Deprecated(forRemoval=true)
    public void addAndCloseTexture(ResourceLocation path, TextureImage image, boolean isOnAtlas) {
        try (TextureImage textureImage = image;){
            this.addTexture(path, image, isOnAtlas);
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to add image {} to resource pack {}.", (Object)path, (Object)this, (Object)e);
        }
    }

    public void addAndCloseTexture(ResourceLocation path, Supplier<TextureImage> image) {
        try (TextureImage img = image.get();){
            this.addTexture(path, img);
        }
    }

    public void addTexture(ResourceLocation path, TextureImage image) {
        this.addTexture(path, image, true);
    }

    public void addTexture(ResourceLocation path, TextureImage texture, boolean isOnAtlas) {
        try {
            NativeImage image = texture.getImage();
            if (!texture.isAllocated()) {
                Moonlight.crashIfInDev("Tried to save a non allocated texture image at " + String.valueOf(path) + " \nDid you close it too early?");
                return;
            }
            this.addBytes(path, image.m_85121_(), ResType.TEXTURES);
            if (!isOnAtlas) {
                this.markNotClearable(ResType.TEXTURES.getPath(path));
            }
            if (texture.getMcMeta() != null) {
                this.addJson(path, (JsonElement)texture.getMcMeta().toJson(), ResType.MCMETA);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void markNotClearable(ResourceLocation path) {
        this.notClearable.add(path);
    }

    public void addBlockModel(ResourceLocation modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCK_MODELS);
    }

    public void addItemModel(ResourceLocation modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.ITEM_MODELS);
    }

    public void addBlockState(ResourceLocation modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCKSTATES);
    }

    public void addLang(ResourceLocation langName, JsonElement language) {
        this.addJson(langName, language, ResType.LANG);
    }

    public void addLang(ResourceLocation langName, LangBuilder builder) {
        this.addJson(langName, builder.build(), ResType.LANG);
    }

    public void addTag(SimpleTagBuilder builder, ResourceKey<?> type) {
        this.tags.merge(TagKey.m_203882_(type, (ResourceLocation)builder.getId()), builder, SimpleTagBuilder::merge);
    }

    public void addSimpleBlockLootTable(Block block) {
        this.addLootTable(block, ResourceSink.createSingleItemTable((ItemLike)block).m_79165_(LootContextParamSets.f_81421_));
    }

    public void addLootTable(Block block, LootTable.Builder table) {
        this.addLootTable(block.m_60589_(), table.m_79167_());
    }

    public void addLootTable(ResourceLocation id, LootTable table) {
        this.addJson(id, LootDataType.f_278413_.m_278857_().toJsonTree((Object)table), ResType.LOOT_TABLES);
    }

    protected static LootTable.Builder createSingleItemTable(ItemLike itemLike) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)itemLike)).m_79073_());
    }

    public void addRecipe(FinishedRecipe recipe) {
        this.addJson(recipe.m_6445_(), (JsonElement)recipe.m_125966_(), ResType.RECIPES);
        ResourceLocation advancementId = recipe.m_6448_();
        if (advancementId != null) {
            this.addJson(recipe.m_6448_(), (JsonElement)recipe.m_5860_(), ResType.ADVANCEMENTS);
        }
    }

    public void addRecipeNoAdvancement(FinishedRecipe recipe) {
        this.addJson(recipe.m_6445_(), (JsonElement)recipe.m_125966_(), ResType.RECIPES);
    }

    public void addResourceIfNotPresent(ResourceManager manager, StaticResource resource) {
        if (!this.alreadyHasAssetAtLocation(manager, resource.location)) {
            this.addResource(resource);
        }
    }

    public boolean alreadyHasTextureAtLocation(ResourceManager manager, ResourceLocation res) {
        return this.alreadyHasAssetAtLocation(manager, res, ResType.TEXTURES);
    }

    public void addTextureIfNotPresent(ResourceManager manager, String relativePath, Supplier<TextureImage> textureSupplier) {
        this.addTextureIfNotPresent(manager, relativePath, textureSupplier, true);
    }

    public void addTextureIfNotPresent(ResourceManager manager, String relativePath, Supplier<TextureImage> textureSupplier, boolean isOnAtlas) {
        ResourceLocation res;
        ResourceLocation resourceLocation = res = relativePath.contains(":") ? new ResourceLocation(relativePath) : new ResourceLocation(this.modId, relativePath);
        if (!this.alreadyHasTextureAtLocation(manager, res)) {
            try (TextureImage textureImage = textureSupplier.get();){
                this.addTexture(res, textureImage, isOnAtlas);
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("Failed to generate texture {}: {}", (Object)res, (Object)e);
            }
        }
    }

    public boolean alreadyHasAssetAtLocation(ResourceManager manager, ResourceLocation res, ResType type) {
        return this.alreadyHasAssetAtLocation(manager, type.getPath(res));
    }

    public boolean alreadyHasAssetAtLocation(ResourceManager manager, ResourceLocation res) {
        Optional resource = manager.m_213713_(res);
        return resource.filter(value -> !value.m_215506_().equals(this.packId)).isPresent();
    }

    public void addSimilarJsonResource(ResourceManager manager, StaticResource resource, String keyword, String replaceWith) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, s -> s.replace(keyword, replaceWith));
    }

    public void addSimilarJsonResource(ResourceManager manager, StaticResource resource, Function<String, String> textTransform) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, textTransform, textTransform);
    }

    public void addSimilarJsonResource(ResourceManager manager, StaticResource resource, Function<String, String> textTransform, Function<String, String> pathTransform) throws NoSuchElementException {
        ResourceLocation fullPath = resource.location;
        StringBuilder builder = new StringBuilder();
        String[] partial = fullPath.m_135815_().split("/");
        for (int i = 0; i < partial.length; ++i) {
            if (i != 0) {
                builder.append("/");
            }
            if (i == partial.length - 1) {
                builder.append(pathTransform.apply(partial[i]));
                continue;
            }
            builder.append(partial[i]);
        }
        ResourceLocation newRes = new ResourceLocation(this.modId, builder.toString());
        if (!this.alreadyHasAssetAtLocation(manager, newRes)) {
            String fullText = resource.asString();
            fullText = textTransform.apply(fullText);
            this.addBytes(newRes, fullText.getBytes());
        }
    }

    public void copyResource(ResourceManager manager, ResourceLocation from, ResourceLocation to, boolean lenient) {
        Optional resource = manager.m_213713_(from);
        if (resource.isPresent()) {
            StaticResource s = StaticResource.of((Resource)resource.get(), from);
            this.addBytes(to, s.data);
        } else if (lenient) {
            Moonlight.LOGGER.info("Resource {} not found for copying to {}", (Object)from, (Object)to);
        } else {
            throw new NoSuchElementException("Resource " + String.valueOf(from) + " not found for copying to " + String.valueOf(to));
        }
    }

    public void appendModelOverride(ResourceManager manager, ResourceLocation modelRes, Consumer<RPUtils.OverrideAppender> modelConsumer) {
        JsonElement json = RPUtils.makeModelOverride(manager, modelRes, modelConsumer);
        this.addItemModel(modelRes, json);
    }
}

