/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.api.helpers;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import org.embeddedt.modernfix.duck.IExtendedModelBakery;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.embeddedt.modernfix.util.DynamicMap;
import org.jetbrains.annotations.Nullable;

public final class ModelHelpers {
    public static ImmutableList<BlockState> getBlockStateForLocation(ModelResourceLocation location) {
        Optional blockOpt = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(location.m_135827_(), location.m_135815_()));
        if (blockOpt.isPresent()) {
            return ModelBakeryHelpers.getBlockStatesForMRL((StateDefinition<Block, BlockState>)((Block)blockOpt.get()).m_49965_(), location);
        }
        return ImmutableList.of();
    }

    public static ImmutableList<BlockState> getBlockStateForLocation(StateDefinition<Block, BlockState> definition, ModelResourceLocation location) {
        return ModelBakeryHelpers.getBlockStatesForMRL(definition, location);
    }

    public static Map<ResourceLocation, BakedModel> createFakeTopLevelMap(BiFunction<ResourceLocation, ModelState, BakedModel> modelGetter) {
        return new DynamicMap<ResourceLocation, BakedModel>(location -> (BakedModel)modelGetter.apply((ResourceLocation)location, (ModelState)BlockModelRotation.X0_Y0));
    }

    public static ModelBaker adaptBakery(final ModelBakery bakery) {
        return new ModelBaker(){

            public UnbakedModel m_245361_(ResourceLocation resourceLocation) {
                return bakery.m_119341_(resourceLocation);
            }

            @Nullable
            public BakedModel m_245240_(ResourceLocation resourceLocation, ModelState modelState) {
                return ((IExtendedModelBakery)bakery).bakeDefault(resourceLocation, modelState);
            }

            @Nullable
            public BakedModel bake(ResourceLocation location, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
                throw new UnsupportedOperationException();
            }

            public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
                return Material::m_119204_;
            }
        };
    }
}

