/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.compact_mojang_registries;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.datafix.fixes.BlockStateData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockStateData.class}, priority=2000)
public class BlockStateDataMixin {
    @Unique
    private static ObjectOpenHashSet<Tag> TAG_INTERNER;

    @ModifyExpressionValue(method={"parse"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/TagParser;parseTag(Ljava/lang/String;)Lnet/minecraft/nbt/CompoundTag;")})
    private static CompoundTag compactTag(CompoundTag tag) {
        if (TAG_INTERNER == null) {
            TAG_INTERNER = new ObjectOpenHashSet();
        }
        Map.Entry[] entries = new Map.Entry[tag.m_128440_()];
        int i = 0;
        for (String key : tag.m_128431_()) {
            Tag t = tag.m_128423_(key);
            if (t instanceof CompoundTag) {
                CompoundTag ct = (CompoundTag)t;
                t = BlockStateDataMixin.compactTag(ct);
            }
            t = (Tag)TAG_INTERNER.addOrGet((Object)t);
            entries[i++] = Map.entry(key, t);
        }
        return new CompoundTag(Map.ofEntries(entries));
    }

    @Inject(method={"<clinit>"}, at={@At(value="RETURN")})
    private static void clearInterner(CallbackInfo ci) {
        if (TAG_INTERNER != null) {
            TAG_INTERNER.clear();
            TAG_INTERNER.trim();
        }
    }
}

