/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.resourcefullib_highlight_deduplication;

import com.teamresourceful.resourcefullib.client.highlights.HighlightHandler;
import com.teamresourceful.resourcefullib.client.highlights.base.Highlight;
import com.teamresourceful.resourcefullib.client.highlights.base.HighlightLine;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HighlightHandler.class})
@RequiresMod(value="resourcefullib")
@ClientOnlyMixin
public class HighlightHandlerMixin {
    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="RETURN")}, remap=false)
    private void deduplicateHighlights(CallbackInfo ci) {
        HashMap stateCache;
        try {
            HashMap hashMap;
            Field stateCacheMap = this.getClass().getDeclaredField("STATE_CACHE");
            Object object = stateCacheMap.get(null);
            if (!(object instanceof HashMap)) {
                throw new ReflectiveOperationException("Unexpected map type");
            }
            stateCache = hashMap = (HashMap)object;
        }
        catch (ReflectiveOperationException e) {
            ModernFix.LOGGER.error("Not applying Resourceful Lib patch due to reflection error", (Throwable)e);
            return;
        }
        ObjectOpenHashSet pointCache = new ObjectOpenHashSet();
        ObjectOpenHashSet lineCache = new ObjectOpenHashSet();
        ObjectOpenHashSet listCache = new ObjectOpenHashSet();
        Function<HighlightLine, HighlightLine> deduplicator = l -> {
            if (!lineCache.contains(l)) {
                l = new HighlightLine((Vector3f)pointCache.addOrGet((Object)l.start()), (Vector3f)pointCache.addOrGet((Object)l.end()), (Vector3f)pointCache.addOrGet((Object)l.normal()));
            }
            return (HighlightLine)lineCache.addOrGet(l);
        };
        stateCache.replaceAll((rl, highlight) -> {
            if (highlight == null) {
                return null;
            }
            List newList = highlight.lines();
            if (!listCache.contains((Object)newList)) {
                newList = newList.stream().map(deduplicator).toList();
            }
            return new Highlight(highlight.id(), (List)listCache.addOrGet(newList));
        });
        ModernFix.LOGGER.info("Deduplicated ResourcefulLib highlights ({} points, {} lines)", (Object)pointCache.size(), (Object)lineCache.size());
    }
}

