/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.collect.ImmutableSet;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.duck.IExtendedModelBakery;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBakedModelProvider
implements Map<ResourceLocation, BakedModel> {
    private static final ImmutableSet<ResourceLocation> BAKE_SKIPPED_TOPLEVEL = ImmutableSet.builder().add((Object)new ResourceLocation("custommachinery", "block/custom_machine_block")).build();
    public static DynamicBakedModelProvider currentInstance = null;
    private final ModelBakery bakery;
    private final Map<ModelBakery.BakedCacheKey, BakedModel> bakedCache;
    private final Map<ResourceLocation, BakedModel> permanentOverrides;
    private BakedModel missingModel;
    private static final BakedModel SENTINEL = new BakedModel(){

        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
            return null;
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7547_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return null;
        }

        public ItemTransforms m_7442_() {
            return null;
        }

        public ItemOverrides m_7343_() {
            return null;
        }
    };

    public DynamicBakedModelProvider(ModelBakery bakery, Map<ModelBakery.BakedCacheKey, BakedModel> cache) {
        this.bakery = bakery;
        this.bakedCache = cache;
        this.permanentOverrides = Collections.synchronizedMap(new Object2ObjectOpenHashMap());
        if (currentInstance == null) {
            currentInstance = this;
        }
    }

    private static ModelBakery.BakedCacheKey vanillaKey(Object o) {
        return new ModelBakery.BakedCacheKey((ResourceLocation)o, BlockModelRotation.X0_Y0.m_6189_(), false);
    }

    @Override
    public int size() {
        return this.bakedCache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bakedCache.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.permanentOverrides.getOrDefault(o, SENTINEL) != null;
    }

    @Override
    public boolean containsValue(Object o) {
        return this.permanentOverrides.containsValue(o) || this.bakedCache.containsValue(o);
    }

    private static boolean isVanillaTopLevelModel(ResourceLocation location) {
        if (location instanceof ModelResourceLocation) {
            try {
                ModelResourceLocation mrl = (ModelResourceLocation)location;
                ResourceLocation registryKey = new ResourceLocation(mrl.m_135827_(), mrl.m_135815_());
                if (mrl.m_119448_().equals("inventory") && BuiltInRegistries.f_257033_.m_7804_(registryKey)) {
                    return true;
                }
                Optional blockOpt = BuiltInRegistries.f_256975_.m_6612_(registryKey);
                if (blockOpt.isPresent()) {
                    return ModelBakeryHelpers.getBlockStatesForMRL((StateDefinition<Block, BlockState>)((Block)blockOpt.get()).m_49965_(), mrl).size() > 0;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return location.m_135827_().equals("minecraft") && location.m_135815_().equals("builtin/missing");
    }

    private BakedModel getMissingModel() {
        BakedModel m = this.missingModel;
        if (m == null) {
            m = this.missingModel = ((IExtendedModelBakery)this.bakery).bakeDefault((ResourceLocation)ModelBakery.f_119230_, (ModelState)BlockModelRotation.X0_Y0);
        }
        return m;
    }

    @Override
    public BakedModel get(Object o) {
        if (o == null) {
            return null;
        }
        BakedModel model = this.permanentOverrides.getOrDefault(o, SENTINEL);
        if (model != SENTINEL) {
            return model;
        }
        try {
            model = BAKE_SKIPPED_TOPLEVEL.contains((Object)((ResourceLocation)o)) ? this.getMissingModel() : ((IExtendedModelBakery)this.bakery).bakeDefault((ResourceLocation)o, (ModelState)BlockModelRotation.X0_Y0);
        }
        catch (RuntimeException e) {
            ModernFix.LOGGER.error("Exception baking {}: {}", o, (Object)e);
            model = this.getMissingModel();
        }
        if (model == this.getMissingModel()) {
            model = DynamicBakedModelProvider.isVanillaTopLevelModel((ResourceLocation)o) ? model : null;
            this.permanentOverrides.put((ResourceLocation)o, model);
        }
        return model;
    }

    @Override
    public BakedModel put(ResourceLocation resourceLocation, BakedModel bakedModel) {
        BakedModel m = this.permanentOverrides.put(resourceLocation, bakedModel);
        if (m != null) {
            return m;
        }
        return this.bakedCache.get(DynamicBakedModelProvider.vanillaKey(resourceLocation));
    }

    @Override
    public BakedModel remove(Object o) {
        BakedModel m = this.permanentOverrides.remove(o);
        if (m != null) {
            return m;
        }
        return this.bakedCache.remove(DynamicBakedModelProvider.vanillaKey(o));
    }

    @Override
    public void putAll(@NotNull Map<? extends ResourceLocation, ? extends BakedModel> map) {
        this.permanentOverrides.putAll(map);
    }

    @Override
    public void clear() {
        if (!ModernFixPlatformHooks.INSTANCE.isDevEnv()) {
            throw new UnsupportedOperationException();
        }
        ModernFix.LOGGER.warn("Clearing model registry");
        this.permanentOverrides.clear();
        this.bakedCache.clear();
        ((IExtendedModelBakery)this.bakery).mfix$clearModels();
    }

    @Override
    @NotNull
    public Set<ResourceLocation> keySet() {
        return this.bakedCache.keySet().stream().map(ModelBakery.BakedCacheKey::f_243934_).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<BakedModel> values() {
        return this.bakedCache.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<ResourceLocation, BakedModel>> entrySet() {
        return this.bakedCache.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<ResourceLocation, BakedModel>(((ModelBakery.BakedCacheKey)entry.getKey()).f_243934_(), (BakedModel)entry.getValue())).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public BakedModel replace(ResourceLocation key, BakedModel value) {
        BakedModel existingOverride = this.permanentOverrides.get(key);
        if (existingOverride == null) {
            return this.put(key, value);
        }
        return existingOverride;
    }

    @Override
    public void replaceAll(BiFunction<? super ResourceLocation, ? super BakedModel, ? extends BakedModel> function) {
        Set<ResourceLocation> overridenLocations = this.permanentOverrides.keySet();
        this.permanentOverrides.replaceAll(function);
        boolean uvLock = BlockModelRotation.X0_Y0.m_7538_();
        Transformation rotation = BlockModelRotation.X0_Y0.m_6189_();
        this.bakedCache.replaceAll((? super K loc, ? super V oldModel) -> {
            if (loc.f_243798_() != rotation || loc.f_243915_() != uvLock || overridenLocations.contains(loc.f_243934_())) {
                return oldModel;
            }
            return (BakedModel)function.apply((ResourceLocation)loc.f_243934_(), (BakedModel)oldModel);
        });
    }
}

