/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.capability;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.embeddedt.modernfix.ModernFix;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class CapabilityProviderDispatcherGenerator {
    private static final ConcurrentHashMap<List<Class<? extends ICapabilityProvider>>, MethodHandle> cache = new ConcurrentHashMap();
    private static final AtomicInteger classCounter = new AtomicInteger(0);
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static final String ICAP_PROVIDER_DESC = "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;";
    private static final String CAPABILITY_DESC = "Lnet/minecraftforge/common/capabilities/Capability;";
    private static final String LAZY_OPTIONAL_DESC = "Lnet/minecraftforge/common/util/LazyOptional;";
    private static final String DIRECTION_DESC = "Lnet/minecraft/core/Direction;";

    private static MethodHandle getOrGenerateConstructor(List<Class<? extends ICapabilityProvider>> providerTypes) {
        return cache.computeIfAbsent(providerTypes, CapabilityProviderDispatcherGenerator::generateClass);
    }

    private static MethodHandle getOrGenerateConstructor(ICapabilityProvider[] providers) {
        List<Class<? extends ICapabilityProvider>> types = Arrays.stream(providers).map(ICapabilityProvider::getClass).toList();
        return CapabilityProviderDispatcherGenerator.getOrGenerateConstructor(types);
    }

    public static ICapabilityProvider getOrGenerateDispatcher(ICapabilityProvider[] providers) {
        MethodHandle handle = CapabilityProviderDispatcherGenerator.getOrGenerateConstructor(providers);
        try {
            return handle.invokeExact(providers);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error constructing dispatcher", e);
        }
    }

    private static MethodHandle generateClass(List<Class<? extends ICapabilityProvider>> providerTypes) {
        ModernFix.LOGGER.debug("Generating capability dispatcher for types: [{}]", (Object)providerTypes.stream().map(Class::getName).collect(Collectors.joining(", ")));
        try {
            String className = "org.embeddedt.modernfix.forge.capability.CapabilityDispatcher$Generated$" + classCounter.incrementAndGet();
            byte[] classBytes = CapabilityProviderDispatcherGenerator.generateClassBytes(className, providerTypes);
            MethodHandles.Lookup hiddenLookup = lookup.defineHiddenClass(classBytes, true, MethodHandles.Lookup.ClassOption.NESTMATE);
            return hiddenLookup.findConstructor(hiddenLookup.lookupClass(), MethodType.methodType(Void.TYPE, ICapabilityProvider[].class)).asType(MethodType.methodType(ICapabilityProvider.class, Object.class));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate capability dispatcher class", e);
        }
    }

    private static byte[] generateClassBytes(String className, List<Class<? extends ICapabilityProvider>> providerTypes) {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(61, 49, className.replace('.', '/'), null, "java/lang/Object", new String[]{"net/minecraftforge/common/capabilities/ICapabilityProvider"});
        for (int i = 0; i < providerTypes.size(); ++i) {
            cw.visitField(18, "provider" + i, ICAP_PROVIDER_DESC, null, null).visitEnd();
        }
        CapabilityProviderDispatcherGenerator.generateConstructor(cw, className, providerTypes.size());
        CapabilityProviderDispatcherGenerator.generateGetCapabilityMethod(cw, className, providerTypes.size());
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static void generateConstructor(ClassWriter cw, String className, int providerCount) {
        Method constructor = Method.getMethod((String)"void <init>(net.minecraftforge.common.capabilities.ICapabilityProvider[])");
        GeneratorAdapter mg = new GeneratorAdapter(1, constructor, null, null, (ClassVisitor)cw);
        mg.loadThis();
        mg.invokeConstructor(Type.getType(Object.class), Method.getMethod((String)"void <init>()"));
        for (int i = 0; i < providerCount; ++i) {
            mg.loadThis();
            mg.loadArg(0);
            mg.push(i);
            mg.arrayLoad(Type.getType((String)ICAP_PROVIDER_DESC));
            mg.putField(Type.getObjectType((String)className.replace('.', '/')), "provider" + i, Type.getType((String)ICAP_PROVIDER_DESC));
        }
        mg.returnValue();
        mg.endMethod();
    }

    private static void generateGetCapabilityMethod(ClassWriter cw, String className, int providerCount) {
        MethodVisitor mv = cw.visitMethod(1, "getCapability", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/core/Direction;)Lnet/minecraftforge/common/util/LazyOptional;", "<T:Ljava/lang/Object;>(" + CAPABILITY_DESC.replace(";", "<TT;>;") + "Lnet/minecraft/core/Direction;)" + LAZY_OPTIONAL_DESC.replace(";", "<TT;>;"), null);
        mv.visitCode();
        Label endLabel = new Label();
        for (int i = 0; i < providerCount; ++i) {
            Label nextLabel = new Label();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className.replace('.', '/'), "provider" + i, ICAP_PROVIDER_DESC);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "net/minecraftforge/common/capabilities/ICapabilityProvider", "getCapability", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/core/Direction;)Lnet/minecraftforge/common/util/LazyOptional;", true);
            mv.visitVarInsn(58, 3);
            mv.visitVarInsn(25, 3);
            mv.visitJumpInsn(198, nextLabel);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(182, "net/minecraftforge/common/util/LazyOptional", "isPresent", "()Z", false);
            mv.visitJumpInsn(153, nextLabel);
            mv.visitVarInsn(25, 3);
            mv.visitInsn(176);
            mv.visitLabel(nextLabel);
            if (i >= providerCount - 1) continue;
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv.visitLabel(endLabel);
        mv.visitMethodInsn(184, "net/minecraftforge/common/util/LazyOptional", "empty", "()Lnet/minecraftforge/common/util/LazyOptional;", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public static ICapabilityProvider createDispatcher(ICapabilityProvider[] providers) {
        try {
            MethodHandle constructor = CapabilityProviderDispatcherGenerator.getOrGenerateConstructor(providers);
            return constructor.invoke(providers);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to create capability dispatcher instance", e);
        }
    }

    public static void clearCache() {
        cache.clear();
    }

    public static int getCacheSize() {
        return cache.size();
    }
}

