/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.load;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.embeddedt.modernfix.ModernFix;
import org.objectweb.asm.Type;

public class ModFileScanDataCompactor {
    private static final Field ANNOTATIONS_FIELD;
    private static final Field CLASSES_FIELD;
    private static final ObjectOpenHashSet<Type> TYPES;

    private static Field tryGetField(String name) {
        try {
            Field f = ModFileScanData.class.getDeclaredField(name);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            ModernFix.LOGGER.error("Unable to access '{}' field on ModFileScanData", (Object)name, (Object)e);
            return null;
        }
    }

    public static void compact() {
        for (IModFileInfo file : ModList.get().getModFiles()) {
            ModFileScanData scanResult = file.getFile().getScanResult();
            try {
                ModFileScanDataCompactor.compact(scanResult, file.getFile().getFileName());
            }
            catch (Throwable e) {
                ModernFix.LOGGER.error("An error occured while compacting {}", (Object)file.getFile().getFileName(), (Object)e);
            }
        }
        TYPES.clear();
        TYPES.trim();
    }

    private static void compact(ModFileScanData data, String fileName) {
        ObjectOpenHashSet memberNames = new ObjectOpenHashSet();
        ImmutableSet annotationSet = (ImmutableSet)data.getAnnotations().stream().filter(a -> {
            String clzName = a.annotationType().getClassName();
            return !clzName.startsWith("kotlin.jvm.") && !clzName.startsWith("scala.reflect.") && !clzName.startsWith("org.spongepowered.asm.mixin.") && !clzName.startsWith("com.llamalad7.mixinextras.") && !clzName.contains("org.jetbrains.annotations.") && !clzName.contains("javax.annotation.") && !clzName.endsWith("kotlin.Metadata") && !clzName.equals("net.minecraftforge.api.distmarker.OnlyIn");
        }).map(a -> new ModFileScanData.AnnotationData((Type)TYPES.addOrGet((Object)a.annotationType()), a.targetType(), (Type)TYPES.addOrGet((Object)a.clazz()), (String)memberNames.addOrGet((Object)a.memberName()), a.annotationData().entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> {
            Object annValue = e.getValue();
            if (annValue instanceof ArrayList) {
                ArrayList list = (ArrayList)annValue;
                list.trimToSize();
            }
            return annValue;
        })))).collect(ImmutableSet.toImmutableSet());
        if (annotationSet.size() < data.getAnnotations().size()) {
            ModernFix.LOGGER.debug("Removed {} unneeded annotations from file {}", (Object)(data.getAnnotations().size() - annotationSet.size()), (Object)fileName);
        }
        ImmutableSet classSet = (ImmutableSet)data.getClasses().stream().map(c -> new ModFileScanData.ClassData((Type)TYPES.addOrGet((Object)c.clazz()), (Type)TYPES.addOrGet((Object)c.parent()), (Set)c.interfaces().stream().map(arg_0 -> TYPES.addOrGet(arg_0)).collect(ImmutableSet.toImmutableSet()))).collect(ImmutableSet.toImmutableSet());
        try {
            ANNOTATIONS_FIELD.set(data, annotationSet);
            CLASSES_FIELD.set(data, classSet);
        }
        catch (Exception e) {
            ModernFix.LOGGER.error("Error replacing fields on ModFileScanData", (Throwable)e);
        }
    }

    static {
        TYPES = new ObjectOpenHashSet();
        ANNOTATIONS_FIELD = ModFileScanDataCompactor.tryGetField("annotations");
        CLASSES_FIELD = ModFileScanDataCompactor.tryGetField("classes");
    }
}

