/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.network.ClientBoundPlaySplashParticlesMessage;
import net.mehvahdjukaar.amendments.common.network.ModNetwork;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipeUtils;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemsCraftResult;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronConversion;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.misc.InvPlacer;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class CommonCauldronCode {
    public static void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, Supplier<Double> heightProvider) {
        boolean shouldCheckFluid;
        boolean canFluidExtinguish = true;
        boolean bl = shouldCheckFluid = !entity.f_19798_ || entity.m_6060_();
        if (shouldCheckFluid && CommonCauldronCode.getFluidOrWater(state, pos, (LevelAccessor)level).is(ModTags.CANT_EXTINGUISH)) {
            canFluidExtinguish = false;
        }
        if (canFluidExtinguish) {
            entity.f_19798_ = true;
        }
        if (level.f_46443_) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)ModCauldronBlock.BOILING)).booleanValue() && entity instanceof LivingEntity) {
            entity.m_6469_(new DamageSource(ModRegistry.BOILING_DAMAGE), 1.0f);
        }
        if (entity.m_6060_() && canFluidExtinguish) {
            CommonCauldronCode.playExtinguishSound(level, pos, entity);
            if (!(state.m_60734_() instanceof LayeredCauldronBlock)) {
                CommonCauldronCode.extinguishLikeSuperLayeredCauldron(level, pos, entity);
            }
        }
        CommonCauldronCode.attemptInWorldCrafting(state, level, pos, entity, heightProvider);
    }

    private static void extinguishLikeSuperLayeredCauldron(Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        entity.m_20095_();
        if (entity.m_142265_(level, pos) && (blockEntity = level.m_7702_(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            te.consumeOneLayer();
            level.m_142346_(entity, GameEvent.f_157792_, pos);
        }
    }

    private static void playExtinguishSound(Level level, BlockPos pos, Entity entity) {
        level.m_5594_(null, pos, SoundEvents.f_11914_, entity.m_5720_(), 0.7f, 1.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
    }

    public static BlockState updateBoilingState(Direction direction, BlockState neighborState, LevelAccessor level, BlockPos neighborPos, BlockState newState, BlockPos currentPos) {
        if (direction == Direction.DOWN) {
            SoftFluidStack fluidStack = CommonCauldronCode.getFluidOrWater(newState, currentPos, level);
            boolean isFire = CommonCauldronCode.shouldBoil(neighborState, fluidStack, level, neighborPos);
            newState = (BlockState)newState.m_61124_((Property)ModCauldronBlock.BOILING, (Comparable)Boolean.valueOf(isFire));
        }
        return newState;
    }

    private static SoftFluidStack getFluidOrWater(BlockState newState, BlockPos pos, LevelAccessor level) {
        BlockEntity blockEntity;
        if (newState.m_60734_() instanceof ModCauldronBlock && (blockEntity = level.m_7702_(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            return te.getSoftFluidTank().getFluid();
        }
        return SoftFluidStack.of((Holder)BuiltInSoftFluids.WATER.getHolder(), (int)((Integer)newState.m_61143_((Property)LayeredCauldronBlock.f_153514_)));
    }

    public static boolean shouldBoil(BlockState belowState, SoftFluidStack fluid, LevelAccessor level, BlockPos pos) {
        if (!belowState.m_204336_(ModTags.HEAT_SOURCES) || fluid.is(ModTags.CANT_BOIL)) {
            return false;
        }
        if (belowState.m_61138_((Property)CampfireBlock.f_51227_)) {
            return (Boolean)belowState.m_61143_((Property)CampfireBlock.f_51227_);
        }
        Block block = belowState.m_60734_();
        if (block instanceof ILightable) {
            ILightable il = (ILightable)block;
            return il.isLitUp(belowState, (BlockGetter)level, pos);
        }
        return true;
    }

    public static void onEntityFallOnContent(Level level, BlockState state, Entity entity, double height) {
        if (entity instanceof ItemEntity) {
            ItemEntity ie = (ItemEntity)entity;
            ie.m_32060_();
        }
        if (!level.f_46443_) {
            CommonCauldronCode.playSplashEffects(entity, height);
        }
    }

    public static void playBubblingAnimation(Level level, BlockPos pos, double surface, RandomSource rand, int color, int light) {
        SimpleParticleType type = (SimpleParticleType)ModRegistry.BOILING_PARTICLE.get();
        int count = 2;
        CommonCauldronCode.addSurfaceParticles((ParticleOptions)type, level, pos, count, surface, rand, color, (float)pos.m_123342_() + 0.3125f, light);
        if (level.f_46441_.m_188503_(4) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11774_, SoundSource.BLOCKS, 0.4f + level.f_46441_.m_188501_() * 0.2f, 0.35f + level.f_46441_.m_188501_() * 0.2f, false);
        }
    }

    public static void addSurfaceParticles(ParticleOptions type, Level level, BlockPos pos, int count, double surface, RandomSource rand, float r, float g, float b) {
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.m_123341_() + 0.1875 + (double)rand.m_188501_() * 0.625;
            double y = (double)pos.m_123342_() + surface;
            double z = (double)pos.m_123343_() + 0.1875 + (double)rand.m_188501_() * 0.625;
            level.m_7106_(type, x, y, z, (double)r, (double)g, (double)b);
        }
    }

    public static void playSplashEffects(Entity entity, double waterHeight) {
        entity.m_146850_(GameEvent.f_157784_);
        Level level = entity.m_9236_();
        Entity feetEntity = entity.m_20160_() && entity.m_6688_() != null ? entity.m_6688_() : entity;
        float offset = feetEntity == entity ? 0.2f : 0.9f;
        Vec3 movement = feetEntity.m_20184_();
        float speed = Math.min(1.0f, (float)Math.sqrt(movement.f_82479_ * movement.f_82479_ * 0.2 + movement.f_82480_ * movement.f_82480_ + movement.f_82481_ * movement.f_82481_ * 0.2) * offset);
        BlockPos pos = BlockPos.m_274446_((Position)entity.m_20182_());
        Vec3 hitPos = new Vec3(entity.m_20185_(), (double)pos.m_123342_() + waterHeight, entity.m_20189_());
        RandomSource rand = level.f_46441_;
        if (speed < 0.25f) {
            level.m_6263_(null, hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_(), entity.m_5509_(), entity.m_5720_(), speed, 1.0f + (rand.m_188501_() - rand.m_188501_()) * 0.4f);
        } else {
            level.m_6263_(null, hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_(), entity.m_5508_(), entity.m_5720_(), speed, 1.0f + (rand.m_188501_() - rand.m_188501_()) * 0.4f);
        }
        ClientBoundPlaySplashParticlesMessage particlePacket = new ClientBoundPlaySplashParticlesMessage(hitPos, speed, feetEntity.m_20205_());
        ModNetwork.CHANNEL.sentToAllClientPlayersTrackingEntityAndSelf(entity, (Message)particlePacket);
    }

    private static void attemptInWorldCrafting(BlockState state, Level level, BlockPos pos, Entity entity, Supplier<Double> heightProvider) {
        ItemEntity ie;
        block9: {
            block8: {
                if (!CommonConfigs.CAULDRON_HAND_CRAFTING.get().booleanValue()) {
                    return;
                }
                if (!(entity instanceof ItemEntity)) break block8;
                ie = (ItemEntity)entity;
                if (entity.m_20096_()) break block9;
            }
            return;
        }
        ie.m_32010_(ie.f_31986_ + 1);
        List entities = level.m_45976_(ItemEntity.class, new AABB((double)pos.m_123341_() + 0.125, (double)((float)pos.m_123342_() + 0.375f), (double)pos.m_123343_() + 0.125, (double)pos.m_123341_() + 0.875, (double)pos.m_123342_() + heightProvider.get(), (double)pos.m_123343_() + 0.875));
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (ItemEntity e : entities) {
            ingredients.add(e.m_32055_());
        }
        SoftFluidStack cauldronFluid = CommonCauldronCode.getFluidOrWater(state, pos, (LevelAccessor)level);
        FluidAndItemCraftResult craftResult = CauldronRecipeUtils.craft(level, (Boolean)state.m_61143_((Property)ModCauldronBlock.BOILING), 3, cauldronFluid, ingredients);
        if (craftResult == null) {
            return;
        }
        SoftFluidStack resultFluid = craftResult.resultFluid();
        if (cauldronFluid.is((Holder)BuiltInSoftFluids.WATER) && cauldronFluid.getCount() == 3 && resultFluid.getCount() == 3 && PlatHelper.getPlatform().isForge()) {
            resultFluid.setCount(4);
        }
        CommonCauldronCode.playCraftSound(pos, level, cauldronFluid, resultFluid);
        CauldronConversion.setCorrectCauldronStateAndTile(state, level, pos, resultFluid);
        level.m_142346_(entity, GameEvent.f_157792_, pos);
        level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 0.9f, 0.6f);
        CommonCauldronCode.spawnResultItems(level, pos, List.of(craftResult.craftedItem()));
        for (ItemEntity e : entities) {
            if (!e.m_32055_().m_41619_()) continue;
            e.m_146870_();
        }
    }

    private static void spawnResultItems(Level level, BlockPos pos, List<ItemStack> itemStacks) {
        if (itemStacks.isEmpty()) {
            return;
        }
        for (ItemStack item : itemStacks) {
            ItemEntity iteEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, item);
            iteEntity.m_32060_();
            iteEntity.m_20334_(level.f_46441_.m_188583_() * 0.01, 0.375, level.f_46441_.m_188583_() * 0.01);
            level.m_7967_((Entity)iteEntity);
        }
    }

    public static boolean attemptPlayerCrafting(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, int tankCapacity, SoftFluidStack currentFluid) {
        if (!CommonConfigs.CAULDRON_HAND_CRAFTING.get().booleanValue()) {
            return false;
        }
        ItemStack playerStack = player.m_21120_(hand);
        FluidAndItemsCraftResult result = CauldronRecipeUtils.craftMultiple(level, (Boolean)state.m_61143_((Property)ModCauldronBlock.BOILING), tankCapacity, currentFluid, List.of(playerStack));
        if (result != null) {
            CommonCauldronCode.playCraftSound(pos, level, currentFluid, result.resultFluid());
            CauldronConversion.setCorrectCauldronStateAndTile(state, level, pos, result.resultFluid());
            CommonCauldronCode.onPlayerCrafted(level, pos, player, hand, playerStack, result.craftedItems());
            return true;
        }
        return false;
    }

    private static void onPlayerCrafted(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack playerItem, List<ItemStack> craftedItems) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        player.m_36246_(Stats.f_12982_.m_12902_((Object)playerItem.m_41720_()));
        CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, playerItem);
        for (ItemStack crafted : craftedItems) {
            Utils.addItemOrDrop((Player)player, (ItemStack)crafted, (InvPlacer)InvPlacer.handOrExistingOrAny((InteractionHand)hand));
        }
    }

    private static void playCraftSound(BlockPos pos, Level level, SoftFluidStack oldStack, SoftFluidStack newStack) {
        if (oldStack.fluid() != newStack.fluid()) {
            level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 0.9f, 0.6f);
        } else {
            level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.3f);
        }
    }
}

