/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.items.SlotItemHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.RepeatMode;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class JukeboxUpgradeContainer
extends UpgradeContainerBase<JukeboxUpgradeWrapper, JukeboxUpgradeContainer> {
    private static final String ACTION_DATA = "action";

    public JukeboxUpgradeContainer(final Player player, int upgradeContainerId, final JukeboxUpgradeWrapper upgradeWrapper, UpgradeContainerType<JukeboxUpgradeWrapper, JukeboxUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        for (int slot = 0; slot < upgradeWrapper.getDiscInventory().getSlots(); ++slot) {
            this.slots.add(new SlotItemHandler(upgradeWrapper.getDiscInventory(), slot, -100, -100){

                public void m_6654_() {
                    super.m_6654_();
                    if (upgradeWrapper.isPlaying() && this.getSlotIndex() == upgradeWrapper.getDiscSlotActive()) {
                        upgradeWrapper.stop((LivingEntity)player);
                    }
                }
            });
        }
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(ACTION_DATA)) {
            String actionName;
            switch (actionName = data.m_128461_(ACTION_DATA)) {
                case "play": {
                    AbstractContainerMenu abstractContainerMenu = this.player.f_36096_;
                    if (!(abstractContainerMenu instanceof StorageContainerMenuBase)) break;
                    StorageContainerMenuBase storageContainerMenu = (StorageContainerMenuBase)abstractContainerMenu;
                    storageContainerMenu.getBlockPosition().ifPresentOrElse(pos -> ((JukeboxUpgradeWrapper)this.upgradeWrapper).play(this.player.m_9236_(), (BlockPos)pos), () -> ((JukeboxUpgradeWrapper)this.upgradeWrapper).play(storageContainerMenu.getEntity().orElse((Entity)this.player)));
                    break;
                }
                case "stop": {
                    ((JukeboxUpgradeWrapper)this.upgradeWrapper).stop((LivingEntity)this.player);
                    break;
                }
                case "next": {
                    ((JukeboxUpgradeWrapper)this.upgradeWrapper).next();
                    break;
                }
                case "previous": {
                    ((JukeboxUpgradeWrapper)this.upgradeWrapper).previous();
                }
            }
        }
        if (data.m_128441_("shuffle")) {
            ((JukeboxUpgradeWrapper)this.upgradeWrapper).setShuffleEnabled(data.m_128471_("shuffle"));
        }
        if (data.m_128441_("repeat")) {
            NBTHelper.getEnumConstant(data, "repeat", RepeatMode::fromName).ifPresent(((JukeboxUpgradeWrapper)this.upgradeWrapper)::setRepeatMode);
        }
    }

    public void play() {
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_DATA, "play"));
    }

    public void stop() {
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_DATA, "stop"));
    }

    public void next() {
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_DATA, "next"));
    }

    public void previous() {
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_DATA, "previous"));
    }

    public boolean isShuffleEnabled() {
        return ((JukeboxUpgradeWrapper)this.upgradeWrapper).isShuffleEnabled();
    }

    public void toggleShuffle() {
        boolean newValue = !((JukeboxUpgradeWrapper)this.upgradeWrapper).isShuffleEnabled();
        ((JukeboxUpgradeWrapper)this.upgradeWrapper).setShuffleEnabled(newValue);
        this.sendBooleanToServer("shuffle", newValue);
    }

    public RepeatMode getRepeatMode() {
        return ((JukeboxUpgradeWrapper)this.upgradeWrapper).getRepeatMode();
    }

    public void toggleRepeat() {
        RepeatMode newValue = ((JukeboxUpgradeWrapper)this.upgradeWrapper).getRepeatMode().next();
        ((JukeboxUpgradeWrapper)this.upgradeWrapper).setRepeatMode(newValue);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundTag(), "repeat", newValue));
    }

    public Optional<Slot> getDiscSlotActive() {
        int discSlotActive = ((JukeboxUpgradeWrapper)this.upgradeWrapper).getDiscSlotActive();
        return discSlotActive > -1 ? Optional.of((Slot)this.slots.get(discSlotActive)) : Optional.empty();
    }

    public long getDiscFinishTime() {
        return ((JukeboxUpgradeWrapper)this.upgradeWrapper).getDiscFinishTime();
    }
}

